/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.jackrabbit.util.ISO9075;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.home.workspace.folder.items.Query;
import org.gcube.common.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.common.homelibrary.util.MimeTypeUtil;
import org.gcube.common.homelibrary.util.WorkspaceUtil;

public abstract class JCRAbstractWorkspaceFolder
extends JCRWorkspaceItem
implements WorkspaceFolder {
    public JCRAbstractWorkspaceFolder(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public JCRAbstractWorkspaceFolder(JCRWorkspace workspace, ItemDelegate node, String name, String description) throws RepositoryException {
        super(workspace, node, name, description);
    }

    @Override
    public String getRemotePath() throws InternalErrorException {
        String remotePath = null;
        List<WorkspaceItem> children = this.getChildren();
        for (WorkspaceItem child : children) {
            if (child.isFolder()) continue;
            String path = child.getRemotePath();
            remotePath = path.substring(0, path.lastIndexOf(47) + 1);
            break;
        }
        return remotePath;
    }

    public JCRWorkspace getWorkspace() {
        return this.workspace;
    }

    public abstract WorkspaceItemType getType();

    public boolean exists(String name) throws InternalErrorException {
        try {
            return this.workspace.exists(name, this.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceItem find(String name) throws InternalErrorException {
        try {
            return this.workspace.find(name, this.getId());
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkspaceItem> getChildren() {
        ArrayList<WorkspaceItem> children = new ArrayList<WorkspaceItem>();
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            List<ItemDelegate> folderNode = servlets.getChildrenById(this.getId());
            for (ItemDelegate itemDelegate : folderNode) {
                JCRWorkspaceItem item = this.workspace.getWorkspaceItem(itemDelegate);
                children.add(item);
            }
        }
        catch (Exception e) {
            logger.error("No nodes retrieved", (Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
        return children;
    }

    public WorkspaceFolder createFolder(String name, String description) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            return this.workspace.createFolder(name, description, this.getId());
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ExternalImage createExternalImageItem(String name, String description, String mimeType, InputStream imageData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalImage(name, description, mimeType, imageData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ExternalImage createExternalImageItem(String name, String description, String mimeType, File tmpFile) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        ExternalImage image;
        try {
            image = this.workspace.createExternalImage(name, description, mimeType, this.getId(), tmpFile);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return image;
    }

    public ExternalFile createExternalFileItem(String name, String description, String mimeType, InputStream fileData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalFile(name, description, mimeType, fileData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ExternalFile createExternalFileItem(String name, String description, String mimeType, File tmpFile) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        ExternalFile file;
        try {
            file = this.workspace.createExternalFile(name, description, mimeType, tmpFile, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return file;
    }

    public FolderItem createExternalFileItem(String name, String description, String mimeType, String storageId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        File tmpFile = null;
        try {
            String mimeTypeChecked;
            InputStream is = this.workspace.getStorage().getRemoteFile(storageId, this.workspace.getOwner().getPortalLogin());
            tmpFile = WorkspaceUtil.getTmpFile((InputStream)is);
            if (mimeType == null) {
                try {
                    mimeType = MimeTypeUtil.getMimeType((String)name, (File)tmpFile);
                }
                catch (Exception e) {
                    logger.error("Error detecting mimeType of " + name);
                }
            }
            if ((mimeTypeChecked = mimeType) != null) {
                if (mimeTypeChecked.startsWith("image")) {
                    return this.createExternalImageItem(name, description, mimeTypeChecked, tmpFile);
                }
                if (mimeTypeChecked.equals("application/pdf")) {
                    return this.createExternalPDFFileItem(name, description, mimeTypeChecked, tmpFile);
                }
                if (mimeTypeChecked.equals("text/uri-list")) {
                    return this.createExternalUrlItem(name, description, tmpFile);
                }
                return this.createExternalFileItem(name, description, mimeTypeChecked, tmpFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createExternalFileItem(name, description, mimeType, tmpFile);
    }

    public ExternalPDFFile createExternalPDFFileItem(String name, String description, String mimeType, InputStream fileData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalPDFFile(name, description, mimeType, fileData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ExternalPDFFile createExternalPDFFileItem(String name, String description, String mimeType, File tmpFile) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        ExternalPDFFile pdf;
        try {
            pdf = this.workspace.createExternalPDFFile(name, description, mimeType, tmpFile, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return pdf;
    }

    public ExternalUrl createExternalUrlItem(String name, String description, String url) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalUrl(name, description, url, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ExternalUrl createExternalUrlItem(String name, String description, InputStream url) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalUrl(name, description, url, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ExternalUrl createExternalUrlItem(String name, String description, File tmpFile) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        ExternalUrl url;
        try {
            url = this.workspace.createExternalUrl(name, description, tmpFile, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return url;
    }

    public FolderBulkCreator getNewFolderBulkCreator() throws InternalErrorException {
        try {
            return this.workspace.getNewFolderBulkCreator(this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void removeChild(WorkspaceItem child) throws InternalErrorException, InsufficientPrivilegesException {
        try {
            this.workspace.removeItem(child.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUniqueName(String initialName, boolean copy) throws InternalErrorException {
        block12: {
            JCRServlets servlets = null;
            try {
                int i;
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                ItemDelegate folderNode = servlets.getItemById(this.getId());
                ItemDelegate node = null;
                try {
                    node = this.getNode(folderNode, initialName);
                }
                catch (Exception e) {
                    String string = initialName;
                    servlets.releaseSession();
                    return string;
                }
                String name = null;
                if (node == null) break block12;
                if (copy) {
                    i = 1;
                    while (node != null) {
                        name = i == 1 ? initialName + " (copy)" : initialName + " (copy " + i + ")";
                        node = this.getNode(folderNode, name);
                        ++i;
                    }
                } else {
                    i = 0;
                    while (node != null) {
                        name = initialName + "(" + i + ")";
                        node = this.getNode(folderNode, name);
                        ++i;
                    }
                }
                String string = name;
                return string;
            }
            catch (Exception e) {
                logger.error("problem creating a unique name for " + initialName);
            }
            finally {
                servlets.releaseSession();
            }
        }
        return initialName;
    }

    private ItemDelegate getNode(ItemDelegate folderNode, String initialName) throws RepositoryException {
        ItemDelegate node = null;
        DelegateManager wrap = new DelegateManager(folderNode, this.workspace.getOwner().getPortalLogin());
        try {
            node = wrap.getNode(initialName);
        }
        catch (Exception e) {
            logger.info("No item found with name \"" + initialName + "\" in folder " + folderNode.getPath());
            return null;
        }
        return node;
    }

    public int getCount() throws InternalErrorException {
        String remotePath = null;
        try {
            remotePath = this.getRemotePath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (remotePath != null) {
            return this.workspace.getStorage().getFolderTotalItems(remotePath, this.workspace.getOwner().getPortalLogin());
        }
        return 0;
    }

    public long getSize() throws InternalErrorException {
        String remotePath = null;
        try {
            remotePath = this.getRemotePath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (remotePath != null) {
            return this.workspace.getStorage().getFolderTotalVolume(remotePath, this.workspace.getOwner().getPortalLogin());
        }
        return 0L;
    }

    public List<WorkspaceItem> getLastItems(int limit) throws InternalErrorException {
        JCRServlets servlets = null;
        LinkedList<WorkspaceItem> list = null;
        ArrayList<String> ids = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            String path = this.getPath();
            String query = "/jcr:root/Home/" + this.workspace.getOwner().getPortalLogin() + ISO9075.encodePath((String)path) + "//element(*,nthl:workspaceItem) order by @jcr:lastModified descending";
            logger.info("Query: " + query);
            List<SearchItemDelegate> itemDelegateList = null;
            try {
                itemDelegateList = servlets.executeQuery(query, "xpath", limit);
            }
            catch (HttpException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (IOException e) {
                throw new InternalErrorException((Throwable)e);
            }
            list = new LinkedList<WorkspaceItem>();
            ids = new ArrayList<String>();
            int i = 0;
            for (SearchItemDelegate searchItem : itemDelegateList) {
                if (i >= limit) continue;
                String type = searchItem.getPrimaryType();
                try {
                    String id;
                    if (type.equals("nthl:workspaceItem") || type.equals("nthl:workspaceSharedItem") || type.equals("nthl:trashItem") || ids.contains(id = searchItem.getId())) continue;
                    list.add(this.workspace.getItem(id));
                    ids.add(id);
                    ++i;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            logger.error("Error getLastItems ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
        return list;
    }

    public ReportTemplate createReportTemplateItem(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, int numberOfSections, String status, InputStream templateData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createReportTemplate(name, description, created, lastEdit, author, lastEditBy, numberOfSections, status, templateData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Report createReportItem(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, String templateName, int numberOfSections, String status, InputStream reportData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createReport(name, description, created, lastEdit, author, lastEditBy, templateName, numberOfSections, status, reportData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Query createQueryItem(String name, String description, String query, QueryType queryType) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createQuery(name, description, query, queryType, this.getId());
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Query createQueryItem(String name, String description, InputStream query, QueryType queryType) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createQuery(name, description, query, queryType, this.getId());
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public TimeSeries createTimeSeries(String name, String description, String timeseriesId, String title, String creator, String timeseriesDescription, String timeseriesCreationDate, String publisher, String sourceId, String sourceName, String rights, long dimension, List<String> headerLabels, InputStream compressedCSV) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createTimeSeries(name, description, timeseriesId, title, creator, timeseriesDescription, timeseriesCreationDate, publisher, sourceId, sourceName, rights, dimension, headerLabels, compressedCSV, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }
}

