/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.resourcemanager.memoization;

import com.google.common.cache.CacheStats;
import java.util.concurrent.TimeUnit;
import org.gcube.rest.resourcemanager.memoization.Cache;

public class GuavaCache
implements Cache {
    private final com.google.common.cache.Cache<Object, Object> cache;

    private GuavaCache(com.google.common.cache.Cache<Object, Object> cache) {
        this.cache = cache;
    }

    @Override
    public Object get(Object key) {
        return this.cache.getIfPresent(key);
    }

    @Override
    public void put(Object key, Object value) {
        this.cache.put(key, value);
    }

    @Override
    public CacheStats stats() {
        return this.cache.stats();
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    public static class CacheBuilder {
        private Long maximumSize;
        private Long expirationDuration;
        private TimeUnit unit;

        public CacheBuilder maximumSize(Long maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        public CacheBuilder expireAfterWrite(Long duration, TimeUnit unit) {
            this.expirationDuration = duration;
            this.unit = unit;
            return this;
        }

        public GuavaCache build() {
            com.google.common.cache.CacheBuilder cacheBuilder = com.google.common.cache.CacheBuilder.newBuilder();
            if (this.maximumSize != null) {
                cacheBuilder.maximumSize(this.maximumSize.longValue());
            }
            if (this.expirationDuration != null && this.unit != null) {
                cacheBuilder.expireAfterWrite(this.expirationDuration.longValue(), this.unit);
            }
            return new GuavaCache(cacheBuilder.recordStats().build());
        }
    }
}

