/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.Flag;
import com.sun.pdfview.PDFPage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.JPanel;

public class PagePanel
extends JPanel
implements ImageObserver,
MouseListener,
MouseMotionListener {
    Image currentImage;
    PDFPage currentPage;
    AffineTransform currentXform;
    int offx;
    int offy;
    Rectangle2D clip;
    Rectangle2D prevClip;
    Dimension prevSize;
    Rectangle zoomRect;
    boolean useZoom = false;
    Flag flag = new Flag();
    int downx;
    int downy;

    public PagePanel() {
        this.setPreferredSize(new Dimension(800, 600));
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public synchronized void showPage(PDFPage page) {
        if (this.currentPage != null && this.prevSize != null) {
            this.currentPage.stop(this.prevSize.width, this.prevSize.height, this.prevClip);
        }
        this.currentPage = page;
        if (page == null) {
            this.currentImage = null;
            this.clip = null;
            this.currentXform = null;
            this.repaint();
        } else {
            this.flag.clear();
            Dimension sz = this.getSize();
            if (sz.width + sz.height == 0) {
                return;
            }
            Rectangle2D useClip = this.clip;
            if (this.clip != null && this.currentXform != null) {
                useClip = this.currentXform.createTransformedShape(this.clip).getBounds2D();
            }
            Dimension pageSize = page.getUnstretchedSize(sz.width, sz.height, useClip);
            this.currentImage = page.getImage(pageSize.width, pageSize.height, useClip, this);
            this.currentXform = page.getInitialTransform(pageSize.width, pageSize.height, useClip);
            try {
                this.currentXform = this.currentXform.createInverse();
            }
            catch (NoninvertibleTransformException nte) {
                System.out.println("Error inverting page transform!");
                nte.printStackTrace();
            }
            this.prevClip = useClip;
            this.prevSize = pageSize;
            this.repaint();
        }
    }

    public synchronized void flush() {
    }

    public void paint(Graphics g) {
        Dimension sz = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.currentImage == null) {
            g.setColor(Color.black);
            g.drawString("No page selected", this.getWidth() / 2 - 30, this.getHeight() / 2);
        } else {
            int imwid = this.currentImage.getWidth(null);
            int imhgt = this.currentImage.getHeight(null);
            this.offx = (sz.width - imwid) / 2;
            this.offy = (sz.height - imhgt) / 2;
            if (imwid == sz.width && imhgt <= sz.height || imhgt == sz.height && imwid <= sz.width) {
                g.drawImage(this.currentImage, this.offx, this.offy, this);
            } else {
                this.flush();
                if (this.currentPage != null) {
                    this.showPage(this.currentPage);
                }
                g.setColor(Color.red);
                g.drawLine(0, 0, this.getWidth(), this.getHeight());
                g.drawLine(0, this.getHeight(), this.getWidth(), 0);
            }
        }
        if (this.zoomRect != null) {
            g.setColor(Color.red);
            g.drawRect(this.zoomRect.x, this.zoomRect.y, this.zoomRect.width, this.zoomRect.height);
        }
    }

    public PDFPage getPage() {
        return this.currentPage;
    }

    public Dimension getCurSize() {
        return this.prevSize;
    }

    public Rectangle2D getCurClip() {
        return this.prevClip;
    }

    public void waitForCurrentPage() {
        this.flag.waitForFlag();
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        Dimension sz = this.getSize();
        if ((infoflags & 0x28) != 0) {
            this.repaint(x + this.offx, y + this.offy, width, height);
        }
        if ((infoflags & 0xE0) != 0) {
            this.flag.set();
            return false;
        }
        return true;
    }

    public void useZoomTool(boolean use) {
        this.useZoom = use;
    }

    public void setClip(Rectangle2D clip) {
        this.clip = clip;
        this.showPage(this.currentPage);
    }

    public void mousePressed(MouseEvent evt) {
        this.downx = evt.getX();
        this.downy = evt.getY();
    }

    public void mouseReleased(MouseEvent evt) {
        if (!this.useZoom || this.zoomRect == null || this.zoomRect.width == 0 || this.zoomRect.height == 0) {
            this.zoomRect = null;
            return;
        }
        this.setClip(new Rectangle2D.Double(this.zoomRect.x - this.offx, this.zoomRect.y - this.offy, this.zoomRect.width, this.zoomRect.height));
        this.zoomRect = null;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.useZoom) {
            int x = evt.getX();
            int y = evt.getY();
            int dx = Math.abs(x - this.downx);
            int dy = Math.abs(y - this.downy);
            if ((evt.getModifiers() & 1) == 0) {
                float aspect = (float)dx / (float)dy;
                float waspect = (float)this.getWidth() / (float)this.getHeight();
                if (aspect > waspect) {
                    dy = (int)((float)dx / waspect);
                } else {
                    dx = (int)((float)dy * waspect);
                }
            }
            if (x < this.downx) {
                x = this.downx - dx;
            }
            if (y < this.downy) {
                y = this.downy - dy;
            }
            Rectangle old = this.zoomRect;
            this.zoomRect = dx < 5 || dy < 5 ? null : new Rectangle(Math.min(this.downx, x), Math.min(this.downy, y), dx, dy);
            if (this.zoomRect != null) {
                if (old != null) {
                    old.add(this.zoomRect);
                } else {
                    old = new Rectangle(this.zoomRect);
                }
            }
            if (old != null) {
                ++old.width;
                ++old.height;
            }
            if (old != null) {
                this.repaint(old);
            }
        }
    }
}

