/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

public class SystemUtil {
    public static final String USER_DIR = "user.dir";
    public static final String JAVA_HOME = "java.home";
    public static final String TEMP_DIR = "java.io.tmpdir";
    public static final String OS_NAME = "os.name";
    public static final String OS_VERSION = "os.version";
    public static final String JAVA_VERSION = "java.version";
    public static final String JAVA_SPECIFICATION_VERSION = "java.specification.version";
    public static final String JAVA_VENDOR = "java.vendor";
    public static final String JAVA_CLASSPATH = "java.class.path";
    public static final String PATH_SEPARATOR = "path.separator";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String FILE_ENCODING = "file.encoding";

    public static double systemTimerResolution() {
        int sumres = 0;
        System.gc();
        int loops = 20;
        for (int i = 0; i < loops; ++i) {
            long t2;
            long t1 = System.currentTimeMillis();
            while ((t2 = System.currentTimeMillis()) == t1) {
            }
            sumres += (int)(t2 - t1);
        }
        return (double)sumres / (double)loops;
    }

    public static String getUserDir() {
        return System.getProperty(USER_DIR);
    }

    public static String getWorkingFolder() {
        return System.getProperty(USER_DIR);
    }

    public static String getJavaJreHome() {
        return System.getProperty(JAVA_HOME);
    }

    public static String getJavaHome() {
        String home = System.getProperty(JAVA_HOME);
        if (home == null) {
            return null;
        }
        int i = home.lastIndexOf(92);
        int j = home.lastIndexOf(47);
        if (j > i) {
            i = j;
        }
        return home.substring(0, i);
    }

    public static String getTempDir() {
        return System.getProperty(TEMP_DIR);
    }

    public static String getOsName() {
        return System.getProperty(OS_NAME);
    }

    public static String getOsVersion() {
        return System.getProperty(OS_VERSION);
    }

    public static String getJavaVersion() {
        return System.getProperty(JAVA_VERSION);
    }

    public static double getJavaSpecificationVersion() {
        return Double.parseDouble(System.getProperty(JAVA_SPECIFICATION_VERSION));
    }

    public static String getJavaVendor() {
        return System.getProperty(JAVA_VENDOR);
    }

    public static String getClassPath() {
        return System.getProperty(JAVA_CLASSPATH);
    }

    public static String getPathSeparator() {
        return System.getProperty(PATH_SEPARATOR);
    }

    public static String getFileEncoding() {
        return System.getProperty(FILE_ENCODING);
    }

    public static boolean isAtLeastJdk15() {
        return SystemUtil.getJavaSpecificationVersion() >= 1.5;
    }

    public static boolean isAtLeastJdk16() {
        return SystemUtil.getJavaSpecificationVersion() >= 1.6;
    }

    public static void setHttpProxy(String host, String port, String username, String password) {
        System.getProperties().put(HTTP_PROXY_HOST, host);
        System.getProperties().put(HTTP_PROXY_PORT, port);
        System.getProperties().put(HTTP_PROXY_USER, username);
        System.getProperties().put(HTTP_PROXY_PASSWORD, password);
    }

    public static void setHttpProxy(String host, String port) {
        System.getProperties().put(HTTP_PROXY_HOST, host);
        System.getProperties().put(HTTP_PROXY_PORT, port);
    }
}

