/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jodd.io.FastByteArrayOutputStream;
import jodd.servlet.ServletUtil;
import jodd.servlet.upload.FileUpload;
import jodd.servlet.upload.FileUploadFactory;
import jodd.servlet.upload.FileUploadHeader;
import jodd.servlet.upload.MultipartRequestInputStream;
import jodd.servlet.upload.impl.MemoryFileUploadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartRequest {
    private Map<String, String[]> requestParameters;
    private Map<String, FileUpload[]> requestFiles;
    private HttpServletRequest request;
    private String characterEncoding;
    private FileUploadFactory fileUploadFactory;
    private static final String MREQ_ATTR_NAME = "jodd.servlet.upload.MultipartRequest";
    private boolean loaded;

    public HttpServletRequest getServletRequest() {
        return this.request;
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public MultipartRequest(HttpServletRequest request) {
        this(request, null, null);
    }

    public MultipartRequest(HttpServletRequest request, FileUploadFactory fileUploadFactory) {
        this(request, fileUploadFactory, null);
    }

    public MultipartRequest(HttpServletRequest request, String encoding) {
        this(request, null, encoding);
    }

    public MultipartRequest(HttpServletRequest request, FileUploadFactory fileUploadFactory, String encoding) {
        this.request = request;
        this.characterEncoding = encoding != null ? encoding : request.getCharacterEncoding();
        this.fileUploadFactory = fileUploadFactory == null ? new MemoryFileUploadFactory() : fileUploadFactory;
    }

    public static MultipartRequest getInstance(HttpServletRequest request, FileUploadFactory fileUploadFactory, String encoding) {
        MultipartRequest mreq = (MultipartRequest)request.getAttribute(MREQ_ATTR_NAME);
        if (mreq == null) {
            mreq = new MultipartRequest(request, fileUploadFactory, encoding);
            request.setAttribute(MREQ_ATTR_NAME, (Object)mreq);
        }
        return mreq;
    }

    public static MultipartRequest getParsedInstance(HttpServletRequest request, FileUploadFactory fileUploadFactory, String encoding) throws IOException {
        MultipartRequest mreq = MultipartRequest.getInstance(request, fileUploadFactory, encoding);
        if (!mreq.isLoaded()) {
            mreq.parseRequest();
        }
        return mreq;
    }

    public static MultipartRequest getInstance(HttpServletRequest request, String encoding) {
        return MultipartRequest.getInstance(request, null, encoding);
    }

    public static MultipartRequest getParsedInstance(HttpServletRequest request, String encoding) throws IOException {
        MultipartRequest mreq = MultipartRequest.getInstance(request, null, encoding);
        if (!mreq.isLoaded()) {
            mreq.parseRequest();
        }
        return mreq;
    }

    public static MultipartRequest getInstance(HttpServletRequest request, FileUploadFactory fileUploadFactory) {
        return MultipartRequest.getInstance(request, fileUploadFactory, null);
    }

    public static MultipartRequest getParsedInstance(HttpServletRequest request, FileUploadFactory fileUploadFactory) throws IOException {
        MultipartRequest mreq = MultipartRequest.getInstance(request, fileUploadFactory, null);
        if (!mreq.isLoaded()) {
            mreq.parseRequest();
        }
        return mreq;
    }

    public static MultipartRequest getInstance(HttpServletRequest request) {
        return MultipartRequest.getInstance(request, null, null);
    }

    public static MultipartRequest getParsedInstance(HttpServletRequest request) throws IOException {
        MultipartRequest mreq = MultipartRequest.getInstance(request, null, null);
        if (!mreq.isLoaded()) {
            mreq.parseRequest();
        }
        return mreq;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void parseMultipartRequest() throws IOException {
        if (this.loaded) {
            throw new IOException("Multi-part request already loaded and parsed.");
        }
        this.loaded = true;
        this.requestParameters = new HashMap<String, String[]>();
        this.requestFiles = new HashMap<String, FileUpload[]>();
        this.parseRequestStream(this.request, this.characterEncoding);
    }

    public void parseRequest() throws IOException {
        if (this.loaded) {
            throw new IOException("Multi-part request already loaded and parsed.");
        }
        this.loaded = true;
        this.requestParameters = new HashMap<String, String[]>();
        this.requestFiles = new HashMap<String, FileUpload[]>();
        if (ServletUtil.isMultipartRequest(this.request)) {
            this.parseRequestStream(this.request, this.characterEncoding);
        } else {
            Enumeration names = this.request.getParameterNames();
            while (names.hasMoreElements()) {
                String paramName = (String)names.nextElement();
                String[] values = this.request.getParameterValues(paramName);
                this.requestParameters.put(paramName, values);
            }
        }
    }

    public String getParameter(String paramName) {
        String[] values = this.requestParameters.get(paramName);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Set<String> getParameterNames() {
        return this.requestParameters.keySet();
    }

    public String[] getParameterValues(String paramName) {
        return this.requestParameters.get(paramName);
    }

    public FileUpload getFile(String paramName) {
        FileUpload[] values = this.requestFiles.get(paramName);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public FileUpload[] getFiles(String paramName) {
        return this.requestFiles.get(paramName);
    }

    public Set<String> getFileParameterNames() {
        return this.requestFiles.keySet();
    }

    private void putFile(Map<String, List<FileUpload>> destination, String name, FileUpload value) {
        List<FileUpload> valuesList = destination.get(name);
        if (valuesList == null) {
            valuesList = new ArrayList<FileUpload>();
            destination.put(name, valuesList);
        }
        valuesList.add(value);
    }

    private void putString(Map<String, List<String>> destination, String name, String value) {
        List<String> valuesList = destination.get(name);
        if (valuesList == null) {
            valuesList = new ArrayList<String>();
            destination.put(name, valuesList);
        }
        valuesList.add(value);
    }

    protected void parseRequestStream(HttpServletRequest request, String encoding) throws IOException {
        int i;
        Object[] result;
        List valuesList;
        FileUploadHeader header;
        HashMap<String, List<String>> reqParam = new HashMap<String, List<String>>();
        HashMap<String, List<FileUpload>> reqFiles = new HashMap<String, List<FileUpload>>();
        MultipartRequestInputStream input = new MultipartRequestInputStream((InputStream)request.getInputStream());
        input.readBoundary();
        while ((header = input.readDataHeader(encoding)) != null) {
            if (header.isFile) {
                String fileName = header.fileName;
                if (fileName.length() > 0 && header.contentType.indexOf("application/x-macbinary") > 0) {
                    input.skipBytes(128);
                }
                FileUpload newFile = this.fileUploadFactory.create(input);
                newFile.processStream();
                if (fileName.length() == 0) {
                    // empty if block
                }
                this.putFile(reqFiles, header.formFieldName, newFile);
            } else {
                FastByteArrayOutputStream fbos = new FastByteArrayOutputStream();
                input.copyAll(fbos);
                String value = new String(fbos.toByteArray(), encoding);
                this.putString(reqParam, header.formFieldName, value);
            }
            input.skipBytes(1);
            input.mark(1);
            if (input.readByte() == 45) {
                input.reset();
                break;
            }
            input.reset();
        }
        for (String paramName : reqParam.keySet()) {
            valuesList = (List)reqParam.get(paramName);
            if (valuesList == null) continue;
            result = new String[valuesList.size()];
            for (i = 0; i < result.length; ++i) {
                result[i] = (String)valuesList.get(i);
            }
            this.requestParameters.put(paramName, (String[])result);
        }
        for (String paramName : reqFiles.keySet()) {
            valuesList = (List)reqFiles.get(paramName);
            if (valuesList == null) continue;
            result = new FileUpload[valuesList.size()];
            for (i = 0; i < result.length; ++i) {
                result[i] = (FileUpload)valuesList.get(i);
            }
            this.requestFiles.put(paramName, (FileUpload[])result);
        }
    }
}

