/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import jodd.JoddDefault;
import jodd.servlet.ServletUtil;
import jodd.servlet.UrlBuilder;

public class UrlEncoder {
    protected static final char[][] URL = new char[256][];

    public static String url(String value, PageContext pageContext) {
        return UrlEncoder.url(value, JoddDefault.encoding, (HttpServletRequest)pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse());
    }

    public static String url(String value, String encoding, PageContext pageContext) {
        return UrlEncoder.url(value, encoding, (HttpServletRequest)pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse());
    }

    public static String url(String value, HttpServletRequest request, HttpServletResponse response) {
        return UrlEncoder.url(value, JoddDefault.encoding, request, response);
    }

    public static String url(String value, String encoding, HttpServletRequest request, HttpServletResponse response) {
        String result = ServletUtil.resolveUrl(UrlEncoder.url(value, encoding), request);
        if (!ServletUtil.isAbsoluteUrl(result)) {
            result = response.encodeURL(result);
        }
        return result;
    }

    public static String url(String url) {
        return UrlEncoder.url(url, JoddDefault.encoding);
    }

    public static String url(String url, String encoding) {
        int paramNdx = url.indexOf(63);
        if (paramNdx == -1) {
            return url;
        }
        StringBuilder result = new StringBuilder(url.length() >> 1);
        result.append(url.substring(0, ++paramNdx));
        while (true) {
            int ampNdx;
            String q;
            int eqNdx;
            if ((eqNdx = (q = (ampNdx = url.indexOf(38, paramNdx)) == -1 ? url.substring(paramNdx) : url.substring(paramNdx, ampNdx)).indexOf(61)) == -1) {
                result.append(q);
            } else {
                String name = q.substring(0, eqNdx);
                UrlEncoder.appendUrl(result, name, encoding);
                result.append('=');
                String value = q.substring(eqNdx + 1);
                if (value.length() > 0) {
                    UrlEncoder.appendUrl(result, value, encoding);
                }
            }
            if (ampNdx == -1) break;
            result.append('&');
            paramNdx = ampNdx + 1;
        }
        return result.toString();
    }

    protected static void appendUrl(StringBuilder result, String value, String encoding) {
        byte[] bytes;
        try {
            bytes = value.getBytes(encoding);
        }
        catch (UnsupportedEncodingException ueex) {
            throw new IllegalArgumentException(ueex.toString());
        }
        for (int n : bytes) {
            int i = n;
            if (i < 0) {
                i += 256;
            }
            result.append(URL[i]);
        }
    }

    public static String encode(String value, String encoding) {
        StringBuilder sb = new StringBuilder(value.length());
        UrlEncoder.appendUrl(sb, value, encoding);
        return sb.toString();
    }

    public static String encode(String value) {
        return UrlEncoder.encode(value, JoddDefault.encoding);
    }

    public static UrlBuilder buildUrl(String url) {
        return new UrlBuilder(url, JoddDefault.encoding, null, null);
    }

    public static UrlBuilder buildUrl(String url, String encoding) {
        return new UrlBuilder(url, encoding, null, null);
    }

    public static UrlBuilder buildUrl(String url, PageContext pageContext) {
        return new UrlBuilder(url, JoddDefault.encoding, (HttpServletRequest)pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse());
    }

    public static UrlBuilder buildUrl(String url, String encoding, PageContext pageContext) {
        return new UrlBuilder(url, encoding, (HttpServletRequest)pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse());
    }

    public static UrlBuilder buildUrl(String url, HttpServletRequest request, HttpServletResponse response) {
        return new UrlBuilder(url, JoddDefault.encoding, request, response);
    }

    public static UrlBuilder buildUrl(String url, String encoding, HttpServletRequest request, HttpServletResponse response) {
        return new UrlBuilder(url, encoding, request, response);
    }

    static {
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            try {
                UrlEncoder.URL[c] = URLEncoder.encode(String.valueOf(c), "ISO-8859-1").toCharArray();
                continue;
            }
            catch (UnsupportedEncodingException ueex) {
                ueex.printStackTrace();
            }
        }
    }
}

