/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.workflowdefinitionlinks.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import java.util.Enumeration;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditWorkflowDefinitionLinkAction
extends PortletAction {
    private static final String _PREFIX = "workflowDefinitionName@";

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.updateWorkflowDefinitionLinks(actionRequest);
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof WorkflowException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.workflow_definition_links.error");
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.workflow_definition_links.view"));
    }

    protected void updateWorkflowDefinitionLink(ActionRequest actionRequest, String className, String value) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        if (Validator.isNull((String)value)) {
            WorkflowDefinitionLinkLocalServiceUtil.deleteWorkflowDefinitionLink((long)themeDisplay.getCompanyId(), (long)groupId, (String)className);
        } else {
            String[] values = StringUtil.split((String)value, (String)"@");
            String workflowDefinitionName = values[0];
            int workflowDefinitionVersion = GetterUtil.getInteger((String)values[1]);
            WorkflowDefinitionLinkLocalServiceUtil.updateWorkflowDefinitionLink((long)themeDisplay.getUserId(), (long)themeDisplay.getCompanyId(), (long)groupId, (String)className, (String)workflowDefinitionName, (int)workflowDefinitionVersion);
        }
    }

    protected void updateWorkflowDefinitionLinks(ActionRequest actionRequest) throws Exception {
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith(_PREFIX)) continue;
            String className = name.substring(_PREFIX.length(), name.length());
            String value = ParamUtil.getString((PortletRequest)actionRequest, (String)name);
            this.updateWorkflowDefinitionLink(actionRequest, className, value);
        }
    }
}

