/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.persistence;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.wiki.NoSuchPageResourceException;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.model.impl.WikiPageResourceImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageResourceModelImpl;
import com.liferay.portlet.wiki.service.persistence.WikiNodePersistence;
import com.liferay.portlet.wiki.service.persistence.WikiPagePersistence;
import com.liferay.portlet.wiki.service.persistence.WikiPageResourcePersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPageResourcePersistenceImpl
extends BasePersistenceImpl<WikiPageResource>
implements WikiPageResourcePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = WikiPageResourceImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List";
    public static final FinderPath FINDER_PATH_FIND_BY_UUID = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByUuid", new String[]{String.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByUuid", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_N_T = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByN_T", new String[]{Long.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_N_T = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByN_T", new String[]{Long.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_ALL = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countAll", new String[0]);
    @BeanReference(type=WikiNodePersistence.class)
    protected WikiNodePersistence wikiNodePersistence;
    @BeanReference(type=WikiPagePersistence.class)
    protected WikiPagePersistence wikiPagePersistence;
    @BeanReference(type=WikiPageResourcePersistence.class)
    protected WikiPageResourcePersistence wikiPageResourcePersistence;
    @BeanReference(type=ResourcePersistence.class)
    protected ResourcePersistence resourcePersistence;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    private static final String _SQL_SELECT_WIKIPAGERESOURCE = "SELECT wikiPageResource FROM WikiPageResource wikiPageResource";
    private static final String _SQL_SELECT_WIKIPAGERESOURCE_WHERE = "SELECT wikiPageResource FROM WikiPageResource wikiPageResource WHERE ";
    private static final String _SQL_COUNT_WIKIPAGERESOURCE = "SELECT COUNT(wikiPageResource) FROM WikiPageResource wikiPageResource";
    private static final String _SQL_COUNT_WIKIPAGERESOURCE_WHERE = "SELECT COUNT(wikiPageResource) FROM WikiPageResource wikiPageResource WHERE ";
    private static final String _FINDER_COLUMN_UUID_UUID_1 = "wikiPageResource.uuid IS NULL";
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "wikiPageResource.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(wikiPageResource.uuid IS NULL OR wikiPageResource.uuid = ?)";
    private static final String _FINDER_COLUMN_N_T_NODEID_2 = "wikiPageResource.nodeId = ? AND ";
    private static final String _FINDER_COLUMN_N_T_TITLE_1 = "wikiPageResource.title IS NULL";
    private static final String _FINDER_COLUMN_N_T_TITLE_2 = "wikiPageResource.title = ?";
    private static final String _FINDER_COLUMN_N_T_TITLE_3 = "(wikiPageResource.title IS NULL OR wikiPageResource.title = ?)";
    private static final String _ORDER_BY_ENTITY_ALIAS = "wikiPageResource.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No WikiPageResource exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No WikiPageResource exists with the key {";
    private static Log _log = LogFactoryUtil.getLog(WikiPageResourcePersistenceImpl.class);

    public void cacheResult(WikiPageResource wikiPageResource) {
        EntityCacheUtil.putResult((boolean)WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey()), (Object)wikiPageResource);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_N_T, (Object[])new Object[]{new Long(wikiPageResource.getNodeId()), wikiPageResource.getTitle()}, (Object)wikiPageResource);
    }

    public void cacheResult(List<WikiPageResource> wikiPageResources) {
        for (WikiPageResource wikiPageResource : wikiPageResources) {
            if (EntityCacheUtil.getResult((boolean)WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey()), (SessionFactory)this) != null) continue;
            this.cacheResult(wikiPageResource);
        }
    }

    public void clearCache() {
        CacheRegistryUtil.clear((String)WikiPageResourceImpl.class.getName());
        EntityCacheUtil.clearCache((String)WikiPageResourceImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
    }

    public void clearCache(WikiPageResource wikiPageResource) {
        EntityCacheUtil.removeResult((boolean)WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey()));
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_N_T, (Object[])new Object[]{new Long(wikiPageResource.getNodeId()), wikiPageResource.getTitle()});
    }

    public WikiPageResource create(long resourcePrimKey) {
        WikiPageResourceImpl wikiPageResource = new WikiPageResourceImpl();
        wikiPageResource.setNew(true);
        wikiPageResource.setPrimaryKey(resourcePrimKey);
        String uuid = PortalUUIDUtil.generate();
        wikiPageResource.setUuid(uuid);
        return wikiPageResource;
    }

    public WikiPageResource remove(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.remove((Long)primaryKey);
    }

    public WikiPageResource remove(long resourcePrimKey) throws NoSuchPageResourceException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            WikiPageResource wikiPageResource = (WikiPageResource)session.get(WikiPageResourceImpl.class, (Serializable)new Long(resourcePrimKey));
            if (wikiPageResource == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + resourcePrimKey));
                }
                throw new NoSuchPageResourceException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + resourcePrimKey);
            }
            WikiPageResource wikiPageResource2 = (WikiPageResource)this.remove((BaseModel)wikiPageResource);
            return wikiPageResource2;
        }
        catch (NoSuchPageResourceException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiPageResource removeImpl(WikiPageResource wikiPageResource) throws SystemException {
        wikiPageResource = this.toUnwrappedModel(wikiPageResource);
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.delete((Session)session, (BaseModel)wikiPageResource);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        WikiPageResourceModelImpl wikiPageResourceModelImpl = (WikiPageResourceModelImpl)wikiPageResource;
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_N_T, (Object[])new Object[]{new Long(wikiPageResourceModelImpl.getNodeId()), wikiPageResourceModelImpl.getTitle()});
        EntityCacheUtil.removeResult((boolean)WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey()));
        return wikiPageResource;
    }

    public WikiPageResource updateImpl(WikiPageResource wikiPageResource, boolean merge) throws SystemException {
        wikiPageResource = this.toUnwrappedModel(wikiPageResource);
        boolean isNew = wikiPageResource.isNew();
        WikiPageResourceModelImpl wikiPageResourceModelImpl = (WikiPageResourceModelImpl)wikiPageResource;
        if (Validator.isNull((String)wikiPageResource.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            wikiPageResource.setUuid(uuid);
        }
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.update((Session)session, (BaseModel)wikiPageResource, (boolean)merge);
                wikiPageResource.setNew(false);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.putResult((boolean)WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, (Serializable)Long.valueOf(wikiPageResource.getPrimaryKey()), (Object)wikiPageResource);
        if (!(isNew || wikiPageResource.getNodeId() == wikiPageResourceModelImpl.getOriginalNodeId() && Validator.equals((Object)wikiPageResource.getTitle(), (Object)wikiPageResourceModelImpl.getOriginalTitle()))) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_N_T, (Object[])new Object[]{new Long(wikiPageResourceModelImpl.getOriginalNodeId()), wikiPageResourceModelImpl.getOriginalTitle()});
        }
        if (isNew || wikiPageResource.getNodeId() != wikiPageResourceModelImpl.getOriginalNodeId() || !Validator.equals((Object)wikiPageResource.getTitle(), (Object)wikiPageResourceModelImpl.getOriginalTitle())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_N_T, (Object[])new Object[]{new Long(wikiPageResource.getNodeId()), wikiPageResource.getTitle()}, (Object)wikiPageResource);
        }
        return wikiPageResource;
    }

    protected WikiPageResource toUnwrappedModel(WikiPageResource wikiPageResource) {
        if (wikiPageResource instanceof WikiPageResourceImpl) {
            return wikiPageResource;
        }
        WikiPageResourceImpl wikiPageResourceImpl = new WikiPageResourceImpl();
        wikiPageResourceImpl.setNew(wikiPageResource.isNew());
        wikiPageResourceImpl.setPrimaryKey(wikiPageResource.getPrimaryKey());
        wikiPageResourceImpl.setUuid(wikiPageResource.getUuid());
        wikiPageResourceImpl.setResourcePrimKey(wikiPageResource.getResourcePrimKey());
        wikiPageResourceImpl.setNodeId(wikiPageResource.getNodeId());
        wikiPageResourceImpl.setTitle(wikiPageResource.getTitle());
        return wikiPageResourceImpl;
    }

    public WikiPageResource findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.findByPrimaryKey((Long)primaryKey);
    }

    public WikiPageResource findByPrimaryKey(long resourcePrimKey) throws NoSuchPageResourceException, SystemException {
        WikiPageResource wikiPageResource = this.fetchByPrimaryKey(resourcePrimKey);
        if (wikiPageResource == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + resourcePrimKey));
            }
            throw new NoSuchPageResourceException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + resourcePrimKey);
        }
        return wikiPageResource;
    }

    public WikiPageResource fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        return this.fetchByPrimaryKey((Long)primaryKey);
    }

    public WikiPageResource fetchByPrimaryKey(long resourcePrimKey) throws SystemException {
        WikiPageResource wikiPageResource = (WikiPageResource)EntityCacheUtil.getResult((boolean)WikiPageResourceModelImpl.ENTITY_CACHE_ENABLED, WikiPageResourceImpl.class, (Serializable)Long.valueOf(resourcePrimKey), (SessionFactory)this);
        if (wikiPageResource == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    wikiPageResource = (WikiPageResource)session.get(WikiPageResourceImpl.class, (Serializable)new Long(resourcePrimKey));
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (wikiPageResource != null) {
                    this.cacheResult(wikiPageResource);
                }
                this.closeSession(session);
            }
        }
        return wikiPageResource;
    }

    public List<WikiPageResource> findByUuid(String uuid) throws SystemException {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<WikiPageResource> findByUuid(String uuid, int start, int end) throws SystemException {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<WikiPageResource> findByUuid(String uuid, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{uuid, String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_UUID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(2);
            query.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (uuid != null) {
                        qPos.add(uuid);
                    }
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_BY_UUID, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_UUID, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public WikiPageResource findByUuid_First(String uuid, OrderByComparator orderByComparator) throws NoSuchPageResourceException, SystemException {
        List<WikiPageResource> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append("}");
            throw new NoSuchPageResourceException(msg.toString());
        }
        return list.get(0);
    }

    public WikiPageResource findByUuid_Last(String uuid, OrderByComparator orderByComparator) throws NoSuchPageResourceException, SystemException {
        int count = this.countByUuid(uuid);
        List<WikiPageResource> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append("}");
            throw new NoSuchPageResourceException(msg.toString());
        }
        return list.get(0);
    }

    public WikiPageResource[] findByUuid_PrevAndNext(long resourcePrimKey, String uuid, OrderByComparator orderByComparator) throws NoSuchPageResourceException, SystemException {
        WikiPageResource wikiPageResource = this.findByPrimaryKey(resourcePrimKey);
        Session session = null;
        try {
            session = this.openSession();
            WikiPageResource[] array = new WikiPageResourceImpl[]{this.getByUuid_PrevAndNext(session, wikiPageResource, uuid, orderByComparator, true), wikiPageResource, this.getByUuid_PrevAndNext(session, wikiPageResource, uuid, orderByComparator, false)};
            WikiPageResource[] wikiPageResourceArray = array;
            return wikiPageResourceArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected WikiPageResource getByUuid_PrevAndNext(Session session, WikiPageResource wikiPageResource, String uuid, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
        if (uuid == null) {
            query.append(_FINDER_COLUMN_UUID_UUID_1);
        } else if (uuid.equals("")) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByFields = orderByComparator.getOrderByFields();
            if (orderByFields.length > 0) {
                query.append(" AND ");
            }
            int i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i;
            }
            query.append(" ORDER BY ");
            i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i;
            }
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (uuid != null) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByValues((Object)wikiPageResource);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (WikiPageResource)list.get(1);
        }
        return null;
    }

    public WikiPageResource findByN_T(long nodeId, String title) throws NoSuchPageResourceException, SystemException {
        WikiPageResource wikiPageResource = this.fetchByN_T(nodeId, title);
        if (wikiPageResource == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("nodeId=");
            msg.append(nodeId);
            msg.append(", title=");
            msg.append(title);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchPageResourceException(msg.toString());
        }
        return wikiPageResource;
    }

    public WikiPageResource fetchByN_T(long nodeId, String title) throws SystemException {
        return this.fetchByN_T(nodeId, title, true);
    }

    public WikiPageResource fetchByN_T(long nodeId, String title, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{nodeId, title};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_N_T, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_WIKIPAGERESOURCE_WHERE);
            query.append(_FINDER_COLUMN_N_T_NODEID_2);
            if (title == null) {
                query.append(_FINDER_COLUMN_N_T_TITLE_1);
            } else if (title.equals("")) {
                query.append(_FINDER_COLUMN_N_T_TITLE_3);
            } else {
                query.append(_FINDER_COLUMN_N_T_TITLE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(nodeId);
                if (title != null) {
                    qPos.add(title);
                }
                List list = q.list();
                result = list;
                WikiPageResource wikiPageResource = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_N_T, (Object[])finderArgs, (Object)list);
                } else {
                    wikiPageResource = (WikiPageResource)list.get(0);
                    this.cacheResult(wikiPageResource);
                    if (wikiPageResource.getNodeId() != nodeId || wikiPageResource.getTitle() == null || !wikiPageResource.getTitle().equals(title)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_N_T, (Object[])finderArgs, (Object)wikiPageResource);
                    }
                }
                WikiPageResource wikiPageResource2 = wikiPageResource;
                return wikiPageResource2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_N_T, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (WikiPageResource)result;
    }

    public List<WikiPageResource> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<WikiPageResource> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<WikiPageResource> findAll(int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_WIKIPAGERESOURCE);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_WIKIPAGERESOURCE;
            }
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    if (orderByComparator == null) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByUuid(String uuid) throws SystemException {
        for (WikiPageResource wikiPageResource : this.findByUuid(uuid)) {
            this.remove((BaseModel)wikiPageResource);
        }
    }

    public void removeByN_T(long nodeId, String title) throws NoSuchPageResourceException, SystemException {
        WikiPageResource wikiPageResource = this.findByN_T(nodeId, title);
        this.remove((BaseModel)wikiPageResource);
    }

    public void removeAll() throws SystemException {
        for (WikiPageResource wikiPageResource : this.findAll()) {
            this.remove((BaseModel)wikiPageResource);
        }
    }

    public int countByUuid(String uuid) throws SystemException {
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_UUID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_WIKIPAGERESOURCE_WHERE);
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (uuid != null) {
                        qPos.add(uuid);
                    }
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_UUID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByN_T(long nodeId, String title) throws SystemException {
        Object[] finderArgs = new Object[]{nodeId, title};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_N_T, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_WIKIPAGERESOURCE_WHERE);
            query.append(_FINDER_COLUMN_N_T_NODEID_2);
            if (title == null) {
                query.append(_FINDER_COLUMN_N_T_TITLE_1);
            } else if (title.equals("")) {
                query.append(_FINDER_COLUMN_N_T_TITLE_3);
            } else {
                query.append(_FINDER_COLUMN_N_T_TITLE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(nodeId);
                    if (title != null) {
                        qPos.add(title);
                    }
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_N_T, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countAll() throws SystemException {
        Object[] finderArgs = new Object[0];
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(_SQL_COUNT_WIKIPAGERESOURCE);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portlet.wiki.model.WikiPageResource")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                String[] stringArray = listenerClassNames;
                int n = listenerClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String listenerClassName = stringArray[n2];
                    listenersList.add((ModelListener)InstanceFactory.newInstance((String)listenerClassName));
                    ++n2;
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)WikiPageResourceImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST);
    }
}

