/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.socialequityadmin.action;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.comparator.ModelResourceComparator;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.social.model.SocialEquityActionMapping;
import com.liferay.portlet.social.model.SocialEquitySetting;
import com.liferay.portlet.social.service.SocialEquityGroupSettingLocalServiceUtil;
import com.liferay.portlet.social.service.SocialEquityLogLocalServiceUtil;
import com.liferay.portlet.social.service.SocialEquitySettingLocalServiceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (cmd.equals("updateRanks")) {
            this.updateRanks(actionRequest);
        } else if (cmd.equals("updateSettings")) {
            this.updateSettings(actionRequest);
        }
        this.sendRedirect(actionRequest, actionResponse);
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        LinkedHashMap<String, List<SocialEquityActionMapping>> equityActionMappingsMap = new LinkedHashMap<String, List<SocialEquityActionMapping>>();
        String[] classNames = PortalUtil.getSocialEquityClassNames();
        ModelResourceComparator comparator = new ModelResourceComparator(themeDisplay.getLocale());
        Arrays.sort(classNames, comparator);
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            List<SocialEquityActionMapping> mergedEquityActionMappings = this.getMergedEquityActionMappings(themeDisplay.getScopeGroupId(), className);
            equityActionMappingsMap.put(className, mergedEquityActionMappings);
            ++n2;
        }
        renderRequest.setAttribute("SOCIAL_EQUITY_ACTION_MAPPINGS_MAP", equityActionMappingsMap);
        return mapping.findForward("portlet.social_equity_admin.view");
    }

    protected SocialEquityActionMapping getMergedEquityActionMapping(ActionRequest actionRequest, SocialEquityActionMapping equityActionMapping) throws Exception {
        SocialEquityActionMapping mergedMapping = equityActionMapping.clone();
        this.updateModel(actionRequest, mergedMapping, "informationDailyLimit");
        this.updateModel(actionRequest, mergedMapping, "informationLifespan");
        this.updateModel(actionRequest, mergedMapping, "informationValue");
        this.updateModel(actionRequest, mergedMapping, "participationDailyLimit");
        this.updateModel(actionRequest, mergedMapping, "participationLifespan");
        this.updateModel(actionRequest, mergedMapping, "participationValue");
        boolean unique = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)(String.valueOf(equityActionMapping.getClassName()) + "." + equityActionMapping.getActionId() + ".unique"));
        mergedMapping.setUnique(unique);
        return mergedMapping;
    }

    protected SocialEquityActionMapping getMergedEquityActionMapping(long groupId, SocialEquityActionMapping equityActionMapping) throws Exception {
        SocialEquityActionMapping mergedEquityActionMapping = equityActionMapping.clone();
        List equitySettings = SocialEquitySettingLocalServiceUtil.getEquitySettings((long)groupId, (String)equityActionMapping.getClassName(), (String)equityActionMapping.getActionId());
        for (SocialEquitySetting equitySetting : equitySettings) {
            if (equitySetting.getType() == 1) {
                mergedEquityActionMapping.setInformationDailyLimit(equitySetting.getDailyLimit());
                mergedEquityActionMapping.setInformationLifespan(equitySetting.getLifespan());
                mergedEquityActionMapping.setInformationValue(equitySetting.getValue());
            } else {
                mergedEquityActionMapping.setParticipationDailyLimit(equitySetting.getDailyLimit());
                mergedEquityActionMapping.setParticipationLifespan(equitySetting.getLifespan());
                mergedEquityActionMapping.setParticipationValue(equitySetting.getValue());
            }
            mergedEquityActionMapping.setUnique(equitySetting.isUniqueEntry());
        }
        return mergedEquityActionMapping;
    }

    protected List<SocialEquityActionMapping> getMergedEquityActionMappings(ActionRequest actionRequest, String className) throws Exception {
        ArrayList<SocialEquityActionMapping> mergedEquityActionMappings = new ArrayList<SocialEquityActionMapping>();
        List equityActionMappings = PortalUtil.getSocialEquityActionMappings((String)className);
        for (SocialEquityActionMapping equityActionMapping : equityActionMappings) {
            SocialEquityActionMapping mergedEquityActionMapping = this.getMergedEquityActionMapping(actionRequest, equityActionMapping);
            mergedEquityActionMappings.add(mergedEquityActionMapping);
        }
        return mergedEquityActionMappings;
    }

    protected List<SocialEquityActionMapping> getMergedEquityActionMappings(long groupId, String className) throws Exception {
        ArrayList<SocialEquityActionMapping> mergedEquityActionMappings = new ArrayList<SocialEquityActionMapping>();
        List equityActionMappings = PortalUtil.getSocialEquityActionMappings((String)className);
        for (SocialEquityActionMapping equityActionMapping : equityActionMappings) {
            SocialEquityActionMapping mergedEquityActionMapping = this.getMergedEquityActionMapping(groupId, equityActionMapping);
            mergedEquityActionMappings.add(mergedEquityActionMapping);
        }
        return mergedEquityActionMappings;
    }

    protected void updateModel(ActionRequest actionRequest, SocialEquityActionMapping equityActionMapping, String param) throws Exception {
        String className = equityActionMapping.getClassName();
        int value = ParamUtil.getInteger((PortletRequest)actionRequest, (String)(String.valueOf(className) + "." + equityActionMapping.getActionId() + "." + param), (int)-1);
        if (value >= 0) {
            BeanPropertiesUtil.setProperty((Object)equityActionMapping, (String)param, (Object)value);
        }
    }

    protected void updateRanks(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        SocialEquityLogLocalServiceUtil.updateRanks((long)themeDisplay.getScopeGroupId());
    }

    protected void updateSettings(ActionRequest actionRequest) throws Exception {
        String[] classNames;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        boolean enabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enabled");
        SocialEquityGroupSettingLocalServiceUtil.updateEquityGroupSetting((long)themeDisplay.getScopeGroupId(), (String)Group.class.getName(), (int)1, (boolean)enabled);
        SocialEquityGroupSettingLocalServiceUtil.updateEquityGroupSetting((long)themeDisplay.getScopeGroupId(), (String)Group.class.getName(), (int)2, (boolean)enabled);
        String[] stringArray = classNames = PortalUtil.getSocialEquityClassNames();
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            List<SocialEquityActionMapping> mergedEquityActionMappings = this.getMergedEquityActionMappings(actionRequest, className);
            SocialEquitySettingLocalServiceUtil.updateEquitySettings((long)themeDisplay.getScopeGroupId(), (String)className, mergedEquityActionMappings);
            enabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)(String.valueOf(className) + ".enabled"));
            SocialEquityGroupSettingLocalServiceUtil.updateEquityGroupSetting((long)themeDisplay.getScopeGroupId(), (String)className, (int)1, (boolean)enabled);
            SocialEquityGroupSettingLocalServiceUtil.updateEquityGroupSetting((long)themeDisplay.getScopeGroupId(), (String)className, (int)2, (boolean)enabled);
            ++n2;
        }
    }
}

