/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.util;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortletSetupUtil;
import java.util.Locale;
import javax.portlet.PortletPreferences;

public class PortletConfigurationUtil {
    private static Log _log = LogFactoryUtil.getLog(PortletConfigurationUtil.class);

    public static String getPortletCustomCSSClassName(PortletPreferences portletSetup) throws Exception {
        JSONObject cssJSON;
        JSONObject advancedDataJSON;
        String customCSSClassName = "";
        String css = portletSetup.getValue("portlet-setup-css", "");
        if (Validator.isNotNull((String)css) && (advancedDataJSON = (cssJSON = PortletSetupUtil.cssToJSON(portletSetup, css)).getJSONObject("advancedData")) != null) {
            customCSSClassName = advancedDataJSON.getString("customCSSClassName");
        }
        return customCSSClassName;
    }

    public static String getPortletTitle(PortletPreferences portletSetup, String languageId) {
        String useCustomTitle = GetterUtil.getString((String)portletSetup.getValue("portlet-setup-use-custom-title", ""));
        if (useCustomTitle.equals("false")) {
            return "";
        }
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        String defaultPortletTitle = portletSetup.getValue("portlet-setup-title-" + defaultLanguageId, "");
        String portletTitle = portletSetup.getValue("portlet-setup-title-" + languageId, defaultPortletTitle);
        if (Validator.isNull((String)portletTitle)) {
            String oldPortletTitle = portletSetup.getValue("portlet-setup-title", null);
            if (Validator.isNull((String)useCustomTitle) && Validator.isNotNull((String)oldPortletTitle)) {
                portletTitle = oldPortletTitle;
                try {
                    portletSetup.setValue("portlet-setup-title-" + defaultLanguageId, portletTitle);
                    portletSetup.setValue("portlet-setup-use-custom-title", "true");
                    portletSetup.store();
                }
                catch (Exception e) {
                    _log.error((Throwable)e);
                }
            }
        }
        return portletTitle;
    }
}

