/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.messageboards.util.BBCodeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;

public class MBIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{MBMessage.class.getName()};
    public static final String PORTLET_ID = "19";
    private static final boolean _FILTER_SEARCH = true;
    private static Log _log = LogFactoryUtil.getLog(MBIndexer.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Summary getSummary(Document document, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        String messageId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/message_boards/view_message");
        portletURL.setParameter("messageId", messageId);
        return new Summary(title, content, portletURL);
    }

    protected void doDelete(Object obj) throws Exception {
        block3: {
            block4: {
                block2: {
                    if (!(obj instanceof MBCategory)) break block2;
                    MBCategory category = (MBCategory)obj;
                    BooleanQuery booleanQuery = BooleanQueryFactoryUtil.create();
                    booleanQuery.addRequiredTerm("portletId", PORTLET_ID);
                    booleanQuery.addRequiredTerm("categoryId", category.getCategoryId());
                    Hits hits = SearchEngineUtil.search((long)category.getCompanyId(), (Query)booleanQuery, (int)-1, (int)-1);
                    int i = 0;
                    while (i < hits.getLength()) {
                        Document document = hits.doc(i);
                        SearchEngineUtil.deleteDocument((long)category.getCompanyId(), (String)document.get("uid"));
                        ++i;
                    }
                    break block3;
                }
                if (!(obj instanceof MBMessage)) break block4;
                MBMessage message = (MBMessage)obj;
                DocumentImpl document = new DocumentImpl();
                document.addUID(PORTLET_ID, message.getMessageId());
                SearchEngineUtil.deleteDocument((long)message.getCompanyId(), (String)document.get("uid"));
                break block3;
            }
            if (!(obj instanceof MBThread)) break block3;
            MBThread thread = (MBThread)obj;
            MBMessage message = MBMessageLocalServiceUtil.getMessage((long)thread.getRootMessageId());
            BooleanQuery booleanQuery = BooleanQueryFactoryUtil.create();
            booleanQuery.addRequiredTerm("portletId", PORTLET_ID);
            booleanQuery.addRequiredTerm("threadId", thread.getThreadId());
            Hits hits = SearchEngineUtil.search((long)message.getCompanyId(), (Query)booleanQuery, (int)-1, (int)-1);
            int i = 0;
            while (i < hits.getLength()) {
                Document document = hits.doc(i);
                SearchEngineUtil.deleteDocument((long)message.getCompanyId(), (String)document.get("uid"));
                ++i;
            }
        }
    }

    protected Document doGetDocument(Object obj) throws Exception {
        MBMessage message = (MBMessage)obj;
        long companyId = message.getCompanyId();
        long groupId = this.getParentGroupId(message.getGroupId());
        long scopeGroupId = message.getGroupId();
        long userId = message.getUserId();
        String userName = PortalUtil.getUserName((long)userId, (String)message.getUserName());
        long categoryId = message.getCategoryId();
        long threadId = message.getThreadId();
        long messageId = message.getMessageId();
        String title = message.getSubject();
        String content = this.processContent(messageId, message.getBody());
        boolean anonymous = message.isAnonymous();
        Date modifiedDate = message.getModifiedDate();
        String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)MBMessage.class.getName(), (long)messageId);
        ExpandoBridge expandoBridge = message.getExpandoBridge();
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, messageId);
        document.addModifiedDate(modifiedDate);
        document.addKeyword("companyId", companyId);
        document.addKeyword("portletId", PORTLET_ID);
        document.addKeyword("groupId", groupId);
        document.addKeyword("scopeGroupId", scopeGroupId);
        document.addKeyword("userId", userId);
        if (!anonymous) {
            document.addText("userName", userName);
        }
        document.addText("title", title);
        document.addText("content", content);
        document.addKeyword("assetTagNames", assetTagNames);
        document.addKeyword("categoryId", categoryId);
        document.addKeyword("threadId", threadId);
        document.addKeyword("entryClassName", MBMessage.class.getName());
        document.addKeyword("entryClassPK", messageId);
        document.addKeyword("rootEntryClassPK", message.getRootMessageId());
        ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
        return document;
    }

    protected void doReindex(Object obj) throws Exception {
        MBMessage message = (MBMessage)obj;
        if (message.isDiscussion() || message.getStatus() != 0) {
            return;
        }
        Document document = this.getDocument(message);
        SearchEngineUtil.updateDocument((long)message.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)classPK);
        this.doReindex(message);
        if (message.isRoot()) {
            List messages = MBMessageLocalServiceUtil.getThreadMessages((long)message.getThreadId(), (int)0);
            for (MBMessage curMessage : messages) {
                this.reindex(curMessage);
            }
        } else {
            this.reindex(message);
        }
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCategories(companyId);
        this.reindexRoot(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long entryClassPK, String actionId) throws Exception {
        return MBMessagePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    protected boolean isFilterSearch() {
        return true;
    }

    protected void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long threadId = GetterUtil.getLong((String)((String)((Object)searchContext.getAttribute("threadId"))));
        if (threadId > 0L) {
            contextQuery.addTerm("threadId", threadId);
        }
    }

    protected String processContent(long messageId, String content) {
        try {
            content = BBCodeUtil.getHTML(content);
        }
        catch (Exception e) {
            _log.error((Object)("Could not parse message " + messageId + ": " + e.getMessage()));
        }
        content = HtmlUtil.extractText((String)content);
        return content;
    }

    protected void reindexCategories(long companyId) throws Exception {
        int categoryCount = MBCategoryLocalServiceUtil.getCompanyCategoriesCount((long)companyId);
        int categoryPages = categoryCount / 1000;
        int i = 0;
        while (i <= categoryPages) {
            int categoryStart = i * 1000;
            int categoryEnd = categoryStart + 1000;
            this.reindexCategories(companyId, categoryStart, categoryEnd);
            ++i;
        }
    }

    protected void reindexCategories(long companyId, int categoryStart, int categoryEnd) throws Exception {
        List categories = MBCategoryLocalServiceUtil.getCompanyCategories((long)companyId, (int)categoryStart, (int)categoryEnd);
        for (MBCategory category : categories) {
            long groupId = category.getGroupId();
            long categoryId = category.getCategoryId();
            int messageCount = MBMessageLocalServiceUtil.getCategoryMessagesCount((long)groupId, (long)categoryId, (int)0);
            int messagePages = messageCount / 1000;
            int i = 0;
            while (i <= messagePages) {
                int messageStart = i * 1000;
                int messageEnd = messageStart + 1000;
                this.reindexMessages(companyId, groupId, categoryId, messageStart, messageEnd);
                ++i;
            }
        }
    }

    protected void reindexMessages(long companyId, long groupId, long categoryId, int messageStart, int messageEnd) throws Exception {
        List messages = MBMessageLocalServiceUtil.getCategoryMessages((long)groupId, (long)categoryId, (int)0, (int)messageStart, (int)messageEnd);
        if (messages.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (MBMessage message : messages) {
            Document document = this.getDocument(message);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }

    protected void reindexRoot(long companyId) throws Exception {
        int groupCount = GroupLocalServiceUtil.getCompanyGroupsCount((long)companyId);
        int groupPages = groupCount / 1000;
        int i = 0;
        while (i <= groupPages) {
            int groupStart = i * 1000;
            int groupEnd = groupStart + 1000;
            this.reindexRoot(companyId, groupStart, groupEnd);
            ++i;
        }
    }

    protected void reindexRoot(long companyId, int groupStart, int groupEnd) throws Exception {
        List groups = GroupLocalServiceUtil.getCompanyGroups((long)companyId, (int)groupStart, (int)groupEnd);
        for (Group group : groups) {
            long groupId = group.getGroupId();
            long categoryId = MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID;
            int entryCount = MBMessageLocalServiceUtil.getCategoryMessagesCount((long)groupId, (long)categoryId, (int)0);
            int entryPages = entryCount / 1000;
            int i = 0;
            while (i <= entryPages) {
                int entryStart = i * 1000;
                int entryEnd = entryStart + 1000;
                this.reindexMessages(companyId, groupId, categoryId, entryStart, entryEnd);
                ++i;
            }
        }
    }
}

