/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.messageboards.LockedThreadException;
import com.liferay.portlet.messageboards.NoSuchCategoryException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageDisplay;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.base.MBMessageServiceBaseImpl;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import com.liferay.portlet.messageboards.service.permission.MBDiscussionPermission;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.messageboards.util.BBCodeUtil;
import com.liferay.portlet.messageboards.util.comparator.MessageCreateDateComparator;
import com.liferay.util.RSSUtil;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBMessageServiceImpl
extends MBMessageServiceBaseImpl {
    private static final int _RSS_ABSTRACT_LENGTH = GetterUtil.getInteger((String)PropsUtil.get("message.boards.rss.abstract.length"));

    public MBMessage addDiscussionMessage(long groupId, String className, long classPK, String permissionClassName, long permissionClassPK, long threadId, long parentMessageId, String subject, String body, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.getGuestOrUser();
        MBDiscussionPermission.check(this.getPermissionChecker(), user.getCompanyId(), serviceContext.getScopeGroupId(), permissionClassName, permissionClassPK, "ADD_DISCUSSION");
        return this.mbMessageLocalService.addDiscussionMessage(user.getUserId(), null, groupId, className, classPK, threadId, parentMessageId, subject, body, serviceContext);
    }

    public MBMessage addMessage(long groupId, long categoryId, long threadId, long parentMessageId, String subject, String body, List<ObjectValuePair<String, byte[]>> files, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        this.checkReplyToPermission(groupId, categoryId, parentMessageId);
        if (this.lockLocalService.isLocked(MBThread.class.getName(), threadId)) {
            throw new LockedThreadException();
        }
        if (!MBCategoryPermission.contains(this.getPermissionChecker(), groupId, categoryId, "ADD_FILE")) {
            files.clear();
        }
        if (!MBCategoryPermission.contains(this.getPermissionChecker(), groupId, categoryId, "UPDATE_THREAD_PRIORITY")) {
            priority = -1.0;
        }
        return this.mbMessageLocalService.addMessage(this.getGuestOrUserId(), null, groupId, categoryId, threadId, parentMessageId, subject, body, files, anonymous, priority, allowPingbacks, serviceContext);
    }

    public MBMessage addMessage(long groupId, long categoryId, String subject, String body, List<ObjectValuePair<String, byte[]>> files, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        MBCategoryPermission.check(this.getPermissionChecker(), groupId, categoryId, "ADD_MESSAGE");
        if (!MBCategoryPermission.contains(this.getPermissionChecker(), groupId, categoryId, "ADD_FILE")) {
            files.clear();
        }
        if (!MBCategoryPermission.contains(this.getPermissionChecker(), groupId, categoryId, "UPDATE_THREAD_PRIORITY")) {
            priority = -1.0;
        }
        return this.mbMessageLocalService.addMessage(this.getGuestOrUserId(), null, groupId, categoryId, subject, body, files, anonymous, priority, allowPingbacks, serviceContext);
    }

    public void deleteDiscussionMessage(long groupId, String className, long classPK, String permissionClassName, long permissionClassPK, long messageId) throws PortalException, SystemException {
        User user = this.getUser();
        MBDiscussionPermission.check(this.getPermissionChecker(), user.getCompanyId(), groupId, permissionClassName, permissionClassPK, messageId, "DELETE_DISCUSSION");
        this.mbMessageLocalService.deleteDiscussionMessage(messageId);
    }

    public void deleteMessage(long messageId) throws PortalException, SystemException {
        MBMessagePermission.check(this.getPermissionChecker(), messageId, "DELETE");
        this.mbMessageLocalService.deleteMessage(messageId);
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end) throws PortalException, SystemException {
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        for (MBMessage message : this.mbMessageLocalService.getCategoryMessages(groupId, categoryId, status, start, end)) {
            if (!MBMessagePermission.contains(this.getPermissionChecker(), message, "VIEW")) continue;
            messages.add(message);
        }
        return messages;
    }

    public int getCategoryMessagesCount(long groupId, long categoryId, int status) throws SystemException {
        return this.mbMessageLocalService.getCategoryMessagesCount(groupId, categoryId, status);
    }

    public String getCategoryMessagesRSS(long groupId, long categoryId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String name = "";
        String description = "";
        try {
            MBCategory category = this.mbCategoryLocalService.getCategory(categoryId);
            groupId = category.getGroupId();
            name = category.getName();
            description = category.getDescription();
        }
        catch (NoSuchCategoryException noSuchCategoryException) {
            Group group = this.groupLocalService.getGroup(categoryId);
            groupId = group.getGroupId();
            categoryId = MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID;
            name = group.getDescriptiveName();
            description = group.getDescription();
        }
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
        while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getCategoryMessages(groupId, categoryId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            Iterator itr = messageList.iterator();
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            while (itr.hasNext() && messages.size() < max) {
                MBMessage message = (MBMessage)itr.next();
                if (!MBMessagePermission.contains(this.getPermissionChecker(), message, "VIEW")) continue;
                messages.add(message);
            }
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public String getCompanyMessagesRSS(long companyId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        String name = company.getName();
        String description = company.getName();
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
        while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getCompanyMessages(companyId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            Iterator itr = messageList.iterator();
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            while (itr.hasNext() && messages.size() < max) {
                MBMessage message = (MBMessage)itr.next();
                if (!MBMessagePermission.contains(this.getPermissionChecker(), message, "VIEW")) continue;
                messages.add(message);
            }
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public String getGroupMessagesRSS(long groupId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String name = "";
        String description = "";
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
        while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getGroupMessages(groupId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            Iterator itr = messageList.iterator();
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            while (itr.hasNext() && messages.size() < max) {
                MBMessage message = (MBMessage)itr.next();
                if (!MBMessagePermission.contains(this.getPermissionChecker(), message, "VIEW")) continue;
                messages.add(message);
            }
        }
        if (messages.size() > 0) {
            MBMessage message = (MBMessage)messages.get(messages.size() - 1);
            name = message.getSubject();
            description = message.getSubject();
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public String getGroupMessagesRSS(long groupId, long userId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String name = "";
        String description = "";
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
        while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getGroupMessages(groupId, userId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            Iterator itr = messageList.iterator();
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            while (itr.hasNext() && messages.size() < max) {
                MBMessage message = (MBMessage)itr.next();
                if (!MBMessagePermission.contains(this.getPermissionChecker(), message, "VIEW")) continue;
                messages.add(message);
            }
        }
        if (messages.size() > 0) {
            MBMessage message = (MBMessage)messages.get(messages.size() - 1);
            name = message.getSubject();
            description = message.getSubject();
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public MBMessage getMessage(long messageId) throws PortalException, SystemException {
        MBMessagePermission.check(this.getPermissionChecker(), messageId, "VIEW");
        return this.mbMessageLocalService.getMessage(messageId);
    }

    public MBMessageDisplay getMessageDisplay(long messageId, int status, String threadView, boolean includePrevAndNext) throws PortalException, SystemException {
        MBMessagePermission.check(this.getPermissionChecker(), messageId, "VIEW");
        return this.mbMessageLocalService.getMessageDisplay(messageId, status, threadView, includePrevAndNext);
    }

    public List<MBMessage> getThreadMessages(long groupId, long categoryId, long threadId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.filterFindByG_C_T(groupId, categoryId, threadId, start, end);
        }
        return this.mbMessagePersistence.filterFindByG_C_T_S(groupId, categoryId, threadId, status, start, end);
    }

    public int getThreadMessagesCount(long groupId, long categoryId, long threadId, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.filterCountByG_C_T(groupId, categoryId, threadId);
        }
        return this.mbMessagePersistence.filterCountByG_C_T_S(groupId, categoryId, threadId, status);
    }

    public String getThreadMessagesRSS(long threadId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String name = "";
        String description = "";
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        if (MBMessagePermission.contains(this.getPermissionChecker(), thread.getRootMessageId(), "VIEW")) {
            MBMessage message;
            MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
            Iterator itr = this.mbMessageLocalService.getThreadMessages(threadId, status, (Comparator)comparator).iterator();
            while (itr.hasNext() && messages.size() < max) {
                message = (MBMessage)itr.next();
                if (!MBMessagePermission.contains(this.getPermissionChecker(), message, "VIEW")) continue;
                messages.add(message);
            }
            if (messages.size() > 0) {
                message = (MBMessage)messages.get(messages.size() - 1);
                name = message.getSubject();
                description = message.getSubject();
            }
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public void subscribeMessage(long messageId) throws PortalException, SystemException {
        MBMessagePermission.check(this.getPermissionChecker(), messageId, "SUBSCRIBE");
        this.mbMessageLocalService.subscribeMessage(this.getUserId(), messageId);
    }

    public void unsubscribeMessage(long messageId) throws PortalException, SystemException {
        MBMessagePermission.check(this.getPermissionChecker(), messageId, "SUBSCRIBE");
        this.mbMessageLocalService.unsubscribeMessage(this.getUserId(), messageId);
    }

    public MBMessage updateDiscussionMessage(String className, long classPK, String permissionClassName, long permissionClassPK, long messageId, String subject, String body, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.getUser();
        MBDiscussionPermission.check(this.getPermissionChecker(), user.getCompanyId(), serviceContext.getScopeGroupId(), permissionClassName, permissionClassPK, messageId, "UPDATE_DISCUSSION");
        return this.mbMessageLocalService.updateDiscussionMessage(this.getUserId(), messageId, subject, body, serviceContext.getWorkflowAction());
    }

    public MBMessage updateMessage(long messageId, String subject, String body, List<ObjectValuePair<String, byte[]>> files, List<String> existingFiles, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage message = this.mbMessageLocalService.getMessage(messageId);
        MBMessagePermission.check(this.getPermissionChecker(), messageId, "UPDATE");
        if (this.lockLocalService.isLocked(MBThread.class.getName(), message.getThreadId())) {
            throw new LockedThreadException();
        }
        if (!MBCategoryPermission.contains(this.getPermissionChecker(), message.getGroupId(), message.getCategoryId(), "ADD_FILE")) {
            files.clear();
        }
        if (!MBCategoryPermission.contains(this.getPermissionChecker(), message.getGroupId(), message.getCategoryId(), "UPDATE_THREAD_PRIORITY")) {
            MBThread thread = this.mbThreadLocalService.getThread(message.getThreadId());
            priority = thread.getPriority();
        }
        return this.mbMessageLocalService.updateMessage(this.getUserId(), messageId, subject, body, files, existingFiles, priority, allowPingbacks, serviceContext);
    }

    protected void checkReplyToPermission(long groupId, long categoryId, long parentMessageId) throws PortalException, SystemException {
        if (parentMessageId > 0L) {
            if (MBCategoryPermission.contains(this.getPermissionChecker(), groupId, categoryId, "ADD_MESSAGE")) {
                return;
            }
            MBMessage parentMessage = this.mbMessagePersistence.fetchByPrimaryKey(parentMessageId);
            if (parentMessage == null || !MBCategoryPermission.contains(this.getPermissionChecker(), groupId, categoryId, "REPLY_TO_MESSAGE")) {
                throw new PrincipalException();
            }
        } else {
            MBCategoryPermission.check(this.getPermissionChecker(), groupId, categoryId, "ADD_MESSAGE");
        }
    }

    protected String exportToRSS(String name, String description, String type, double version, String displayStyle, String feedURL, String entryURL, List<MBMessage> messages, ThemeDisplay themeDisplay) throws SystemException {
        SyndFeedImpl syndFeed = new SyndFeedImpl();
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        syndFeed.setTitle(name);
        syndFeed.setLink(feedURL);
        syndFeed.setDescription(description);
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        syndFeed.setEntries(entries);
        for (MBMessage message : messages) {
            String author = HtmlUtil.escape((String)PortalUtil.getUserName((long)message.getUserId(), (String)message.getUserName()));
            String value = null;
            if (displayStyle.equals("abstract")) {
                value = StringUtil.shorten((String)HtmlUtil.extractText((String)message.getBody()), (int)_RSS_ABSTRACT_LENGTH, (String)"");
            } else if (displayStyle.equals("title")) {
                value = "";
            } else {
                value = BBCodeUtil.getHTML(message);
                value = StringUtil.replace((String)value, (String[])new String[]{"@theme_images_path@", "href=\"/", "src=\"/"}, (String[])new String[]{String.valueOf(themeDisplay.getURLPortal()) + themeDisplay.getPathThemeImages(), "href=\"" + themeDisplay.getURLPortal() + "/", "src=\"" + themeDisplay.getURLPortal() + "/"});
            }
            SyndEntryImpl syndEntry = new SyndEntryImpl();
            if (!message.isAnonymous()) {
                syndEntry.setAuthor(author);
            }
            syndEntry.setTitle(message.getSubject());
            syndEntry.setLink(String.valueOf(entryURL) + "&messageId=" + message.getMessageId());
            syndEntry.setUri(syndEntry.getLink());
            syndEntry.setPublishedDate(message.getCreateDate());
            syndEntry.setUpdatedDate(message.getModifiedDate());
            SyndContentImpl syndContent = new SyndContentImpl();
            syndContent.setType("html");
            syndContent.setValue(value);
            syndEntry.setDescription((SyndContent)syndContent);
            entries.add(syndEntry);
        }
        try {
            return RSSUtil.export((SyndFeed)syndFeed);
        }
        catch (FeedException fe) {
            throw new SystemException((Throwable)fe);
        }
    }
}

