/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageFlag;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.base.MBMessageFlagLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class MBMessageFlagLocalServiceImpl
extends MBMessageFlagLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(MBMessageFlagLocalServiceImpl.class);

    public void addReadFlags(long userId, MBThread thread) throws PortalException, SystemException {
        MBMessageFlag messageFlag;
        block6: {
            int flag;
            User user = this.userPersistence.findByPrimaryKey(userId);
            if (user.isDefaultUser()) {
                return;
            }
            long messageId = thread.getRootMessageId();
            messageFlag = this.mbMessageFlagPersistence.fetchByU_M_F(userId, messageId, flag = 1);
            if (messageFlag == null) {
                long messageFlagId = this.counterLocalService.increment();
                messageFlag = this.mbMessageFlagPersistence.create(messageFlagId);
                messageFlag.setUserId(userId);
                messageFlag.setModifiedDate(thread.getLastPostDate());
                messageFlag.setThreadId(thread.getThreadId());
                messageFlag.setMessageId(messageId);
                messageFlag.setFlag(flag);
                this.mbMessageFlagPersistence.update((BaseModel)messageFlag, false);
                try {
                    this.mbMessageFlagPersistence.update((BaseModel)messageFlag, false);
                }
                catch (SystemException se) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Add failed, fetch {userId=" + userId + ", messageId=" + messageId + ",flag=" + flag + "}"));
                    }
                    if ((messageFlag = this.mbMessageFlagPersistence.fetchByU_M_F(userId, messageId, flag, false)) != null) break block6;
                    throw se;
                }
            }
        }
        if (!DateUtil.equals((Date)messageFlag.getModifiedDate(), (Date)thread.getLastPostDate(), (boolean)true)) {
            messageFlag.setModifiedDate(thread.getLastPostDate());
            this.mbMessageFlagPersistence.update((BaseModel)messageFlag, false);
        }
    }

    public void addQuestionFlag(long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        if (!message.isRoot()) {
            return;
        }
        MBMessageFlag questionMessageFlag = this.mbMessageFlagPersistence.fetchByU_M_F(message.getUserId(), message.getMessageId(), 2);
        MBMessageFlag answerMessageFlag = this.mbMessageFlagPersistence.fetchByU_M_F(message.getUserId(), message.getMessageId(), 3);
        if (questionMessageFlag == null && answerMessageFlag == null) {
            long messageFlagId = this.counterLocalService.increment();
            questionMessageFlag = this.mbMessageFlagPersistence.create(messageFlagId);
            questionMessageFlag.setUserId(message.getUserId());
            questionMessageFlag.setModifiedDate(new Date());
            questionMessageFlag.setThreadId(message.getThreadId());
            questionMessageFlag.setMessageId(message.getMessageId());
            questionMessageFlag.setFlag(2);
            this.mbMessageFlagPersistence.update((BaseModel)questionMessageFlag, false);
        }
    }

    public void deleteAnswerFlags(long threadId, long messageId) throws SystemException {
        this.mbMessageFlagPersistence.removeByM_F(messageId, 3);
        List messages = this.mbMessagePersistence.findByT_P(threadId, messageId);
        for (MBMessage message : messages) {
            this.deleteAnswerFlags(threadId, message.getMessageId());
        }
    }

    public void deleteFlags(long userId) throws SystemException {
        this.mbMessageFlagPersistence.removeByUserId(userId);
    }

    public void deleteFlags(long messageId, int flag) throws SystemException {
        this.mbMessageFlagPersistence.removeByM_F(messageId, flag);
    }

    public void deleteQuestionAndAnswerFlags(long threadId) throws SystemException {
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            if (message.isRoot()) {
                this.mbMessageFlagPersistence.removeByM_F(message.getMessageId(), 2);
            }
            this.mbMessageFlagPersistence.removeByM_F(message.getMessageId(), 3);
        }
    }

    public void deleteThreadFlags(long threadId) throws SystemException {
        this.mbMessageFlagPersistence.removeByThreadId(threadId);
    }

    public MBMessageFlag getReadFlag(long userId, MBThread thread) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (user.isDefaultUser()) {
            return null;
        }
        return this.mbMessageFlagPersistence.fetchByU_M_F(userId, thread.getRootMessageId(), 1);
    }

    public boolean hasAnswerFlag(long messageId) throws SystemException {
        int count = this.mbMessageFlagPersistence.countByM_F(messageId, 3);
        return count > 0;
    }

    public boolean hasQuestionFlag(long messageId) throws SystemException {
        int count = this.mbMessageFlagPersistence.countByM_F(messageId, 2);
        return count > 0;
    }

    public boolean hasReadFlag(long userId, MBThread thread) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (user.isDefaultUser()) {
            return true;
        }
        MBMessageFlag messageFlag = this.mbMessageFlagPersistence.fetchByU_M_F(userId, thread.getRootMessageId(), 1);
        return messageFlag != null && DateUtil.equals((Date)messageFlag.getModifiedDate(), (Date)thread.getLastPostDate(), (boolean)true);
    }
}

