/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateNode
extends LinkedHashMap<String, Object> {
    private static final String _LAYOUT_TYPE_PRIVATE_GROUP = "private-group";
    private static final String _LAYOUT_TYPE_PRIVATE_USER = "private-user";
    private static final String _LAYOUT_TYPE_PUBLIC = "public";
    private static Log _log = LogFactoryUtil.getLog(TemplateNode.class);
    private Map<String, TemplateNode> _children = new LinkedHashMap<String, TemplateNode>();
    private List<TemplateNode> _siblings = new ArrayList<TemplateNode>();
    private ThemeDisplay _themeDisplay;

    public TemplateNode(ThemeDisplay themeDisplay, String name, String data, String type) {
        this._themeDisplay = themeDisplay;
        this.put("name", name);
        this.put("data", data);
        this.put("type", type);
        this.put("options", new ArrayList());
    }

    public void appendChild(TemplateNode child) {
        this._children.put(child.getName(), child);
        this.put(child.getName(), child);
    }

    public void appendChildren(List<TemplateNode> children) {
        for (TemplateNode child : children) {
            this.appendChild(child);
        }
    }

    public void appendOption(String option) {
        this.getOptions().add(option);
    }

    public void appendOptions(List<String> options) {
        this.getOptions().addAll(options);
    }

    public void appendSibling(TemplateNode sibling) {
        this._siblings.add(sibling);
    }

    public TemplateNode getChild(String name) {
        return this._children.get(name);
    }

    public List<TemplateNode> getChildren() {
        return new ArrayList<TemplateNode>(this._children.values());
    }

    public String getData() {
        if (this.getType().equals("link_to_layout")) {
            String data = (String)this.get("data");
            int pos = data.indexOf(64);
            if (pos != -1) {
                data = data.substring(0, pos);
            }
            return data;
        }
        return (String)this.get("data");
    }

    public String getFriendlyUrl() {
        if (this._themeDisplay == null) {
            return this.getUrl();
        }
        if (this.getType().equals("link_to_layout")) {
            String layoutType = this.getLayoutType();
            long layoutId = this.getLayoutId();
            boolean privateLayout = layoutType.startsWith("private");
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)this._themeDisplay.getScopeGroupId(), (boolean)privateLayout, (long)layoutId);
                return PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)this._themeDisplay);
            }
            catch (Exception e) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Error finding friendly Url on page " + this._themeDisplay.getURLCurrent()), (Throwable)e);
                }
                return this.getUrl();
            }
        }
        return "";
    }

    public String getName() {
        return (String)this.get("name");
    }

    public List<String> getOptions() {
        return (List)this.get("options");
    }

    public List<TemplateNode> getSiblings() {
        return this._siblings;
    }

    public String getType() {
        return (String)this.get("type");
    }

    public String getUrl() {
        if (this.getType().equals("link_to_layout")) {
            StringBundler sb = new StringBundler(5);
            String layoutType = this.getLayoutType();
            if (layoutType.equals(_LAYOUT_TYPE_PRIVATE_GROUP)) {
                sb.append(PortalUtil.getPathFriendlyURLPrivateGroup());
            } else if (layoutType.equals(_LAYOUT_TYPE_PRIVATE_USER)) {
                sb.append(PortalUtil.getPathFriendlyURLPrivateUser());
            } else if (layoutType.equals(_LAYOUT_TYPE_PUBLIC)) {
                sb.append(PortalUtil.getPathFriendlyURLPublic());
            } else {
                sb.append("@friendly_url_current@");
            }
            sb.append("/");
            sb.append("@group_id@");
            sb.append("/");
            sb.append(this.getLayoutId());
            return sb.toString();
        }
        return "";
    }

    protected long getLayoutId() {
        String data = (String)this.get("data");
        int pos = data.indexOf(64);
        if (pos != -1) {
            data = data.substring(0, pos);
        }
        return GetterUtil.getLong((String)data);
    }

    protected String getLayoutType() {
        String data = (String)this.get("data");
        int pos = data.indexOf(64);
        if (pos != -1) {
            data = data.substring(pos + 1);
        }
        return data;
    }
}

