/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.freemarker.FreeMarkerContext;
import com.liferay.portal.kernel.freemarker.FreeMarkerEngineUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.TransformException;
import com.liferay.portlet.journal.util.TemplateNode;
import com.liferay.portlet.journal.util.VelocityTemplateParser;
import com.liferay.util.PwdGenerator;
import freemarker.core.ParseException;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeMarkerTemplateParser
extends VelocityTemplateParser {
    @Override
    public String doTransform(ThemeDisplay themeDisplay, Map<String, String> tokens, String viewMode, String languageId, String xml, String script) throws Exception {
        boolean load;
        UnsyncStringWriter unsyncStringWriter;
        block11: {
            unsyncStringWriter = new UnsyncStringWriter();
            load = false;
            try {
                FreeMarkerContext freeMarkerContext = FreeMarkerEngineUtil.getWrappedRestrictedToolsContext();
                Document doc = SAXReaderUtil.read((String)xml);
                Element root = doc.getRootElement();
                List<TemplateNode> nodes = this.extractDynamicContents(themeDisplay, root);
                for (TemplateNode node : nodes) {
                    freeMarkerContext.put(node.getName(), (Object)node);
                }
                freeMarkerContext.put("xmlRequest", (Object)root.element("request").asXML());
                freeMarkerContext.put("request", this.insertRequestVariables(root.element("request")));
                long companyId = GetterUtil.getLong((String)tokens.get("company_id"));
                Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
                long groupId = GetterUtil.getLong((String)tokens.get("group_id"));
                String templateId = tokens.get("template_id");
                String journalTemplatesPath = "_JOURNAL_CONTEXT_/" + companyId + "/" + groupId;
                String randomNamespace = String.valueOf(PwdGenerator.getPassword((String)PwdGenerator.KEY3, (int)4)) + "_";
                freeMarkerContext.put("company", (Object)company);
                freeMarkerContext.put("companyId", (Object)String.valueOf(companyId));
                freeMarkerContext.put("groupId", (Object)String.valueOf(groupId));
                freeMarkerContext.put("journalTemplatesPath", (Object)journalTemplatesPath);
                freeMarkerContext.put("viewMode", (Object)viewMode);
                freeMarkerContext.put("locale", (Object)LocaleUtil.fromLanguageId((String)languageId));
                freeMarkerContext.put("permissionChecker", (Object)PermissionThreadLocal.getPermissionChecker());
                freeMarkerContext.put("randomNamespace", (Object)randomNamespace);
                script = this.injectEditInPlace(xml, script);
                try {
                    String freeMarkerTemplateId = String.valueOf(companyId + groupId) + templateId;
                    load = FreeMarkerEngineUtil.mergeTemplate((String)freeMarkerTemplateId, (String)script, (FreeMarkerContext)freeMarkerContext, (Writer)unsyncStringWriter);
                }
                catch (SystemException se) {
                    if (se.getCause() instanceof TemplateException) {
                        TemplateException te = (TemplateException)se.getCause();
                        freeMarkerContext.put("exception", (Object)te.getMessage());
                        freeMarkerContext.put("script", (Object)script);
                        String freeMarkerTemplateId = PropsValues.JOURNAL_ERROR_TEMPLATE_FREEMARKER;
                        String freemarkerTemplateContent = ContentUtil.get(PropsValues.JOURNAL_ERROR_TEMPLATE_FREEMARKER);
                        unsyncStringWriter = new UnsyncStringWriter();
                        load = FreeMarkerEngineUtil.mergeTemplate((String)freeMarkerTemplateId, (String)freemarkerTemplateContent, (FreeMarkerContext)freeMarkerContext, (Writer)unsyncStringWriter);
                        break block11;
                    }
                    throw se;
                }
                catch (ParseException pe) {
                    freeMarkerContext.put("exception", (Object)pe.getMessage());
                    freeMarkerContext.put("script", (Object)script);
                    freeMarkerContext.put("column", (Object)new Integer(pe.getColumnNumber()));
                    freeMarkerContext.put("line", (Object)new Integer(pe.getLineNumber()));
                    String freeMarkerTemplateId = PropsValues.JOURNAL_ERROR_TEMPLATE_FREEMARKER;
                    String freemarkerTemplateContent = ContentUtil.get(PropsValues.JOURNAL_ERROR_TEMPLATE_FREEMARKER);
                    unsyncStringWriter = new UnsyncStringWriter();
                    load = FreeMarkerEngineUtil.mergeTemplate((String)freeMarkerTemplateId, (String)freemarkerTemplateContent, (FreeMarkerContext)freeMarkerContext, (Writer)unsyncStringWriter);
                }
            }
            catch (Exception e) {
                if (e instanceof DocumentException) {
                    throw new TransformException("Unable to read XML document", e);
                }
                if (e instanceof IOException) {
                    throw new TransformException("Error reading freemarker template", e);
                }
                if (e instanceof TransformException) {
                    throw (TransformException)((Object)e);
                }
                throw new TransformException("Unhandled exception", e);
            }
        }
        if (!load) {
            throw new TransformException("Unable to dynamically load freemarker transform script");
        }
        return unsyncStringWriter.toString();
    }
}

