/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;

public class ExpandoColumnPermission {
    public static void check(PermissionChecker permissionChecker, ExpandoColumn column, String actionId) throws PortalException {
        if (!ExpandoColumnPermission.contains(permissionChecker, column, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long columnId, String actionId) throws PortalException, SystemException {
        if (!ExpandoColumnPermission.contains(permissionChecker, columnId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long companyId, String className, String tableName, String columnName, String actionId) throws PortalException, SystemException {
        if (!ExpandoColumnPermission.contains(permissionChecker, companyId, className, tableName, columnName, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, ExpandoColumn column, String actionId) {
        return permissionChecker.hasPermission(0L, ExpandoColumn.class.getName(), column.getColumnId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long columnId, String actionId) throws PortalException, SystemException {
        ExpandoColumn column = ExpandoColumnLocalServiceUtil.getColumn((long)columnId);
        return ExpandoColumnPermission.contains(permissionChecker, column, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long companyId, String className, String tableName, String columnName, String actionId) throws SystemException {
        ExpandoColumn column = ExpandoColumnLocalServiceUtil.getColumn((long)companyId, (String)className, (String)tableName, (String)columnName);
        return ExpandoColumnPermission.contains(permissionChecker, column, actionId);
    }
}

