/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.communities.action;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.OrganizationServiceUtil;
import com.liferay.portal.service.UserGroupRoleServiceUtil;
import com.liferay.portal.service.UserGroupServiceUtil;
import com.liferay.portal.service.UserServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.communities.action.ActionUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditGroupAssignmentsAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("group_organizations")) {
                this.updateGroupOrganizations(actionRequest);
            } else if (cmd.equals("group_user_groups")) {
                this.updateGroupUserGroups(actionRequest);
            } else if (cmd.equals("group_users")) {
                this.updateGroupUsers(actionRequest);
            } else if (cmd.equals("user_group_role")) {
                this.updateUserGroupRole(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"assignmentsRedirect");
                if (Validator.isNull((String)redirect)) {
                    redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.communities.error");
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.communities.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.communities.edit_community_assignments"));
    }

    protected void updateGroupOrganizations(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long[] addOrganizationIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addOrganizationIds"), (long)0L);
        long[] removeOrganizationIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeOrganizationIds"), (long)0L);
        OrganizationServiceUtil.addGroupOrganizations((long)groupId, (long[])addOrganizationIds);
        OrganizationServiceUtil.unsetGroupOrganizations((long)groupId, (long[])removeOrganizationIds);
    }

    protected void updateGroupUserGroups(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long[] addUserGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addUserGroupIds"), (long)0L);
        long[] removeUserGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeUserGroupIds"), (long)0L);
        UserGroupServiceUtil.addGroupUserGroups((long)groupId, (long[])addUserGroupIds);
        UserGroupServiceUtil.unsetGroupUserGroups((long)groupId, (long[])removeUserGroupIds);
    }

    protected void updateGroupUsers(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long[] addUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addUserIds"), (long)0L);
        long[] removeUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeUserIds"), (long)0L);
        UserServiceUtil.addGroupUsers((long)groupId, (long[])addUserIds);
        UserServiceUtil.unsetGroupUsers((long)groupId, (long[])removeUserIds);
        LiveUsers.joinGroup(themeDisplay.getCompanyId(), groupId, addUserIds);
        LiveUsers.leaveGroup(themeDisplay.getCompanyId(), groupId, removeUserIds);
    }

    protected void updateUserGroupRole(ActionRequest actionRequest) throws Exception {
        User user = PortalUtil.getSelectedUser((PortletRequest)actionRequest, (boolean)false);
        if (user == null) {
            return;
        }
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long[] addRoleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addRoleIds"), (long)0L);
        long[] removeRoleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeRoleIds"), (long)0L);
        UserGroupRoleServiceUtil.addUserGroupRoles((long)user.getUserId(), (long)groupId, (long[])addRoleIds);
        UserGroupRoleServiceUtil.deleteUserGroupRoles((long)user.getUserId(), (long)groupId, (long[])removeRoleIds);
    }
}

