/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.base.BookmarksEntryServiceBaseImpl;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;

public class BookmarksEntryServiceImpl
extends BookmarksEntryServiceBaseImpl {
    public BookmarksEntry addEntry(long groupId, long folderId, String name, String url, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_ENTRY");
        return this.bookmarksEntryLocalService.addEntry(this.getUserId(), groupId, folderId, name, url, comments, serviceContext);
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.bookmarksEntryLocalService.deleteEntry(entryId);
    }

    public BookmarksEntry getEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "VIEW");
        return this.bookmarksEntryLocalService.getEntry(entryId);
    }

    public BookmarksEntry openEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "VIEW");
        return this.bookmarksEntryLocalService.openEntry(this.getGuestOrUserId(), entryId);
    }

    public BookmarksEntry updateEntry(long entryId, long groupId, long folderId, String name, String url, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksEntryPermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        return this.bookmarksEntryLocalService.updateEntry(this.getUserId(), entryId, groupId, folderId, name, url, comments, serviceContext);
    }
}

