/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.model.BlogsStatsUser;
import com.liferay.portlet.blogs.service.base.BlogsStatsUserLocalServiceBaseImpl;
import com.liferay.portlet.blogs.util.comparator.EntryDisplayDateComparator;
import com.liferay.portlet.blogs.util.comparator.StatsUserLastPostDateComparator;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogsStatsUserLocalServiceImpl
extends BlogsStatsUserLocalServiceBaseImpl {
    public void deleteStatsUserByGroupId(long groupId) throws SystemException {
        this.blogsStatsUserPersistence.removeByGroupId(groupId);
    }

    public void deleteStatsUserByUserId(long userId) throws SystemException {
        this.blogsStatsUserPersistence.removeByUserId(userId);
    }

    public List<BlogsStatsUser> getCompanyStatsUsers(long companyId, int start, int end) throws SystemException {
        return this.blogsStatsUserPersistence.findByC_NotE(companyId, 0, start, end, (OrderByComparator)new StatsUserLastPostDateComparator());
    }

    public List<BlogsStatsUser> getCompanyStatsUsers(long companyId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.blogsStatsUserPersistence.findByC_NotE(companyId, 0, start, end, obc);
    }

    public int getCompanyStatsUsersCount(long companyId) throws SystemException {
        return this.blogsStatsUserPersistence.countByC_NotE(companyId, 0);
    }

    public List<BlogsStatsUser> getGroupsStatsUsers(long companyId, long groupId, int start, int end) throws SystemException {
        return this.blogsStatsUserFinder.findByGroupIds(companyId, groupId, start, end);
    }

    public List<BlogsStatsUser> getGroupStatsUsers(long groupId, int start, int end) throws SystemException {
        return this.blogsStatsUserPersistence.findByG_NotE(groupId, 0, start, end, (OrderByComparator)new StatsUserLastPostDateComparator());
    }

    public List<BlogsStatsUser> getGroupStatsUsers(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.blogsStatsUserPersistence.findByG_NotE(groupId, 0, start, end, obc);
    }

    public int getGroupStatsUsersCount(long groupId) throws SystemException {
        return this.blogsStatsUserPersistence.countByG_NotE(groupId, 0);
    }

    public List<BlogsStatsUser> getOrganizationStatsUsers(long organizationId, int start, int end) throws SystemException {
        return this.blogsStatsUserFinder.findByOrganizationId(organizationId, start, end, (OrderByComparator)new StatsUserLastPostDateComparator());
    }

    public List<BlogsStatsUser> getOrganizationStatsUsers(long organizationId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.blogsStatsUserFinder.findByOrganizationId(organizationId, start, end, obc);
    }

    public int getOrganizationStatsUsersCount(long organizationId) throws SystemException {
        return this.blogsStatsUserFinder.countByOrganizationId(organizationId);
    }

    public BlogsStatsUser getStatsUser(long groupId, long userId) throws PortalException, SystemException {
        BlogsStatsUser statsUser = this.blogsStatsUserPersistence.fetchByG_U(groupId, userId);
        if (statsUser == null) {
            Group group = this.groupPersistence.findByPrimaryKey(groupId);
            long statsUserId = this.counterLocalService.increment();
            statsUser = this.blogsStatsUserPersistence.create(statsUserId);
            statsUser.setCompanyId(group.getCompanyId());
            statsUser.setGroupId(groupId);
            statsUser.setUserId(userId);
            this.blogsStatsUserPersistence.update((BaseModel)statsUser, false);
        }
        return statsUser;
    }

    public void updateStatsUser(long groupId, long userId) throws PortalException, SystemException {
        this.updateStatsUser(groupId, userId, null);
    }

    public void updateStatsUser(long groupId, long userId, Date displayDate) throws PortalException, SystemException {
        int entryCount = this.blogsEntryPersistence.countByG_U_S(groupId, userId, 0);
        BlogsStatsUser statsUser = this.getStatsUser(groupId, userId);
        statsUser.setEntryCount(entryCount);
        if (displayDate != null) {
            BlogsEntry blogsEntry = this.blogsEntryPersistence.findByG_U_S_First(groupId, userId, 0, (OrderByComparator)new EntryDisplayDateComparator());
            Date lastDisplayDate = blogsEntry.getDisplayDate();
            Date lastPostDate = statsUser.getLastPostDate();
            if (lastPostDate == null) {
                statsUser.setLastPostDate(displayDate);
            } else if (displayDate.after(lastPostDate)) {
                statsUser.setLastPostDate(displayDate);
            } else if (lastDisplayDate.before(lastPostDate)) {
                statsUser.setLastPostDate(lastDisplayDate);
            }
        }
        this.blogsStatsUserPersistence.update((BaseModel)statsUser, false);
    }
}

