/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.action;

import com.liferay.portal.kernel.portlet.BaseConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class ConfigurationActionImpl
extends BaseConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
            PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
            if (cmd.equals("add-selection")) {
                AssetPublisherUtil.addSelection(actionRequest, preferences);
            } else if (cmd.equals("move-selection-down")) {
                this.moveSelectionDown(actionRequest, preferences);
            } else if (cmd.equals("move-selection-up")) {
                this.moveSelectionUp(actionRequest, preferences);
            } else if (cmd.equals("remove-selection")) {
                this.removeSelection(actionRequest, preferences);
            } else if (cmd.equals("selection-style")) {
                this.setSelectionStyle(actionRequest, preferences);
            } else if (cmd.equals("update")) {
                String selectionStyle = preferences.getValue("selection-style", "dynamic");
                if (selectionStyle.equals("dynamic")) {
                    this.updateDynamicSettings(actionRequest, preferences);
                } else if (selectionStyle.equals("manual")) {
                    this.updateManualSettings(actionRequest, preferences);
                }
            }
            if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                preferences.store();
                SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".doConfigure"));
            }
            actionResponse.sendRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
        }
        catch (Exception e) {
            if (e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    public String render(PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return "/html/portlet/asset_publisher/configuration.jsp";
    }

    protected void moveSelectionDown(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetEntryOrder");
        if (assetEntryOrder >= (manualEntries = preferences.getValues("asset-entry-xml", new String[0])).length - 1 || assetEntryOrder < 0) {
            return;
        }
        String temp = manualEntries[assetEntryOrder + 1];
        manualEntries[assetEntryOrder + 1] = manualEntries[assetEntryOrder];
        manualEntries[assetEntryOrder] = temp;
        preferences.setValues("asset-entry-xml", manualEntries);
    }

    protected void moveSelectionUp(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetEntryOrder");
        if (assetEntryOrder >= (manualEntries = preferences.getValues("asset-entry-xml", new String[0])).length || assetEntryOrder <= 0) {
            return;
        }
        String temp = manualEntries[assetEntryOrder - 1];
        manualEntries[assetEntryOrder - 1] = manualEntries[assetEntryOrder];
        manualEntries[assetEntryOrder] = temp;
        preferences.setValues("asset-entry-xml", manualEntries);
    }

    protected void removeSelection(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetEntryOrder");
        if (assetEntryOrder >= (manualEntries = preferences.getValues("asset-entry-xml", new String[0])).length) {
            return;
        }
        String[] newEntries = new String[manualEntries.length - 1];
        int i = 0;
        int j = 0;
        while (i < manualEntries.length) {
            if (i != assetEntryOrder) {
                newEntries[j++] = manualEntries[i];
            }
            ++i;
        }
        preferences.setValues("asset-entry-xml", newEntries);
    }

    protected void setSelectionStyle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String selectionStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"selectionStyle");
        String displayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"displayStyle");
        preferences.setValue("selection-style", selectionStyle);
        if (selectionStyle.equals("manual") || selectionStyle.equals("view-count")) {
            preferences.setValue("show-query-logic", String.valueOf(false));
        }
        if (!selectionStyle.equals("view-count") && displayStyle.equals("view-count-details")) {
            preferences.setValue("display-style", "full-content");
        }
    }

    protected void updateDynamicSettings(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        this.updateDisplaySettings(actionRequest, preferences);
        this.updateQueryLogic(actionRequest, preferences);
        this.updateRssSettings(actionRequest, preferences);
        boolean mergeUrlTags = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeUrlTags");
        boolean defaultScope = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"defaultScope");
        Object[] scopeIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"scopeIds"));
        long assetVocabularyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"assetVocabularyId");
        String orderByColumn1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"orderByColumn1");
        String orderByColumn2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"orderByColumn2");
        String orderByType1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"orderByType1");
        String orderByType2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"orderByType2");
        boolean excludeZeroViewCount = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"excludeZeroViewCount");
        boolean showQueryLogic = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showQueryLogic");
        int delta = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"delta");
        String paginationType = ParamUtil.getString((PortletRequest)actionRequest, (String)"paginationType");
        String[] extensions = actionRequest.getParameterValues("extensions");
        preferences.setValue("selection-style", "dynamic");
        preferences.setValue("merge-url-tags", String.valueOf(mergeUrlTags));
        preferences.setValue("default-scope", String.valueOf(defaultScope));
        preferences.setValues("scope-ids", ArrayUtil.toStringArray((Object[])scopeIds));
        preferences.setValue("asset-vocabulary-id", String.valueOf(assetVocabularyId));
        preferences.setValue("order-by-column-1", orderByColumn1);
        preferences.setValue("order-by-column-2", orderByColumn2);
        preferences.setValue("order-by-type-1", orderByType1);
        preferences.setValue("order-by-type-2", orderByType2);
        preferences.setValue("exclude-zero-view-count", String.valueOf(excludeZeroViewCount));
        preferences.setValue("show-query-logic", String.valueOf(showQueryLogic));
        preferences.setValue("delta", String.valueOf(delta));
        preferences.setValue("pagination-type", paginationType);
        preferences.setValues("extensions", extensions);
    }

    protected void updateManualSettings(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        this.updateDisplaySettings(actionRequest, preferences);
        this.updateRssSettings(actionRequest, preferences);
    }

    protected void updateDisplaySettings(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String displayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"displayStyle");
        boolean anyAssetType = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"anyAssetType");
        long[] classNameIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"classNameIds"), (long)0L);
        boolean showAssetTitle = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showAssetTitle");
        boolean showContextLink = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showContextLink");
        int abstractLength = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"abstractLength");
        String assetLinkBehaviour = ParamUtil.getString((PortletRequest)actionRequest, (String)"assetLinkBehaviour");
        boolean showAvailableLocales = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showAvailableLocales");
        String[] extensions = actionRequest.getParameterValues("extensions");
        boolean enablePrint = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enablePrint");
        boolean enableFlags = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableFlags");
        boolean enableRatings = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableRatings");
        boolean enableComments = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableComments");
        boolean enableCommentRatings = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableCommentRatings");
        boolean enableTagBasedNavigation = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableTagBasedNavigation");
        String medatadaFields = ParamUtil.getString((PortletRequest)actionRequest, (String)"metadataFields");
        preferences.setValue("selection-style", "manual");
        preferences.setValue("display-style", displayStyle);
        preferences.setValue("any-asset-type", String.valueOf(anyAssetType));
        preferences.setValues("class-name-ids", ArrayUtil.toStringArray((long[])classNameIds));
        preferences.setValue("show-asset-title", String.valueOf(showAssetTitle));
        preferences.setValue("show-context-link", String.valueOf(showContextLink));
        preferences.setValue("abstract-length", String.valueOf(abstractLength));
        preferences.setValue("asset-link-behaviour", assetLinkBehaviour);
        preferences.setValue("show-available-locales", String.valueOf(showAvailableLocales));
        preferences.setValues("extensions", extensions);
        preferences.setValue("enable-print", String.valueOf(enablePrint));
        preferences.setValue("enable-flags", String.valueOf(enableFlags));
        preferences.setValue("enable-ratings", String.valueOf(enableRatings));
        preferences.setValue("enable-comments", String.valueOf(enableComments));
        preferences.setValue("enable-comment-ratings", String.valueOf(enableCommentRatings));
        preferences.setValue("enable-tag-based-navigation", String.valueOf(enableTagBasedNavigation));
        preferences.setValue("metadata-fields", medatadaFields);
    }

    protected void updateQueryLogic(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long userId = themeDisplay.getUserId();
        long groupId = themeDisplay.getScopeGroupId();
        int[] queryRulesIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"queryLogicIndexes"), (int)0);
        int i = 0;
        int[] nArray = queryRulesIndexes;
        int n = queryRulesIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int queryRulesIndex = nArray[n2];
            boolean contains = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("queryContains" + queryRulesIndex));
            boolean andOperator = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("queryAndOperator" + queryRulesIndex));
            String name = ParamUtil.getString((PortletRequest)actionRequest, (String)("queryName" + queryRulesIndex));
            String[] values = null;
            if (name.equals("assetTags")) {
                values = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("queryTagNames" + queryRulesIndex)));
                AssetTagLocalServiceUtil.checkTags((long)userId, (long)groupId, (String[])values);
            } else {
                values = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("queryCategoryIds" + queryRulesIndex)));
            }
            preferences.setValue("queryContains" + i, String.valueOf(contains));
            preferences.setValue("queryAndOperator" + i, String.valueOf(andOperator));
            preferences.setValue("queryName" + i, name);
            preferences.setValues("queryValues" + i, values);
            ++i;
            ++n2;
        }
        String[] values = preferences.getValues("queryValues" + i, new String[0]);
        while (values.length > 0) {
            preferences.setValue("queryContains" + i, "");
            preferences.setValue("queryAndOperator" + i, "");
            preferences.setValue("queryName" + i, "");
            preferences.setValues("queryValues" + i, new String[0]);
            values = preferences.getValues("queryValues" + ++i, new String[0]);
        }
    }

    protected void updateRssSettings(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean enableRSS = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableRSS");
        int rssDelta = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"rssDelta");
        String rssDisplayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"rssDisplayStyle");
        String rssFormat = ParamUtil.getString((PortletRequest)actionRequest, (String)"rssFormat");
        String rssName = ParamUtil.getString((PortletRequest)actionRequest, (String)"rssName");
        preferences.setValue("enable-rss", String.valueOf(enableRSS));
        preferences.setValue("rss-delta", String.valueOf(rssDelta));
        preferences.setValue("rss-display-style", rssDisplayStyle);
        preferences.setValue("rss-format", rssFormat);
        preferences.setValue("rss-name", rssName);
    }
}

