/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.cache.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.asset.DuplicateTagException;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetTagProperty;
import com.liferay.portlet.asset.service.base.AssetTagLocalServiceBaseImpl;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.util.Autocomplete;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetTagLocalServiceImpl
extends AssetTagLocalServiceBaseImpl {
    public AssetTag addTag(long userId, String name, String[] tagProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        if (tagProperties == null) {
            tagProperties = new String[]{};
        }
        Date now = new Date();
        long tagId = this.counterLocalService.increment();
        AssetTag tag = this.assetTagPersistence.create(tagId);
        tag.setGroupId(groupId);
        tag.setCompanyId(user.getCompanyId());
        tag.setUserId(user.getUserId());
        tag.setUserName(user.getFullName());
        tag.setCreateDate(now);
        tag.setModifiedDate(now);
        name = name.trim();
        name = name.toLowerCase();
        if (this.hasTag(groupId, name)) {
            throw new DuplicateTagException("A tag with the name " + name + " already exists");
        }
        this.validate(name);
        tag.setName(name);
        this.assetTagPersistence.update((BaseModel)tag, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addTagResources(tag, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addTagResources(tag, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        int i = 0;
        while (i < tagProperties.length) {
            String[] tagProperty = StringUtil.split((String)tagProperties[i], (String)":");
            String key = "";
            if (tagProperty.length > 1) {
                key = GetterUtil.getString((String)tagProperty[1]);
            }
            String value = "";
            if (tagProperty.length > 2) {
                value = GetterUtil.getString((String)tagProperty[2]);
            }
            if (Validator.isNotNull((String)key)) {
                this.assetTagPropertyLocalService.addTagProperty(userId, tagId, key, value);
            }
            ++i;
        }
        return tag;
    }

    public void addTagResources(AssetTag tag, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(tag.getCompanyId(), tag.getGroupId(), tag.getUserId(), AssetTag.class.getName(), tag.getTagId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addTagResources(AssetTag tag, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(tag.getCompanyId(), tag.getGroupId(), tag.getUserId(), AssetTag.class.getName(), tag.getTagId(), communityPermissions, guestPermissions);
    }

    public void checkTags(long userId, long groupId, String[] names) throws PortalException, SystemException {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                this.getTag(groupId, name);
            }
            catch (NoSuchTagException noSuchTagException) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddCommunityPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                serviceContext.setScopeGroupId(groupId);
                this.addTag(userId, name, PropsValues.ASSET_TAG_PROPERTIES_DEFAULT, serviceContext);
            }
            ++n2;
        }
    }

    public AssetTag decrementAssetCount(long tagId, long classNameId) throws PortalException, SystemException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        tag.setAssetCount(Math.max(0, tag.getAssetCount() - 1));
        this.assetTagPersistence.update((BaseModel)tag, false);
        this.assetTagStatsLocalService.updateTagStats(tagId, classNameId);
        return tag;
    }

    public void deleteTag(AssetTag tag) throws PortalException, SystemException {
        List entries = this.assetTagPersistence.getAssetEntries(tag.getTagId());
        this.assetTagPersistence.remove((BaseModel)tag);
        this.resourceLocalService.deleteResource(tag.getCompanyId(), AssetTag.class.getName(), 4, tag.getTagId());
        this.assetTagPropertyLocalService.deleteTagProperties(tag.getTagId());
        this.reindex(entries);
    }

    public void deleteTag(long tagId) throws PortalException, SystemException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        this.deleteTag(tag);
    }

    public List<AssetTag> getEntryTags(long entryId) throws SystemException {
        return this.assetTagFinder.findByEntryId(entryId);
    }

    public List<AssetTag> getGroupTags(long groupId) throws SystemException {
        return this.assetTagPersistence.findByGroupId(groupId);
    }

    public AssetTag getTag(long tagId) throws PortalException, SystemException {
        return this.assetTagPersistence.findByPrimaryKey(tagId);
    }

    public AssetTag getTag(long groupId, String name) throws PortalException, SystemException {
        return this.assetTagFinder.findByG_N(groupId, name);
    }

    public long[] getTagIds(long groupId, String[] names) throws PortalException, SystemException {
        ArrayList<Long> tagIds = new ArrayList<Long>(names.length);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                AssetTag tag = this.getTag(groupId, name);
                tagIds.add(tag.getTagId());
            }
            catch (NoSuchTagException noSuchTagException) {}
            ++n2;
        }
        return ArrayUtil.toArray((Long[])tagIds.toArray(new Long[tagIds.size()]));
    }

    public String[] getTagNames() throws SystemException {
        return this.getTagNames(this.getTags());
    }

    public String[] getTagNames(long classNameId, long classPK) throws SystemException {
        return this.getTagNames(this.getTags(classNameId, classPK));
    }

    public String[] getTagNames(String className, long classPK) throws SystemException {
        return this.getTagNames(this.getTags(className, classPK));
    }

    public List<AssetTag> getTags() throws SystemException {
        return this.assetTagPersistence.findAll();
    }

    public List<AssetTag> getTags(long classNameId, long classPK) throws SystemException {
        return this.assetTagFinder.findByC_C(classNameId, classPK);
    }

    public List<AssetTag> getTags(long groupId, long classNameId, String name) throws SystemException {
        return this.assetTagFinder.findByG_C_N(groupId, classNameId, name);
    }

    public List<AssetTag> getTags(long groupId, long classNameId, String name, int start, int end) throws SystemException {
        return this.assetTagFinder.findByG_C_N(groupId, classNameId, name, start, end);
    }

    @ThreadLocalCachable
    public List<AssetTag> getTags(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getTags(classNameId, classPK);
    }

    public int getTagsSize(long groupId, long classNameId, String name) throws SystemException {
        return this.assetTagFinder.countByG_C_N(groupId, classNameId, name);
    }

    public boolean hasTag(long groupId, String name) throws PortalException, SystemException {
        try {
            this.getTag(groupId, name);
            return true;
        }
        catch (NoSuchTagException noSuchTagException) {
            return false;
        }
    }

    public AssetTag incrementAssetCount(long tagId, long classNameId) throws PortalException, SystemException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        tag.setAssetCount(tag.getAssetCount() + 1);
        this.assetTagPersistence.update((BaseModel)tag, false);
        this.assetTagStatsLocalService.updateTagStats(tagId, classNameId);
        return tag;
    }

    public void mergeTags(long fromTagId, long toTagId) throws PortalException, SystemException {
        List entries = this.assetTagPersistence.getAssetEntries(fromTagId);
        this.assetTagPersistence.addAssetEntries(toTagId, entries);
        List tagProperties = this.assetTagPropertyPersistence.findByTagId(fromTagId);
        for (AssetTagProperty fromTagProperty : tagProperties) {
            AssetTagProperty toTagProperty = this.assetTagPropertyPersistence.fetchByT_K(toTagId, fromTagProperty.getKey());
            if (toTagProperty != null) continue;
            fromTagProperty.setTagId(toTagId);
            this.assetTagPropertyPersistence.update((BaseModel)fromTagProperty, false);
        }
        this.deleteTag(fromTagId);
    }

    public JSONArray search(long groupId, String name, String[] tagProperties, int start, int end) throws SystemException {
        List list = this.assetTagFinder.findByG_N_P(groupId, name, tagProperties, start, end);
        return Autocomplete.listToJson((List)list, (String)"name", (String)"name");
    }

    public AssetTag updateTag(long userId, long tagId, String name, String[] tagProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        String oldName = tag.getName();
        tag.setModifiedDate(new Date());
        name = name.trim();
        name = name.toLowerCase();
        if (tagProperties == null) {
            tagProperties = new String[]{};
        }
        if (!tag.getName().equals(name) && this.hasTag(tag.getGroupId(), name)) {
            throw new DuplicateTagException("A tag with the name " + name + " already exists");
        }
        if (!tag.getName().equals(name)) {
            try {
                AssetTag existingAssetTag = this.getTag(tag.getGroupId(), name);
                if (existingAssetTag.getTagId() != tagId) {
                    throw new DuplicateTagException("A tag with the name " + name + " already exists");
                }
            }
            catch (NoSuchTagException noSuchTagException) {}
        }
        this.validate(name);
        tag.setName(name);
        this.assetTagPersistence.update((BaseModel)tag, false);
        List oldTagProperties = this.assetTagPropertyPersistence.findByTagId(tagId);
        for (AssetTagProperty tagProperty : oldTagProperties) {
            this.assetTagPropertyLocalService.deleteTagProperty(tagProperty);
        }
        int i = 0;
        while (i < tagProperties.length) {
            String[] tagProperty = StringUtil.split((String)tagProperties[i], (String)":");
            String key = "";
            if (tagProperty.length > 0) {
                key = GetterUtil.getString((String)tagProperty[0]);
            }
            String value = "";
            if (tagProperty.length > 1) {
                value = GetterUtil.getString((String)tagProperty[1]);
            }
            if (Validator.isNotNull((String)key)) {
                this.assetTagPropertyLocalService.addTagProperty(userId, tagId, key, value);
            }
            ++i;
        }
        if (!oldName.equals(name)) {
            List entries = this.assetTagPersistence.getAssetEntries(tag.getTagId());
            this.reindex(entries);
        }
        return tag;
    }

    protected String[] getTagNames(List<AssetTag> tags) {
        return StringUtil.split((String)ListUtil.toString(tags, (String)"name"));
    }

    protected void reindex(List<AssetEntry> entries) throws PortalException {
        for (AssetEntry entry : entries) {
            String className = PortalUtil.getClassName((long)entry.getClassNameId());
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)className);
            indexer.reindex(className, entry.getClassPK());
        }
    }

    protected void validate(String name) throws PortalException {
        if (!AssetUtil.isValidWord(name)) {
            throw new AssetTagException(2);
        }
    }
}

