/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.CustomUserAttributes;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.portlet.UserAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInfoFactory {
    private static Log _log = LogFactoryUtil.getLog(UserInfoFactory.class);

    public static LinkedHashMap<String, String> getUserInfo(long userId, Portlet portlet) {
        if (userId <= 0L) {
            return null;
        }
        LinkedHashMap<String, String> userInfo = new LinkedHashMap<String, String>();
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            userInfo = UserInfoFactory.getUserInfo(user, userInfo, portlet);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return userInfo;
    }

    public static LinkedHashMap<String, String> getUserInfo(HttpServletRequest request, Portlet portlet) {
        if (request.getRemoteUser() == null) {
            return null;
        }
        LinkedHashMap<String, String> userInfo = new LinkedHashMap<String, String>();
        try {
            User user = PortalUtil.getUser((HttpServletRequest)request);
            userInfo = UserInfoFactory.getUserInfo(user, userInfo, portlet);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return userInfo;
    }

    public static LinkedHashMap<String, String> getUserInfo(User user, LinkedHashMap<String, String> userInfo, Portlet portlet) {
        PortletApp portletApp = portlet.getPortletApp();
        try {
            UserAttributes userAttributes = new UserAttributes(user);
            userInfo.put("liferay.company.id", userAttributes.getValue("liferay.company.id"));
            userInfo.put("liferay.user.id", userAttributes.getValue("liferay.user.id"));
            for (String attrName : portletApp.getUserAttributes()) {
                String attrValue = userAttributes.getValue(attrName);
                if (attrValue == null) continue;
                userInfo.put(attrName, attrValue);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        Map unmodifiableUserInfo = Collections.unmodifiableMap((Map)userInfo.clone());
        HashMap<String, CustomUserAttributes> cuaInstances = new HashMap<String, CustomUserAttributes>();
        for (Map.Entry entry : portletApp.getCustomUserAttributes().entrySet()) {
            String attrValue;
            String attrName = (String)entry.getKey();
            String attrCustomClass = (String)entry.getValue();
            CustomUserAttributes cua = (CustomUserAttributes)cuaInstances.get(attrCustomClass);
            if (cua == null) {
                if (portletApp.isWARFile()) {
                    PortletContextBag portletContextBag = PortletContextBagPool.get(portletApp.getServletContextName());
                    Map<String, CustomUserAttributes> customUserAttributes = portletContextBag.getCustomUserAttributes();
                    cua = customUserAttributes.get(attrCustomClass);
                    cua = (CustomUserAttributes)cua.clone();
                } else {
                    try {
                        cua = (CustomUserAttributes)InstanceFactory.newInstance((String)attrCustomClass);
                    }
                    catch (Exception e) {
                        _log.error((Object)e, (Throwable)e);
                    }
                }
                cuaInstances.put(attrCustomClass, cua);
            }
            if (cua == null || (attrValue = cua.getValue(attrName, unmodifiableUserInfo)) == null) continue;
            userInfo.put(attrName, attrValue);
        }
        return userInfo;
    }
}

