/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.dao.shard.ShardPollerProcessorWrapper;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.Route;
import com.liferay.portal.kernel.portlet.Router;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.OpenSearch;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.servlet.URLEncoder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xmlrpc.Method;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.poller.PollerProcessorUtil;
import com.liferay.portal.pop.POPServerUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.xmlrpc.XmlRpcServlet;
import com.liferay.portlet.ControlPanelEntry;
import com.liferay.portlet.PortletBagImpl;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletPreferencesSerializer;
import com.liferay.portlet.RouterImpl;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.expando.model.CustomAttributesDisplay;
import com.liferay.portlet.social.model.SocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialRequestInterpreter;
import com.liferay.portlet.social.model.impl.SocialActivityInterpreterImpl;
import com.liferay.portlet.social.model.impl.SocialRequestInterpreterImpl;
import com.liferay.portlet.social.service.SocialActivityInterpreterLocalServiceUtil;
import com.liferay.portlet.social.service.SocialRequestInterpreterLocalServiceUtil;
import com.liferay.util.portlet.PortletProps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.Portlet;
import javax.portlet.PreferencesValidator;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletBagFactory {
    private static final MethodKey _getMethodKey = new MethodKey(PortletProps.class.getName(), "get", new Class[]{String.class});
    private static Log _log = LogFactoryUtil.getLog(PortletBagFactory.class);
    private ClassLoader _classLoader;
    private ServletContext _servletContext;
    private boolean _warFile;

    public PortletBag create(com.liferay.portal.model.Portlet portlet) throws Exception {
        PortletApp portletApp = portlet.getPortletApp();
        if (!portletApp.isWARFile() && this._warFile) {
            String contextPath = PortalUtil.getPathContext();
            this._servletContext = ServletContextPool.get((String)contextPath);
            this._classLoader = PortalClassLoaderUtil.getClassLoader();
        }
        Class<?> portletClass = null;
        try {
            portletClass = this._classLoader.loadClass(portlet.getPortletClass());
        }
        catch (Throwable e) {
            _log.error((Object)e, e);
            PortletLocalServiceUtil.destroyPortlet((com.liferay.portal.model.Portlet)portlet);
            return null;
        }
        Portlet portletInstance = (Portlet)portletClass.newInstance();
        ConfigurationAction configurationActionInstance = this.newConfigurationAction(portlet);
        Indexer indexerInstance = this.newIndexer(portlet);
        OpenSearch openSearchInstance = this.newOpenSearch(portlet);
        this.initSchedulers(portlet);
        FriendlyURLMapper friendlyURLMapperInstance = this.newFriendlyURLMapper(portlet);
        URLEncoder urlEncoderInstance = this.newURLEncoder(portlet);
        PortletDataHandler portletDataHandlerInstance = this.newPortletDataHandler(portlet);
        PortletLayoutListener portletLayoutListenerInstance = this.newPortletLayoutListener(portlet);
        PollerProcessor pollerProcessorInstance = this.newPollerProcessor(portlet);
        MessageListener popMessageListenerInstance = this.newPOPMessageListener(portlet);
        SocialActivityInterpreter socialActivityInterpreterInstance = this.initSocialActivityInterpreterInstance(portlet);
        SocialRequestInterpreter socialRequestInterpreterInstance = null;
        if (Validator.isNotNull((String)portlet.getSocialRequestInterpreterClass())) {
            socialRequestInterpreterInstance = (SocialRequestInterpreter)this.newInstance(SocialRequestInterpreter.class, portlet.getSocialRequestInterpreterClass());
            socialRequestInterpreterInstance = new SocialRequestInterpreterImpl(portlet.getPortletId(), socialRequestInterpreterInstance);
            SocialRequestInterpreterLocalServiceUtil.addRequestInterpreter((SocialRequestInterpreter)socialRequestInterpreterInstance);
        }
        WebDAVStorage webDAVStorageInstance = null;
        if (Validator.isNotNull((String)portlet.getWebDAVStorageClass())) {
            webDAVStorageInstance = (WebDAVStorage)this.newInstance(WebDAVStorage.class, portlet.getWebDAVStorageClass());
            webDAVStorageInstance.setToken(portlet.getWebDAVStorageToken());
            WebDAVUtil.addStorage((WebDAVStorage)webDAVStorageInstance);
        }
        Method xmlRpcMethodInstance = null;
        if (Validator.isNotNull((String)portlet.getXmlRpcMethodClass())) {
            xmlRpcMethodInstance = (Method)this.newInstance(Method.class, portlet.getXmlRpcMethodClass());
            XmlRpcServlet.registerMethod(xmlRpcMethodInstance);
        }
        ControlPanelEntry controlPanelEntryInstance = null;
        if (Validator.isNotNull((String)portlet.getControlPanelEntryClass())) {
            controlPanelEntryInstance = (ControlPanelEntry)this.newInstance(ControlPanelEntry.class, portlet.getControlPanelEntryClass());
        }
        List<AssetRendererFactory> assetRendererFactoryInstances = this.newAssetRendererFactoryInstances(portlet);
        ArrayList<CustomAttributesDisplay> customAttributesDisplayInstances = new ArrayList<CustomAttributesDisplay>();
        for (String customAttributesDisplayClass : portlet.getCustomAttributesDisplayClasses()) {
            CustomAttributesDisplay customAttributesDisplayInstance = (CustomAttributesDisplay)this.newInstance(CustomAttributesDisplay.class, customAttributesDisplayClass);
            customAttributesDisplayInstance.setClassNameId(PortalUtil.getClassNameId((String)customAttributesDisplayInstance.getClassName()));
            customAttributesDisplayInstance.setPortletId(portlet.getPortletId());
            customAttributesDisplayInstances.add(customAttributesDisplayInstance);
        }
        ArrayList<WorkflowHandler> workflowHandlerInstances = new ArrayList<WorkflowHandler>();
        for (String workflowHandlerClass : portlet.getWorkflowHandlerClasses()) {
            WorkflowHandler workflowHandlerInstance = (WorkflowHandler)this.newInstance(WorkflowHandler.class, workflowHandlerClass);
            workflowHandlerInstances.add(workflowHandlerInstance);
            WorkflowHandlerRegistryUtil.register((WorkflowHandler)workflowHandlerInstance);
        }
        PreferencesValidator preferencesValidatorInstance = null;
        if (Validator.isNotNull((String)portlet.getPreferencesValidator())) {
            preferencesValidatorInstance = (PreferencesValidator)this.newInstance(PreferencesValidator.class, portlet.getPreferencesValidator());
            try {
                if (PropsValues.PREFERENCE_VALIDATE_ON_STARTUP) {
                    preferencesValidatorInstance.validate(PortletPreferencesSerializer.fromDefaultXML(portlet.getDefaultPreferences()));
                }
            }
            catch (Exception exception) {
                _log.warn((Object)("Portlet with the name " + portlet.getPortletId() + " does not have valid default preferences"));
            }
        }
        HashMap<String, ResourceBundle> resourceBundles = null;
        if (Validator.isNotNull((String)portlet.getResourceBundle())) {
            resourceBundles = new HashMap<String, ResourceBundle>();
            this.initResourceBundle(resourceBundles, portlet, LocaleUtil.getDefault());
            Set supportedLocales = portlet.getSupportedLocales();
            if (supportedLocales.isEmpty()) {
                supportedLocales = SetUtil.fromArray((Object[])PropsValues.LOCALES);
            }
            for (String supportedLocale : supportedLocales) {
                Locale locale = LocaleUtil.fromLanguageId((String)supportedLocale);
                this.initResourceBundle(resourceBundles, portlet, locale);
            }
        }
        PortletBagImpl portletBag = new PortletBagImpl(portlet.getPortletId(), this._servletContext, portletInstance, configurationActionInstance, indexerInstance, openSearchInstance, friendlyURLMapperInstance, urlEncoderInstance, portletDataHandlerInstance, portletLayoutListenerInstance, pollerProcessorInstance, popMessageListenerInstance, socialActivityInterpreterInstance, socialRequestInterpreterInstance, webDAVStorageInstance, xmlRpcMethodInstance, controlPanelEntryInstance, assetRendererFactoryInstances, customAttributesDisplayInstances, workflowHandlerInstances, preferencesValidatorInstance, resourceBundles);
        PortletBagPool.put((String)portlet.getRootPortletId(), (PortletBag)portletBag);
        try {
            PortletInstanceFactoryUtil.create((com.liferay.portal.model.Portlet)portlet, (ServletContext)this._servletContext);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return portletBag;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public void setWARFile(boolean warFile) {
        this._warFile = warFile;
    }

    protected String getPluginPropertyValue(String propertyKey) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this._classLoader);
            MethodHandler methodHandler = new MethodHandler(_getMethodKey, new Object[]{propertyKey});
            String string = (String)methodHandler.invoke(false);
            return string;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected void initResourceBundle(Map<String, ResourceBundle> resourceBundles, com.liferay.portal.model.Portlet portlet, Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(portlet.getResourceBundle(), locale, this._classLoader);
            resourceBundles.put(LocaleUtil.toLanguageId((Locale)locale), resourceBundle);
        }
        catch (MissingResourceException mre) {
            _log.warn((Object)mre.getMessage());
        }
    }

    protected void initScheduler(SchedulerEntry schedulerEntry) throws Exception {
        String propertyKey = schedulerEntry.getPropertyKey();
        if (Validator.isNotNull((String)propertyKey)) {
            String triggerValue = null;
            triggerValue = this._warFile ? this.getPluginPropertyValue(propertyKey) : PrefsPropsUtil.getString((String)propertyKey);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Scheduler property key " + propertyKey + " has trigger value " + triggerValue));
            }
            if (Validator.isNull((String)triggerValue)) {
                throw new SchedulerException("Property key " + propertyKey + " requires a value");
            }
            schedulerEntry.setTriggerValue(triggerValue);
        }
        SchedulerEngineUtil.schedule((SchedulerEntry)schedulerEntry, (ClassLoader)this._classLoader);
    }

    protected void initSchedulers(com.liferay.portal.model.Portlet portlet) throws Exception {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        List schedulerEntries = portlet.getSchedulerEntries();
        if (schedulerEntries == null || schedulerEntries.isEmpty()) {
            return;
        }
        for (SchedulerEntry schedulerEntry : schedulerEntries) {
            this.initScheduler(schedulerEntry);
        }
    }

    protected SocialActivityInterpreter initSocialActivityInterpreterInstance(com.liferay.portal.model.Portlet portlet) throws Exception {
        if (Validator.isNull((String)portlet.getSocialActivityInterpreterClass())) {
            return null;
        }
        SocialActivityInterpreter socialActivityInterpreterInstance = (SocialActivityInterpreter)this.newInstance(SocialActivityInterpreter.class, portlet.getSocialActivityInterpreterClass());
        socialActivityInterpreterInstance = new SocialActivityInterpreterImpl(portlet.getPortletId(), socialActivityInterpreterInstance);
        SocialActivityInterpreterLocalServiceUtil.addActivityInterpreter((SocialActivityInterpreter)socialActivityInterpreterInstance);
        return socialActivityInterpreterInstance;
    }

    protected AssetRendererFactory newAssetRendererFactoryInstance(com.liferay.portal.model.Portlet portlet, String assetRendererFactoryClass) throws Exception {
        AssetRendererFactory assetRendererFactoryInstance = (AssetRendererFactory)this.newInstance(AssetRendererFactory.class, assetRendererFactoryClass);
        assetRendererFactoryInstance.setClassNameId(PortalUtil.getClassNameId((String)assetRendererFactoryInstance.getClassName()));
        assetRendererFactoryInstance.setPortletId(portlet.getPortletId());
        AssetRendererFactoryRegistryUtil.register((AssetRendererFactory)assetRendererFactoryInstance);
        return assetRendererFactoryInstance;
    }

    protected List<AssetRendererFactory> newAssetRendererFactoryInstances(com.liferay.portal.model.Portlet portlet) throws Exception {
        ArrayList<AssetRendererFactory> assetRendererFactoryInstances = new ArrayList<AssetRendererFactory>();
        for (String assetRendererFactoryClass : portlet.getAssetRendererFactoryClasses()) {
            String assetRendererEnabledPropertyKey = "asset.renderer.enabled." + assetRendererFactoryClass;
            String assetRendererEnabledPropertyValue = null;
            assetRendererEnabledPropertyValue = this._warFile ? this.getPluginPropertyValue(assetRendererEnabledPropertyKey) : PropsUtil.get((String)assetRendererEnabledPropertyKey);
            boolean assetRendererEnabledValue = GetterUtil.getBoolean((String)assetRendererEnabledPropertyValue, (boolean)true);
            if (!assetRendererEnabledValue) continue;
            AssetRendererFactory assetRendererFactoryInstance = this.newAssetRendererFactoryInstance(portlet, assetRendererFactoryClass);
            assetRendererFactoryInstances.add(assetRendererFactoryInstance);
        }
        return assetRendererFactoryInstances;
    }

    protected ConfigurationAction newConfigurationAction(com.liferay.portal.model.Portlet portlet) throws Exception {
        if (Validator.isNull((String)portlet.getConfigurationActionClass())) {
            return null;
        }
        return (ConfigurationAction)this.newInstance(ConfigurationAction.class, portlet.getConfigurationActionClass());
    }

    protected FriendlyURLMapper newFriendlyURLMapper(com.liferay.portal.model.Portlet portlet) throws Exception {
        if (Validator.isNull((String)portlet.getFriendlyURLMapperClass())) {
            return null;
        }
        FriendlyURLMapper friendlyURLMapper = (FriendlyURLMapper)this.newInstance(FriendlyURLMapper.class, portlet.getFriendlyURLMapperClass());
        friendlyURLMapper.setMapping(portlet.getFriendlyURLMapping());
        friendlyURLMapper.setPortletId(portlet.getPortletId());
        friendlyURLMapper.setPortletInstanceable(portlet.isInstanceable());
        Router router = this.newFriendlyURLRouter(portlet);
        friendlyURLMapper.setRouter(router);
        return friendlyURLMapper;
    }

    protected Router newFriendlyURLRouter(com.liferay.portal.model.Portlet portlet) throws Exception {
        if (Validator.isNull((String)portlet.getFriendlyURLRoutes())) {
            return null;
        }
        RouterImpl router = new RouterImpl();
        String xml = StringUtil.read((ClassLoader)this._classLoader, (String)portlet.getFriendlyURLRoutes());
        Document document = SAXReaderUtil.read((String)xml, (boolean)true);
        Element rootElement = document.getRootElement();
        for (Element routeElement : rootElement.elements("route")) {
            String value;
            String name;
            String pattern = routeElement.elementText("pattern");
            Route route = router.addRoute(pattern);
            for (Element generatedParameterElement : routeElement.elements("generated-parameter")) {
                name = generatedParameterElement.attributeValue("name");
                value = generatedParameterElement.getText();
                route.addGeneratedParameter(name, value);
            }
            for (Element ignoredParameterElement : routeElement.elements("ignored-parameter")) {
                name = ignoredParameterElement.attributeValue("name");
                route.addIgnoredParameter(name);
            }
            for (Element implicitParameterElement : routeElement.elements("implicit-parameter")) {
                name = implicitParameterElement.attributeValue("name");
                value = implicitParameterElement.getText();
                route.addImplicitParameter(name, value);
            }
            for (Element overriddenParameterElement : routeElement.elements("overridden-parameter")) {
                name = overriddenParameterElement.attributeValue("name");
                value = overriddenParameterElement.getText();
                route.addOverriddenParameter(name, value);
            }
        }
        return router;
    }

    protected Indexer newIndexer(com.liferay.portal.model.Portlet portlet) throws Exception {
        if (Validator.isNull((String)portlet.getIndexerClass())) {
            return null;
        }
        Indexer indexerInstance = (Indexer)this.newInstance(Indexer.class, portlet.getIndexerClass());
        IndexerRegistryUtil.register((Indexer)indexerInstance);
        return indexerInstance;
    }

    protected Object newInstance(Class<?> interfaceClass, String implClassName) throws Exception {
        return this.newInstance(new Class[]{interfaceClass}, implClassName);
    }

    protected Object newInstance(Class<?>[] interfaceClasses, String implClassName) throws Exception {
        if (this._warFile) {
            return ProxyFactory.newInstance((ClassLoader)this._classLoader, (Class[])interfaceClasses, (String)implClassName);
        }
        Class<?> classObj = this._classLoader.loadClass(implClassName);
        return classObj.newInstance();
    }

    protected OpenSearch newOpenSearch(com.liferay.portal.model.Portlet portlet) throws Exception {
        if (Validator.isNull((String)portlet.getOpenSearchClass())) {
            return null;
        }
        return (OpenSearch)this.newInstance(OpenSearch.class, portlet.getOpenSearchClass());
    }

    protected PollerProcessor newPollerProcessor(com.liferay.portal.model.Portlet portlet) throws Exception {
        if (Validator.isNull((String)portlet.getPollerProcessorClass())) {
            return null;
        }
        PollerProcessor pollerProcessorInstance = (PollerProcessor)this.newInstance(PollerProcessor.class, portlet.getPollerProcessorClass());
        PollerProcessorUtil.addPollerProcessor(portlet.getPortletId(), new ShardPollerProcessorWrapper(pollerProcessorInstance));
        return pollerProcessorInstance;
    }

    protected MessageListener newPOPMessageListener(com.liferay.portal.model.Portlet portlet) throws Exception {
        if (Validator.isNull((String)portlet.getPopMessageListenerClass())) {
            return null;
        }
        MessageListener popMessageListenerInstance = (MessageListener)this.newInstance(MessageListener.class, portlet.getPopMessageListenerClass());
        POPServerUtil.addListener(popMessageListenerInstance);
        return popMessageListenerInstance;
    }

    protected PortletDataHandler newPortletDataHandler(com.liferay.portal.model.Portlet portlet) throws Exception {
        if (Validator.isNull((String)portlet.getPortletDataHandlerClass())) {
            return null;
        }
        return (PortletDataHandler)this.newInstance(PortletDataHandler.class, portlet.getPortletDataHandlerClass());
    }

    protected PortletLayoutListener newPortletLayoutListener(com.liferay.portal.model.Portlet portlet) throws Exception {
        if (Validator.isNull((String)portlet.getPortletLayoutListenerClass())) {
            return null;
        }
        return (PortletLayoutListener)this.newInstance(PortletLayoutListener.class, portlet.getPortletLayoutListenerClass());
    }

    protected URLEncoder newURLEncoder(com.liferay.portal.model.Portlet portlet) throws Exception {
        if (Validator.isNull((String)portlet.getURLEncoderClass())) {
            return null;
        }
        return (URLEncoder)this.newInstance(URLEncoder.class, portlet.getURLEncoderClass());
    }
}

