/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webserver;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.freemarker.FreeMarkerContext;
import com.liferay.portal.kernel.freemarker.FreeMarkerEngineUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.Validator_IW;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.webserver.WebServerEntry;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileShortcutServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import com.liferay.util.servlet.ServletResponseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServerServlet
extends HttpServlet {
    private static final String _DATE_FORMAT_PATTERN = "d MMM yyyy HH:mm z";
    private static final String _TPL_TEMPLATE = "com/liferay/portal/webserver/dependencies/template.ftl";
    private static Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"d MMM yyyy HH:mm z");

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            User user = PortalUtil.getUser((HttpServletRequest)request);
            if (user == null) {
                Company company = CompanyLocalServiceUtil.getCompany((long)companyId);
                user = company.getDefaultUser();
            }
            PrincipalThreadLocal.setName((long)user.getUserId());
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)true);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            String path = HttpUtil.fixPath((String)request.getPathInfo());
            String[] pathArray = StringUtil.split((String)path, (String)"/");
            if (pathArray.length == 0) {
                this.sendGroups(response, user, String.valueOf(request.getServletPath()) + "/" + path);
            } else if (Validator.isNumber((String)pathArray[0])) {
                this.sendFile(request, response, user, pathArray);
            } else {
                this.sendDocumentLibrary(request, response, user, String.valueOf(request.getServletPath()) + "/" + path, pathArray);
            }
        }
        catch (NoSuchFileEntryException nsfee) {
            PortalUtil.sendError((int)404, (Exception)((Object)nsfee), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected long getGroupId(long companyId, String name) throws Exception {
        try {
            Group group = GroupLocalServiceUtil.getFriendlyURLGroup((long)companyId, (String)("/" + name));
            return group.getGroupId();
        }
        catch (NoSuchGroupException noSuchGroupException) {
            User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)name);
            Group group = user.getGroup();
            return group.getGroupId();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void sendDocumentLibrary(HttpServletRequest request, HttpServletResponse response, User user, String path, String[] pathArray) throws Exception {
        groupId = this.getGroupId(user.getCompanyId(), pathArray[0]);
        dlFolderId = 0L;
        i = 1;
        while (i < pathArray.length) {
            name = pathArray[i];
            try {
                folder = DLFolderServiceUtil.getFolder((long)groupId, (long)dlFolderId, (String)name);
                dlFolderId = folder.getFolderId();
            }
            catch (NoSuchFolderException nsfe) {
                if (i != pathArray.length - 1) {
                    throw nsfe;
                }
                title = name;
                this.sendFile(response, user, groupId, dlFolderId, title);
                return;
            }
            ++i;
        }
        try {
            this.sendFile(response, user, groupId, dlFolderId, "index.html");
            return;
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                try {
                    this.sendFile(response, user, groupId, dlFolderId, "index.htm");
                    return;
                }
                catch (NoSuchFileEntryException v0) {
                }
                catch (PrincipalException v1) {}
            } else {
                throw e;
            }
            webServerEntries = new ArrayList<WebServerEntry>();
            webServerEntries.add(new WebServerEntry(path, "../"));
            dlFolders = DLFolderServiceUtil.getFolders((long)groupId, (long)dlFolderId);
            ** for (dlFolder : dlFolders)
        }
lbl-1000:
        // 1 sources

        {
            webServerEntries.add(new WebServerEntry(path, String.valueOf(dlFolder.getName()) + "/", dlFolder.getCreateDate(), dlFolder.getModifiedDate(), dlFolder.getDescription(), 0L));
            continue;
        }
lbl39:
        // 1 sources

        dlFileEntries = DLFileEntryServiceUtil.getFileEntries((long)groupId, (long)dlFolderId);
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            webServerEntries.add(new WebServerEntry(path, dlFileEntry.getTitle(), dlFileEntry.getCreateDate(), dlFileEntry.getModifiedDate(), dlFileEntry.getDescription(), dlFileEntry.getSize()));
        }
        this.sendHTML(response, path, webServerEntries);
    }

    protected void sendFile(HttpServletRequest request, HttpServletResponse response, User user, String[] pathArray) throws Exception {
        String sourceExtension;
        String id;
        InputStream convertedIS;
        DLFileVersion fileVersion;
        String extension;
        long groupId = 0L;
        long folderId = 0L;
        String name = null;
        String fileName = null;
        DLFileEntry dlFileEntry = null;
        if (pathArray.length == 1) {
            long fileShortcutId = GetterUtil.getLong((String)pathArray[0]);
            DLFileShortcut fileShortcut = DLFileShortcutServiceUtil.getFileShortcut((long)fileShortcutId);
            groupId = fileShortcut.getGroupId();
            folderId = fileShortcut.getToFolderId();
            name = fileShortcut.getToName();
            dlFileEntry = DLFileEntryServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)name);
            fileName = dlFileEntry.getTitle();
        } else if (pathArray.length == 2) {
            groupId = GetterUtil.getLong((String)pathArray[0]);
            dlFileEntry = DLFileEntryServiceUtil.getFileEntryByUuidAndGroupId((String)pathArray[1], (long)groupId);
            folderId = dlFileEntry.getFolderId();
            fileName = dlFileEntry.getTitle();
            name = dlFileEntry.getName();
        } else {
            groupId = GetterUtil.getLong((String)pathArray[0]);
            folderId = GetterUtil.getLong((String)pathArray[1]);
            fileName = HttpUtil.decodeURL((String)pathArray[2], (boolean)true);
            dlFileEntry = DLFileEntryServiceUtil.getFileEntryByTitle((long)groupId, (long)folderId, (String)fileName);
            name = dlFileEntry.getName();
        }
        if (dlFileEntry == null) {
            throw new NoSuchFileEntryException();
        }
        String version = ParamUtil.getString((HttpServletRequest)request, (String)"version");
        String targetExtension = ParamUtil.getString((HttpServletRequest)request, (String)"targetExtension");
        if (Validator.isNull((String)version)) {
            if (Validator.isNotNull((String)dlFileEntry.getVersion())) {
                version = dlFileEntry.getVersion();
            } else {
                throw new NoSuchFileEntryException();
            }
        }
        if (Validator.isNull((String)(extension = GetterUtil.getString((String)FileUtil.getExtension((String)(fileName = (fileVersion = DLFileVersionLocalServiceUtil.getFileVersion((long)groupId, (long)folderId, (String)name, (String)version)).getTitle()))))) || !extension.equals(fileVersion.getExtension())) {
            fileName = String.valueOf(fileName) + "." + fileVersion.getExtension();
        }
        InputStream is = DLFileEntryLocalServiceUtil.getFileAsStream((long)user.getCompanyId(), (long)user.getUserId(), (long)groupId, (long)folderId, (String)name, (String)version);
        boolean converted = false;
        if (Validator.isNotNull((String)targetExtension) && (convertedIS = DocumentConversionUtil.convert(id = DocumentConversionUtil.getTempFileId(dlFileEntry.getFileEntryId(), version), is, sourceExtension = FileUtil.getExtension((String)fileName), targetExtension)) != null && convertedIS != is) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(targetExtension);
            is = convertedIS;
            converted = true;
        }
        int contentLength = 0;
        if (!converted) {
            contentLength = DLUtil.compareVersions((String)version, (String)dlFileEntry.getVersion()) >= 0 ? (int)dlFileEntry.getSize() : (int)fileVersion.getSize();
        }
        String contentType = MimeTypesUtil.getContentType((String)fileName);
        ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)is, (int)contentLength, (String)contentType);
    }

    protected void sendFile(HttpServletResponse response, User user, long groupId, long folderId, String title) throws Exception {
        DLFileEntry dlFileEntry = DLFileEntryServiceUtil.getFileEntryByTitle((long)groupId, (long)folderId, (String)title);
        String contentType = MimeTypesUtil.getContentType((String)dlFileEntry.getTitle());
        InputStream inputStream = DLFileEntryLocalServiceUtil.getFileAsStream((long)user.getCompanyId(), (long)user.getUserId(), (long)groupId, (long)folderId, (String)dlFileEntry.getName());
        response.setContentType(contentType);
        ServletResponseUtil.write((HttpServletResponse)response, (InputStream)inputStream);
    }

    protected void sendGroups(HttpServletResponse response, User user, String path) throws Exception {
        ArrayList<WebServerEntry> webServerEntries = new ArrayList<WebServerEntry>();
        List groups = WebDAVUtil.getGroups((User)user);
        for (Group group : groups) {
            String name = HttpUtil.fixPath((String)group.getFriendlyURL());
            webServerEntries.add(new WebServerEntry(path, String.valueOf(name) + "/", null, null, group.getDescription(), 0L));
        }
        this.sendHTML(response, path, webServerEntries);
    }

    protected void sendHTML(HttpServletResponse response, String path, List<WebServerEntry> webServerEntries) throws Exception {
        FreeMarkerContext freeMarkerContext = FreeMarkerEngineUtil.getWrappedRestrictedToolsContext();
        freeMarkerContext.put("dateFormat", (Object)_dateFormat);
        freeMarkerContext.put("entries", webServerEntries);
        freeMarkerContext.put("path", (Object)HttpUtil.encodePath((String)path));
        freeMarkerContext.put("serverInfo", (Object)ReleaseInfo.getServerInfo());
        freeMarkerContext.put("validator", (Object)Validator_IW.getInstance());
        String html = FreeMarkerUtil.process(_TPL_TEMPLATE, freeMarkerContext);
        response.setContentType("text/html; charset=UTF-8");
        ServletResponseUtil.write((HttpServletResponse)response, (String)html);
    }
}

