/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FileComparator;
import com.liferay.portal.kernel.util.JavaProps;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.PwdGenerator;
import com.liferay.util.SystemProperties;
import com.liferay.util.lucene.JerichoHTMLTextExtractor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.extractor.MsExcelTextExtractor;
import org.apache.jackrabbit.extractor.MsPowerPointTextExtractor;
import org.apache.jackrabbit.extractor.MsWordTextExtractor;
import org.apache.jackrabbit.extractor.OpenOfficeTextExtractor;
import org.apache.jackrabbit.extractor.PdfTextExtractor;
import org.apache.jackrabbit.extractor.PlainTextExtractor;
import org.apache.jackrabbit.extractor.RTFTextExtractor;
import org.apache.jackrabbit.extractor.TextExtractor;
import org.apache.jackrabbit.extractor.XMLTextExtractor;
import org.apache.poi.POITextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.mozilla.intl.chardet.nsDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImpl
implements File {
    private static final String[] _SAFE_FILE_NAME_1 = new String[]{"&", ")", "(", ";"};
    private static final String[] _SAFE_FILE_NAME_2 = new String[]{"_AMP_", "_CP_", "_OP_", "_SEM_"};
    private static Log _log = LogFactoryUtil.getLog(FileImpl.class);
    private static FileImpl _instance = new FileImpl();
    private Map<String, TextExtractor> _textExtractors = new HashMap<String, TextExtractor>();

    public static FileImpl getInstance() {
        return _instance;
    }

    public FileImpl() {
        Class[] textExtractorClasses;
        Class[] classArray = textExtractorClasses = new Class[]{JerichoHTMLTextExtractor.class, MsExcelTextExtractor.class, MsPowerPointTextExtractor.class, MsWordTextExtractor.class, OpenOfficeTextExtractor.class, PdfTextExtractor.class, PlainTextExtractor.class, RTFTextExtractor.class, XMLTextExtractor.class};
        int n = textExtractorClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class textExtractorClass = classArray[n2];
            try {
                String[] contentTypes;
                TextExtractor textExtractor = (TextExtractor)textExtractorClass.newInstance();
                String[] stringArray = contentTypes = textExtractor.getContentTypes();
                int n3 = contentTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String contentType = stringArray[n4];
                    this._textExtractors.put(contentType, textExtractor);
                    ++n4;
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            ++n2;
        }
    }

    public void copyDirectory(String sourceDirName, String destinationDirName) {
        this.copyDirectory(new java.io.File(sourceDirName), new java.io.File(destinationDirName));
    }

    public void copyDirectory(java.io.File source, java.io.File destination) {
        if (source.exists() && source.isDirectory()) {
            if (!destination.exists()) {
                destination.mkdirs();
            }
            java.io.File[] fileArray = source.listFiles();
            int i = 0;
            while (i < fileArray.length) {
                if (fileArray[i].isDirectory()) {
                    this.copyDirectory(fileArray[i], new java.io.File(String.valueOf(destination.getPath()) + java.io.File.separator + fileArray[i].getName()));
                } else {
                    this.copyFile(fileArray[i], new java.io.File(String.valueOf(destination.getPath()) + java.io.File.separator + fileArray[i].getName()));
                }
                ++i;
            }
        }
    }

    public void copyFile(String source, String destination) {
        this.copyFile(source, destination, false);
    }

    public void copyFile(String source, String destination, boolean lazy) {
        this.copyFile(new java.io.File(source), new java.io.File(destination), lazy);
    }

    public void copyFile(java.io.File source, java.io.File destination) {
        this.copyFile(source, destination, false);
    }

    public void copyFile(java.io.File source, java.io.File destination, boolean lazy) {
        if (!source.exists()) {
            return;
        }
        if (lazy) {
            String oldContent = null;
            try {
                oldContent = this.read(source);
            }
            catch (Exception exception) {
                return;
            }
            String newContent = null;
            try {
                newContent = this.read(destination);
            }
            catch (Exception exception) {}
            if (oldContent == null || !oldContent.equals(newContent)) {
                this.copyFile(source, destination, false);
            }
        } else {
            if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            try {
                StreamUtil.transfer((InputStream)new FileInputStream(source), (OutputStream)new FileOutputStream(destination));
            }
            catch (IOException ioe) {
                _log.error((Object)ioe.getMessage());
            }
        }
    }

    public java.io.File createTempFile() {
        return this.createTempFile(null);
    }

    public java.io.File createTempFile(String extension) {
        return new java.io.File(this.createTempFileName(extension));
    }

    public String createTempFileName() {
        return this.createTempFileName(null);
    }

    public String createTempFileName(String extension) {
        StringBundler sb = new StringBundler();
        sb.append(SystemProperties.get((String)"java.io.tmpdir"));
        sb.append("/");
        sb.append(Time.getTimestamp());
        sb.append(PwdGenerator.getPassword((String)PwdGenerator.KEY2, (int)8));
        if (Validator.isNotNull((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    public String decodeSafeFileName(String fileName) {
        return StringUtil.replace((String)fileName, (String[])_SAFE_FILE_NAME_2, (String[])_SAFE_FILE_NAME_1);
    }

    public boolean delete(String file) {
        return this.delete(new java.io.File(file));
    }

    public boolean delete(java.io.File file) {
        if (file != null && file.exists()) {
            return file.delete();
        }
        return false;
    }

    public void deltree(String directory) {
        this.deltree(new java.io.File(directory));
    }

    public void deltree(java.io.File directory) {
        if (directory.exists() && directory.isDirectory()) {
            java.io.File[] fileArray = directory.listFiles();
            int i = 0;
            while (i < fileArray.length) {
                if (fileArray[i].isDirectory()) {
                    this.deltree(fileArray[i]);
                } else {
                    fileArray[i].delete();
                }
                ++i;
            }
            directory.delete();
        }
    }

    public String encodeSafeFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        return StringUtil.replace((String)fileName, (String[])_SAFE_FILE_NAME_1, (String[])_SAFE_FILE_NAME_2);
    }

    public boolean exists(String fileName) {
        return this.exists(new java.io.File(fileName));
    }

    public boolean exists(java.io.File file) {
        return file.exists();
    }

    public String extractText(InputStream is, String fileName) {
        String text;
        block25: {
            text = null;
            try {
                TextExtractor textExtractor;
                if (!is.markSupported()) {
                    is = new BufferedInputStream(is);
                }
                String contentType = MimeTypesUtil.getContentType((InputStream)is, (String)fileName);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Attempting to extract text from " + fileName + " of type " + contentType));
                }
                if ((textExtractor = this._textExtractors.get(contentType)) != null) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Using text extractor " + textExtractor.getClass().getName()));
                    }
                    StringBuilder sb = new StringBuilder();
                    Reader reader = null;
                    if (ServerDetector.isJOnAS() && JavaProps.isJDK6() && contentType.equals("application/msword")) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)"JOnAS 5 with JDK 6 has a known issue with text extraction of Word documents. Use JDK 5 if you require indexing of Word documents.");
                        }
                        reader = _log.isDebugEnabled() ? textExtractor.extractText(is, contentType, null) : new StringReader("");
                    } else {
                        reader = textExtractor.extractText(is, contentType, null);
                    }
                    try {
                        char[] buffer = new char[1024];
                        int result = -1;
                        while ((result = reader.read(buffer)) != -1) {
                            sb.append(buffer, 0, result);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    text = sb.toString();
                    break block25;
                }
                if (contentType.equals("application/zip") || contentType.startsWith("application/vnd.openxmlformats-officedocument.")) {
                    try {
                        POITextExtractor poiTextExtractor = ExtractorFactory.createExtractor((InputStream)is);
                        text = poiTextExtractor.getText();
                    }
                    catch (Exception e) {
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)e.getMessage());
                        }
                    }
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (_log.isInfoEnabled()) {
            if (text == null) {
                _log.info((Object)("No text extractor found for " + fileName));
            } else {
                _log.info((Object)("Text was extracted for " + fileName));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Extractor returned text:\n\n" + text));
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    public String getAbsolutePath(java.io.File file) {
        return StringUtil.replace((String)file.getAbsolutePath(), (String)"\\", (String)"/");
    }

    public byte[] getBytes(java.io.File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] bytes = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(bytes);
        randomAccessFile.close();
        return bytes;
    }

    public byte[] getBytes(InputStream is) throws IOException {
        return this.getBytes(is, -1);
    }

    public byte[] getBytes(InputStream inputStream, int bufferSize) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream, (int)bufferSize);
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(".");
        if (pos > 0) {
            return fileName.substring(pos + 1, fileName.length()).toLowerCase();
        }
        return "";
    }

    public String getPath(String fullFileName) {
        String shortFileName;
        int pos = fullFileName.lastIndexOf("/");
        if (pos == -1) {
            pos = fullFileName.lastIndexOf("\\");
        }
        if (Validator.isNull((String)(shortFileName = fullFileName.substring(0, pos)))) {
            return "/";
        }
        return shortFileName;
    }

    public String getShortFileName(String fullFileName) {
        int pos = fullFileName.lastIndexOf("/");
        if (pos == -1) {
            pos = fullFileName.lastIndexOf("\\");
        }
        String shortFileName = fullFileName.substring(pos + 1, fullFileName.length());
        return shortFileName;
    }

    public boolean isAscii(java.io.File file) throws IOException {
        boolean ascii = true;
        nsDetector detector = new nsDetector(0);
        FileInputStream inputStream = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = ((InputStream)inputStream).read(buffer, 0, buffer.length)) != -1) {
            if (ascii && !(ascii = detector.isAscii(buffer, len))) break;
        }
        detector.DataEnd();
        ((InputStream)inputStream).close();
        return ascii;
    }

    public String[] listDirs(String fileName) {
        return this.listDirs(new java.io.File(fileName));
    }

    public String[] listDirs(java.io.File file) {
        ArrayList<String> dirs = new ArrayList<String>();
        java.io.File[] fileArray = file.listFiles();
        int i = 0;
        while (fileArray != null && i < fileArray.length) {
            if (fileArray[i].isDirectory()) {
                dirs.add(fileArray[i].getName());
            }
            ++i;
        }
        return dirs.toArray(new String[dirs.size()]);
    }

    public String[] listFiles(String fileName) {
        if (Validator.isNull((String)fileName)) {
            return new String[0];
        }
        return this.listFiles(new java.io.File(fileName));
    }

    public String[] listFiles(java.io.File file) {
        ArrayList<String> files = new ArrayList<String>();
        java.io.File[] fileArray = file.listFiles();
        int i = 0;
        while (fileArray != null && i < fileArray.length) {
            if (fileArray[i].isFile()) {
                files.add(fileArray[i].getName());
            }
            ++i;
        }
        return files.toArray(new String[files.size()]);
    }

    public void mkdirs(String pathName) {
        java.io.File file = new java.io.File(pathName);
        file.mkdirs();
    }

    public boolean move(String sourceFileName, String destinationFileName) {
        return this.move(new java.io.File(sourceFileName), new java.io.File(destinationFileName));
    }

    public boolean move(java.io.File source, java.io.File destination) {
        if (!source.exists()) {
            return false;
        }
        destination.delete();
        return source.renameTo(destination);
    }

    public String read(String fileName) throws IOException {
        return this.read(new java.io.File(fileName));
    }

    public String read(java.io.File file) throws IOException {
        return this.read(file, false);
    }

    public String read(java.io.File file, boolean raw) throws IOException {
        byte[] bytes = this.getBytes(file);
        if (bytes == null) {
            return null;
        }
        String s = new String(bytes, "UTF-8");
        if (raw) {
            return s;
        }
        return StringUtil.replace((String)s, (String)"\r\n", (String)"\n");
    }

    public String replaceSeparator(String fileName) {
        return StringUtil.replace((String)fileName, (String)"\\", (String)"/");
    }

    public java.io.File[] sortFiles(java.io.File[] files) {
        if (files == null) {
            return null;
        }
        Arrays.sort(files, new FileComparator());
        ArrayList<java.io.File> directoryList = new ArrayList<java.io.File>();
        ArrayList<java.io.File> fileList = new ArrayList<java.io.File>();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                directoryList.add(files[i]);
            } else {
                fileList.add(files[i]);
            }
            ++i;
        }
        directoryList.addAll(fileList);
        return directoryList.toArray(new java.io.File[directoryList.size()]);
    }

    public String stripExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String ext = this.getExtension(fileName);
        if (ext.length() > 0) {
            return fileName.substring(0, fileName.length() - ext.length() - 1);
        }
        return fileName;
    }

    public List<String> toList(Reader reader) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                list.add(line);
            }
            unsyncBufferedReader.close();
        }
        catch (IOException iOException) {}
        return list;
    }

    public List<String> toList(String fileName) {
        try {
            return this.toList(new FileReader(fileName));
        }
        catch (IOException iOException) {
            return new ArrayList<String>();
        }
    }

    public Properties toProperties(FileInputStream fis) {
        Properties props = new Properties();
        try {
            props.load(fis);
        }
        catch (IOException iOException) {}
        return props;
    }

    public Properties toProperties(String fileName) {
        try {
            return this.toProperties(new FileInputStream(fileName));
        }
        catch (IOException iOException) {
            return new Properties();
        }
    }

    public void write(String fileName, String s) throws IOException {
        this.write(new java.io.File(fileName), s);
    }

    public void write(String fileName, String s, boolean lazy) throws IOException {
        this.write(new java.io.File(fileName), s, lazy);
    }

    public void write(String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new java.io.File(fileName), s, lazy, append);
    }

    public void write(String pathName, String fileName, String s) throws IOException {
        this.write(new java.io.File(pathName, fileName), s);
    }

    public void write(String pathName, String fileName, String s, boolean lazy) throws IOException {
        this.write(new java.io.File(pathName, fileName), s, lazy);
    }

    public void write(String pathName, String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new java.io.File(pathName, fileName), s, lazy, append);
    }

    public void write(java.io.File file, String s) throws IOException {
        this.write(file, s, false);
    }

    public void write(java.io.File file, String s, boolean lazy) throws IOException {
        this.write(file, s, lazy, false);
    }

    public void write(java.io.File file, String s, boolean lazy, boolean append) throws IOException {
        String content;
        if (file.getParent() != null) {
            this.mkdirs(file.getParent());
        }
        if (lazy && file.exists() && (content = this.read(file)).equals(s)) {
            return;
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), "UTF-8");
        writer.write(s);
        ((Writer)writer).close();
    }

    public void write(String fileName, byte[] bytes) throws IOException {
        this.write(new java.io.File(fileName), bytes);
    }

    public void write(java.io.File file, byte[] bytes) throws IOException {
        this.write(file, bytes, 0, bytes.length);
    }

    public void write(java.io.File file, byte[] bytes, int offset, int length) throws IOException {
        if (file.getParent() != null) {
            this.mkdirs(file.getParent());
        }
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(bytes, offset, length);
        fos.close();
    }

    public void write(String fileName, InputStream is) throws IOException {
        this.write(new java.io.File(fileName), is);
    }

    public void write(java.io.File file, InputStream is) throws IOException {
        if (file.getParent() != null) {
            this.mkdirs(file.getParent());
        }
        StreamUtil.transfer((InputStream)is, (OutputStream)new FileOutputStream(file));
    }
}

