/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v4_4_0.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.StagnantRowException;
import com.liferay.portal.kernel.upgrade.util.BaseUpgradeColumnImpl;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageResourceLocalServiceUtil;

public class TagsAssetGroupIdUpgradeColumnImpl
extends BaseUpgradeColumnImpl {
    private static Log _log = LogFactoryUtil.getLog(TagsAssetGroupIdUpgradeColumnImpl.class);
    private UpgradeColumn _classNameIdColumn;
    private UpgradeColumn _classPKColumn;

    public TagsAssetGroupIdUpgradeColumnImpl(UpgradeColumn classNameIdColumn, UpgradeColumn classPKColumn) {
        super("groupId");
        this._classNameIdColumn = classNameIdColumn;
        this._classPKColumn = classPKColumn;
    }

    public Object getNewValue(Object oldValue) throws Exception {
        Long newGroupId;
        block4: {
            Long oldGroupId;
            newGroupId = oldGroupId = (Long)oldValue;
            if (oldGroupId == 0L) {
                Long classNameId = (Long)this._classNameIdColumn.getOldValue();
                Long classPK = (Long)this._classPKColumn.getOldValue();
                String className = PortalUtil.getClassName((long)classNameId);
                try {
                    newGroupId = new Long(this.getGroupId(className, classPK));
                }
                catch (PortalException pe) {
                    throw new StagnantRowException(pe.getMessage(), (Throwable)pe);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
        }
        return newGroupId;
    }

    protected long getGroupId(String className, long classPK) throws Exception {
        if (className.equals(BlogsEntry.class.getName())) {
            BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)classPK);
            return entry.getGroupId();
        }
        if (className.equals(BookmarksEntry.class.getName())) {
            BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
            return entry.getFolder().getGroupId();
        }
        if (className.equals(DLFileEntry.class.getName())) {
            DLFileEntry fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)classPK);
            return fileEntry.getFolder().getGroupId();
        }
        if (className.equals(IGImage.class.getName())) {
            IGImage image = IGImageLocalServiceUtil.getImage((long)classPK);
            return image.getFolder().getGroupId();
        }
        if (className.equals(JournalArticle.class.getName())) {
            JournalArticleResource articleResource = JournalArticleResourceLocalServiceUtil.getArticleResource((long)classPK);
            return articleResource.getGroupId();
        }
        if (className.equals(MBMessage.class.getName())) {
            MBMessage message = MBMessageLocalServiceUtil.getMessage((long)classPK);
            return message.getCategory().getGroupId();
        }
        if (className.equals(WikiPage.class.getName())) {
            WikiPageResource pageResource = WikiPageResourceLocalServiceUtil.getPageResource((long)classPK);
            WikiNode node = WikiNodeLocalServiceUtil.getNode((long)pageResource.getNodeId());
            return node.getGroupId();
        }
        return 0L;
    }
}

