/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v4_3_0.util;

import com.liferay.documentlibrary.service.DLLocalServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.ValueMapper;
import com.liferay.portal.kernel.upgrade.util.ValueMapperFactoryUtil;
import com.liferay.portal.upgrade.util.PKUpgradeColumnImpl;
import java.util.HashSet;
import java.util.Set;

public class DLFileEntryIdUpgradeColumnImpl
extends PKUpgradeColumnImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryIdUpgradeColumnImpl.class);
    private UpgradeColumn _companyIdColumn;
    private UpgradeColumn _folderIdColumn;
    private UpgradeColumn _nameColumn;
    private ValueMapper _dlFileEntryIdMapper;
    private Set<Long> _movedFolderIds;

    public DLFileEntryIdUpgradeColumnImpl(UpgradeColumn companyIdColumn, UpgradeColumn folderIdColumn, UpgradeColumn nameColumn) {
        super("fileEntryId", false);
        this._companyIdColumn = companyIdColumn;
        this._folderIdColumn = folderIdColumn;
        this._nameColumn = nameColumn;
        this._dlFileEntryIdMapper = ValueMapperFactoryUtil.getValueMapper();
        this._movedFolderIds = new HashSet<Long>();
    }

    public Object getNewValue(Object oldValue) throws Exception {
        Object newValue = super.getNewValue(oldValue);
        String oldCompanyId = (String)this._companyIdColumn.getOldValue();
        Long oldFolderId = (Long)this._folderIdColumn.getOldValue();
        Long newCompanyId = (Long)this._companyIdColumn.getNewValue();
        Long newFolderId = (Long)this._folderIdColumn.getNewValue();
        String name = (String)this._nameColumn.getOldValue();
        String oldPageIdValue = "{folderId=" + oldFolderId + ", name=" + name + "}";
        this._dlFileEntryIdMapper.mapValue((Object)oldPageIdValue, newValue);
        if (!this._movedFolderIds.contains(oldFolderId)) {
            try {
                DLLocalServiceUtil.move((String)("/" + oldCompanyId + "/documentlibrary/" + oldFolderId), (String)("/" + newCompanyId + "/documentlibrary/" + newFolderId));
            }
            catch (Exception e) {
                _log.error((Object)e.getMessage());
            }
            this._movedFolderIds.add(oldFolderId);
        }
        return newValue;
    }

    public ValueMapper getValueMapper() {
        return this._dlFileEntryIdMapper;
    }
}

