/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.annotation.Transactional;
import com.liferay.portal.kernel.util.MethodTargetClassKey;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTransactionAttributeSource
implements TransactionAttributeSource {
    private static TransactionAttribute _nullTransactionAttribute = new DefaultTransactionAttribute();
    private Map<MethodTargetClassKey, TransactionAttribute> _transactionAttributes = new ConcurrentHashMap<MethodTargetClassKey, TransactionAttribute>();

    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        MethodTargetClassKey methodTargetClassKey = new MethodTargetClassKey(method, targetClass);
        TransactionAttribute transactionAttribute = this._transactionAttributes.get(methodTargetClassKey);
        if (transactionAttribute != null) {
            if (transactionAttribute == _nullTransactionAttribute) {
                return null;
            }
            return transactionAttribute;
        }
        LinkedList candidateQueue = new LinkedList();
        if (targetClass == null) {
            candidateQueue.offer(method.getDeclaringClass());
        } else {
            candidateQueue.offer(targetClass);
        }
        Transactional transactional = this._findTransactionAnnotation(method, candidateQueue);
        transactionAttribute = this._parseTransactionAnnotation(transactional);
        if (transactionAttribute == null) {
            this._transactionAttributes.put(methodTargetClassKey, _nullTransactionAttribute);
        } else {
            this._transactionAttributes.put(methodTargetClassKey, transactionAttribute);
        }
        return transactionAttribute;
    }

    private Transactional _findTransactionAnnotation(Method method, Queue<Class<?>> candidateQueue) {
        if (candidateQueue.isEmpty()) {
            return null;
        }
        Transactional transactional = null;
        Class<?> clazz = candidateQueue.poll();
        try {
            Method specificMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
            transactional = specificMethod.getAnnotation(Transactional.class);
            if (transactional != null) {
                return transactional;
            }
        }
        catch (Exception exception) {}
        transactional = clazz.getAnnotation(Transactional.class);
        if (transactional != null) {
            return transactional;
        }
        this._queueSuperTypes(clazz, candidateQueue);
        return this._findTransactionAnnotation(method, candidateQueue);
    }

    private TransactionAttribute _parseTransactionAnnotation(Transactional transactional) {
        if (transactional == null) {
            return null;
        }
        RuleBasedTransactionAttribute ruleBasedTransactionAttribute = new RuleBasedTransactionAttribute();
        int isolationLevel = transactional.isolation().value();
        if (isolationLevel == -2) {
            ruleBasedTransactionAttribute.setIsolationLevel(PropsValues.TRANSACTION_ISOLATION_PORTAL);
        } else {
            ruleBasedTransactionAttribute.setIsolationLevel(isolationLevel);
        }
        ruleBasedTransactionAttribute.setPropagationBehavior(transactional.propagation().value());
        ruleBasedTransactionAttribute.setReadOnly(transactional.readOnly());
        ruleBasedTransactionAttribute.setTimeout(transactional.timeout());
        ArrayList<Object> rollBackAttributes = new ArrayList<Object>();
        Class[] rollbackFor = transactional.rollbackFor();
        int i = 0;
        while (i < rollbackFor.length) {
            RollbackRuleAttribute rollbackRuleAttribute = new RollbackRuleAttribute(rollbackFor[i]);
            rollBackAttributes.add(rollbackRuleAttribute);
            ++i;
        }
        String[] rollbackForClassName = transactional.rollbackForClassName();
        int i2 = 0;
        while (i2 < rollbackForClassName.length) {
            RollbackRuleAttribute rollbackRuleAttribute = new RollbackRuleAttribute(rollbackForClassName[i2]);
            rollBackAttributes.add(rollbackRuleAttribute);
            ++i2;
        }
        Class[] noRollbackFor = transactional.noRollbackFor();
        int i3 = 0;
        while (i3 < noRollbackFor.length) {
            NoRollbackRuleAttribute noRollbackRuleAttribute = new NoRollbackRuleAttribute(noRollbackFor[i3]);
            rollBackAttributes.add(noRollbackRuleAttribute);
            ++i3;
        }
        String[] noRollbackForClassName = transactional.noRollbackForClassName();
        int i4 = 0;
        while (i4 < noRollbackForClassName.length) {
            NoRollbackRuleAttribute noRollbackRuleAttribute = new NoRollbackRuleAttribute(noRollbackForClassName[i4]);
            rollBackAttributes.add(noRollbackRuleAttribute);
            ++i4;
        }
        ruleBasedTransactionAttribute.getRollbackRules().addAll(rollBackAttributes);
        return ruleBasedTransactionAttribute;
    }

    private void _queueSuperTypes(Class<?> clazz, Queue<Class<?>> candidateQueue) {
        Class<?>[] interfaces;
        Class<?> supperClass = clazz.getSuperclass();
        if (supperClass != null && supperClass != Object.class) {
            candidateQueue.offer(supperClass);
        }
        Class<?>[] classArray = interfaces = clazz.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inter = classArray[n2];
            candidateQueue.offer(inter);
            ++n2;
        }
    }
}

