/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.spring.util.FilterClassLoader;
import java.io.FileNotFoundException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class PortletApplicationContext
extends XmlWebApplicationContext {
    private static Log _log = LogFactoryUtil.getLog(PortletApplicationContext.class);

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader) {
        ClassLoader beanClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader[])new ClassLoader[]{PortletClassLoaderUtil.getClassLoader(), PortalClassLoaderUtil.getClassLoader()});
        beanClassLoader = new FilterClassLoader(beanClassLoader);
        reader.setBeanClassLoader(beanClassLoader);
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) {
        String[] configLocations = this.getPortletConfigLocations();
        if (configLocations == null) {
            return;
        }
        String[] stringArray = configLocations;
        int n = configLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String configLocation = stringArray[n2];
            try {
                reader.loadBeanDefinitions(configLocation);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof FileNotFoundException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)cause.getMessage());
                    }
                }
                _log.error((Object)e, (Throwable)e);
            }
            ++n2;
        }
    }

    protected String[] getPortletConfigLocations() {
        Object[] configLocations = this.getConfigLocations();
        ClassLoader classLoader = PortletClassLoaderUtil.getClassLoader();
        Configuration serviceBuilderPropertiesConfiguration = null;
        try {
            serviceBuilderPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"service");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read service.properties");
            }
            return configLocations;
        }
        return (String[])ArrayUtil.append((Object[])configLocations, (Object[])serviceBuilderPropertiesConfiguration.getArray("spring.configs"));
    }
}

