/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.virtualhost;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.servlet.AbsoluteRedirectsResponse;
import com.liferay.portal.servlet.I18nServlet;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class VirtualHostFilter
extends BasePortalFilter {
    private static final String _PATH_C = "/c/";
    private static final String _PATH_COMBO = "/combo/";
    private static final String _PATH_DELEGATE = "/delegate/";
    private static final String _PATH_DISPLAY_CHART = "/display_chart";
    private static final String _PATH_DOCUMENTS = "/documents/";
    private static final String _PATH_DTD = "/dtd/";
    private static final String _PATH_FACEBOOK = "/facebook/";
    private static final String _PATH_GOOGLE_GADGET = "/google_gadget/";
    private static final String _PATH_HTML = "/html/";
    private static final String _PATH_IMAGE = "/image/";
    private static final String _PATH_LANGUAGE = "/language/";
    private static final String _PATH_NETVIBES = "/netvibes/";
    private static final String _PATH_PBHS = "/pbhs/";
    private static final String _PATH_POLLER = "/poller/";
    private static final String _PATH_SHAREPOINT = "/sharepoint/";
    private static final String _PATH_SITEMAP_XML = "/sitemap.xml";
    private static final String _PATH_SOFTWARE_CATALOG = "/software_catalog";
    private static final String _PATH_VTI = "/_vti_";
    private static final String _PATH_WAP = "/wap/";
    private static final String _PATH_WIDGET = "/widget/";
    private static final String _PATH_XMLRPC = "/xmlrpc/";
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
    private static final String _PRIVATE_USER_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
    private static Log _log = LogFactoryUtil.getLog(VirtualHostFilter.class);
    private ServletContext _servletContext;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
    }

    protected boolean isValidFriendlyURL(String friendlyURL) {
        if (PortalInstances.isVirtualHostsIgnorePath(friendlyURL = friendlyURL.toLowerCase()) || friendlyURL.startsWith(String.valueOf(_PRIVATE_GROUP_SERVLET_MAPPING) + "/") || friendlyURL.startsWith(String.valueOf(_PUBLIC_GROUP_SERVLET_MAPPING) + "/") || friendlyURL.startsWith(String.valueOf(_PRIVATE_USER_SERVLET_MAPPING) + "/") || friendlyURL.startsWith(_PATH_C) || friendlyURL.startsWith(_PATH_COMBO) || friendlyURL.startsWith(_PATH_DELEGATE) || friendlyURL.startsWith(_PATH_DISPLAY_CHART) || friendlyURL.startsWith(_PATH_DOCUMENTS) || friendlyURL.startsWith(_PATH_DTD) || friendlyURL.startsWith(_PATH_FACEBOOK) || friendlyURL.startsWith(_PATH_GOOGLE_GADGET) || friendlyURL.startsWith(_PATH_HTML) || friendlyURL.startsWith(_PATH_IMAGE) || friendlyURL.startsWith(_PATH_LANGUAGE) || friendlyURL.startsWith(_PATH_NETVIBES) || friendlyURL.startsWith(_PATH_PBHS) || friendlyURL.startsWith(_PATH_POLLER) || friendlyURL.startsWith(_PATH_SHAREPOINT) || friendlyURL.startsWith(_PATH_SITEMAP_XML) || friendlyURL.startsWith(_PATH_SOFTWARE_CATALOG) || friendlyURL.startsWith(_PATH_VTI) || friendlyURL.startsWith(_PATH_WAP) || friendlyURL.startsWith(_PATH_WIDGET) || friendlyURL.startsWith(_PATH_XMLRPC)) {
            return false;
        }
        int code = LayoutImpl.validateFriendlyURL(friendlyURL);
        return code <= -1 || code == 2;
    }

    protected boolean isValidRequestURL(StringBuffer requestURL) {
        if (requestURL == null) {
            return false;
        }
        String url = requestURL.toString();
        String[] stringArray = PropsValues.VIRTUAL_HOSTS_IGNORE_EXTENSIONS;
        int n = PropsValues.VIRTUAL_HOSTS_IGNORE_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (url.endsWith(extension)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        request.setCharacterEncoding("UTF-8");
        response = new AbsoluteRedirectsResponse(request, (HttpServletResponse)response);
        long companyId = PortalInstances.getCompanyId(request);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Company id " + companyId));
        }
        PortalUtil.getCurrentCompleteURL((HttpServletRequest)request);
        PortalUtil.getCurrentURL((HttpServletRequest)request);
        HttpSession session = request.getSession();
        Boolean httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL");
        if (httpsInitial == null) {
            httpsInitial = request.isSecure();
            session.setAttribute("HTTPS_INITIAL", (Object)httpsInitial);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Setting httpsInitial to " + httpsInitial));
            }
        }
        if (!this.isFilterEnabled()) {
            this.processFilter(VirtualHostFilter.class, request, (HttpServletResponse)response, filterChain);
            return;
        }
        StringBuffer requestURL = request.getRequestURL();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Received " + requestURL));
        }
        if (!this.isValidRequestURL(requestURL)) {
            this.processFilter(VirtualHostFilter.class, request, (HttpServletResponse)response, filterChain);
            return;
        }
        String contextPath = PortalUtil.getPathContext();
        String friendlyURL = request.getRequestURI();
        if (Validator.isNotNull((String)contextPath) && friendlyURL.indexOf(contextPath) != -1) {
            friendlyURL = friendlyURL.substring(contextPath.length());
        }
        friendlyURL = StringUtil.replace((String)friendlyURL, (String)"//", (String)"/");
        String i18nLanguageId = null;
        Set<String> languageIds = I18nServlet.getLanguageIds();
        for (String languageId : languageIds) {
            int pos;
            if (!friendlyURL.startsWith(languageId) || (pos = friendlyURL.indexOf(47, 1)) != -1 && pos != languageId.length() || pos == -1 && !friendlyURL.equals(languageId)) continue;
            if (pos == -1) {
                i18nLanguageId = friendlyURL;
                friendlyURL = "/";
                break;
            }
            i18nLanguageId = friendlyURL.substring(0, pos);
            friendlyURL = friendlyURL.substring(pos);
            break;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Friendly URL " + friendlyURL));
        }
        if (!friendlyURL.equals("/") && !this.isValidFriendlyURL(friendlyURL)) {
            _log.debug((Object)"Friendly URL is not valid");
            this.processFilter(VirtualHostFilter.class, request, (HttpServletResponse)response, filterChain);
            return;
        }
        LayoutSet layoutSet = (LayoutSet)request.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Layout set " + layoutSet));
        }
        if (layoutSet != null) {
            try {
                long plid;
                LastPath lastPath = new LastPath(contextPath, friendlyURL, request.getParameterMap());
                request.setAttribute("LAST_PATH", (Object)lastPath);
                StringBundler prefix = new StringBundler(2);
                Group group = GroupLocalServiceUtil.getGroup((long)layoutSet.getGroupId());
                if (layoutSet.isPrivateLayout()) {
                    if (group.isUser()) {
                        prefix.append(_PRIVATE_USER_SERVLET_MAPPING);
                    } else {
                        prefix.append(_PRIVATE_GROUP_SERVLET_MAPPING);
                    }
                } else {
                    prefix.append(_PUBLIC_GROUP_SERVLET_MAPPING);
                }
                prefix.append(group.getFriendlyURL());
                StringBundler forwardURL = new StringBundler(6);
                if (i18nLanguageId != null) {
                    forwardURL.append(i18nLanguageId);
                }
                if (friendlyURL.startsWith(PropsValues.WIDGET_SERVLET_MAPPING)) {
                    forwardURL.append(PropsValues.WIDGET_SERVLET_MAPPING);
                    friendlyURL = StringUtil.replaceFirst((String)friendlyURL, (String)PropsValues.WIDGET_SERVLET_MAPPING, (String)"");
                }
                if ((plid = PortalUtil.getPlidFromFriendlyURL((long)companyId, (String)friendlyURL)) <= 0L) {
                    forwardURL.append(prefix);
                }
                forwardURL.append(friendlyURL);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Forward to " + forwardURL));
                }
                RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher(forwardURL.toString());
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        this.processFilter(VirtualHostFilter.class, request, (HttpServletResponse)response, filterChain);
    }
}

