/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.SpriteProcessorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerType;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.EventDefinition;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletCategory;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletFilter;
import com.liferay.portal.model.PortletInfo;
import com.liferay.portal.model.PortletURLListener;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.impl.EventDefinitionImpl;
import com.liferay.portal.model.impl.PortletAppImpl;
import com.liferay.portal.model.impl.PortletFilterImpl;
import com.liferay.portal.model.impl.PortletImpl;
import com.liferay.portal.model.impl.PortletURLListenerImpl;
import com.liferay.portal.model.impl.PublicRenderParameterImpl;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.base.PortletLocalServiceBaseImpl;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletConfigFactoryUtil;
import com.liferay.portlet.PortletContextFactory;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletPreferencesSerializer;
import com.liferay.portlet.PortletQNameUtil;
import com.liferay.portlet.expando.model.CustomAttributesDisplay;
import com.liferay.util.bridges.mvc.MVCPortlet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletMode;
import javax.portlet.PreferencesValidator;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletLocalServiceImpl
extends PortletLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(PortletLocalServiceImpl.class);
    private static PortalCache _companyPortletsPool = MultiVMPoolUtil.getCache((String)Portlet.class.getName());
    private static Map<String, Portlet> _customAttributesDisplayPortlets = new ConcurrentHashMap<String, Portlet>();
    private static Map<String, Portlet> _friendlyURLMapperPortlets = new ConcurrentHashMap<String, Portlet>();
    private static String _keyPrefix = Portlet.class.getName().concat("#");
    private static Map<String, PortletApp> _portletAppsPool = new ConcurrentHashMap<String, PortletApp>();
    private static Map<String, String> _portletIdsByStrutsPath = new ConcurrentHashMap<String, String>();
    private static Map<String, Portlet> _portletsPool = new ConcurrentHashMap<String, Portlet>();

    public void checkPortlet(Portlet portlet) throws PortalException, SystemException {
        if (portlet.isSystem()) {
            return;
        }
        String[] roleNames = portlet.getRolesArray();
        if (roleNames.length == 0) {
            return;
        }
        long companyId = portlet.getCompanyId();
        String name = portlet.getPortletId();
        int scope = 1;
        String primKey = String.valueOf(companyId);
        String actionId = "ADD_TO_PAGE";
        List<String> actionIds = ResourceActionsUtil.getPortletResourceActions(name);
        if (actionIds.contains(actionId)) {
            String[] stringArray = roleNames;
            int n = roleNames.length;
            int n2 = 0;
            while (n2 < n) {
                String roleName = stringArray[n2];
                Role role = this.roleLocalService.getRole(companyId, roleName);
                if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                    this.resourcePermissionLocalService.addResourcePermission(companyId, name, scope, primKey, role.getRoleId(), actionId);
                } else {
                    this.permissionLocalService.setRolePermission(role.getRoleId(), companyId, name, scope, primKey, actionId);
                }
                ++n2;
            }
        }
        this.updatePortlet(companyId, portlet.getPortletId(), "", portlet.isActive());
    }

    public void checkPortlets(long companyId) throws PortalException, SystemException {
        List<Portlet> portlets = this.getPortlets(companyId);
        for (Portlet portlet : portlets) {
            this.checkPortlet(portlet);
        }
    }

    public void clearCache() {
        _portletIdsByStrutsPath.clear();
        _companyPortletsPool.removeAll();
    }

    public Portlet clonePortlet(long companyId, String portletId) throws SystemException {
        Portlet portlet = this.getPortletById(companyId, portletId);
        return (Portlet)portlet.clone();
    }

    public Portlet deployRemotePortlet(Portlet portlet, String categoryName) throws SystemException {
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        portletsPool.put(portlet.getPortletId(), portlet);
        PortletInstanceFactoryUtil.clear((Portlet)portlet, (boolean)false);
        PortletConfigFactoryUtil.destroy((Portlet)portlet);
        PortletContextFactory.destroy(portlet);
        this.clearCache();
        PortletCategory newPortletCategory = new PortletCategory();
        PortletCategory oldPortletCategory = new PortletCategory(categoryName);
        newPortletCategory.addCategory(oldPortletCategory);
        oldPortletCategory.getPortletIds().add(portlet.getPortletId());
        long companyId = portlet.getCompanyId();
        PortletCategory portletCategory = (PortletCategory)WebAppPool.get(String.valueOf(companyId), "PORTLET_CATEGORY");
        if (portletCategory != null) {
            portletCategory.merge(newPortletCategory);
        } else {
            _log.error((Object)("Unable to register remote portlet for company " + companyId + " because it does not exist"));
        }
        List<String> portletActions = ResourceActionsUtil.getPortletResourceActions(portlet.getPortletId());
        this.resourceActionLocalService.checkResourceActions(portlet.getPortletId(), portletActions);
        return portlet;
    }

    public void destroyPortlet(Portlet portlet) {
        String portletId = portlet.getRootPortletId();
        _friendlyURLMapperPortlets.remove(portletId);
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        portletsPool.remove(portletId);
        PortletApp portletApp = portlet.getPortletApp();
        if (portletApp != null) {
            _portletAppsPool.remove(portletApp.getServletContextName());
        }
        this.clearCache();
    }

    public void destroyRemotePortlet(Portlet portlet) {
        this.destroyPortlet(portlet);
    }

    public List<CustomAttributesDisplay> getCustomAttributesDisplays() {
        ArrayList<CustomAttributesDisplay> customAttributesDisplays = new ArrayList<CustomAttributesDisplay>(_customAttributesDisplayPortlets.size());
        for (Map.Entry<String, Portlet> entry : _customAttributesDisplayPortlets.entrySet()) {
            Portlet portlet = entry.getValue();
            List portletCustomAttributesDisplays = portlet.getCustomAttributesDisplayInstances();
            if (portletCustomAttributesDisplays == null || portletCustomAttributesDisplays.isEmpty()) continue;
            customAttributesDisplays.addAll(portletCustomAttributesDisplays);
        }
        return customAttributesDisplays;
    }

    public PortletCategory getEARDisplay(String xml) throws SystemException {
        try {
            return this._readLiferayDisplayXML(xml);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public List<Portlet> getFriendlyURLMapperPortlets() {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>(_friendlyURLMapperPortlets.size());
        for (Map.Entry<String, Portlet> entry : _friendlyURLMapperPortlets.entrySet()) {
            Portlet portlet = entry.getValue();
            FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
            if (friendlyURLMapper == null) continue;
            portlets.add(portlet);
        }
        return portlets;
    }

    public List<FriendlyURLMapper> getFriendlyURLMappers() {
        ArrayList<FriendlyURLMapper> friendlyURLMappers = new ArrayList<FriendlyURLMapper>(_friendlyURLMapperPortlets.size());
        for (Map.Entry<String, Portlet> entry : _friendlyURLMapperPortlets.entrySet()) {
            Portlet portlet = entry.getValue();
            FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
            if (friendlyURLMapper == null) continue;
            friendlyURLMappers.add(friendlyURLMapper);
        }
        return friendlyURLMappers;
    }

    public PortletApp getPortletApp(String servletContextName) {
        return this._getPortletApp(servletContextName);
    }

    public Portlet getPortletById(long companyId, String portletId) throws SystemException {
        portletId = PortalUtil.getJsSafePortletId((String)portletId);
        Portlet portlet = null;
        Map<String, Portlet> companyPortletsPool = this._getPortletsPool(companyId);
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        if (portletId.equals(rootPortletId)) {
            portlet = companyPortletsPool.get(portletId);
        } else {
            portlet = companyPortletsPool.get(rootPortletId);
            if (portlet != null) {
                portlet = portlet.getClonedInstance(portletId);
            }
        }
        if (portlet != null) {
            return portlet;
        }
        if (portletId.equals("LIFERAY_PORTAL")) {
            return portlet;
        }
        if (_portletsPool.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"No portlets are installed");
            }
        } else {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Portlet not found for " + companyId + " " + portletId));
            }
            portlet = new PortletImpl(0L, portletId);
            portlet.setTimestamp(System.currentTimeMillis());
            PortletApp portletApp = this._getPortletApp("");
            portlet.setPortletApp(portletApp);
            portlet.setPortletName(portletId);
            portlet.setDisplayName(portletId);
            portlet.setPortletClass(MVCPortlet.class.getName());
            Map initParams = portlet.getInitParams();
            initParams.put("view-jsp", "/html/portal/undeployed_portlet.jsp");
            HashSet<String> mimeTypePortletModes = new HashSet<String>();
            mimeTypePortletModes.add(PortletMode.VIEW.toString().toLowerCase());
            Map portletModes = portlet.getPortletModes();
            portletModes.put("text/html", mimeTypePortletModes);
            HashSet<String> mimeTypeWindowStates = new HashSet<String>();
            mimeTypeWindowStates.add(WindowState.NORMAL.toString().toLowerCase());
            Map windowStates = portlet.getWindowStates();
            windowStates.put("text/html", mimeTypeWindowStates);
            portlet.setPortletInfo(new PortletInfo(portletId, portletId, portletId, portletId));
            if (PortletConstants.getInstanceId((String)portletId) != null) {
                portlet.setInstanceable(true);
            }
            portlet.setActive(true);
            portlet.setUndeployedPortlet(true);
        }
        return portlet;
    }

    public Portlet getPortletById(String portletId) {
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        return portletsPool.get(portletId);
    }

    public Portlet getPortletByStrutsPath(long companyId, String strutsPath) throws SystemException {
        return this.getPortletById(companyId, this._getPortletId(strutsPath));
    }

    public List<Portlet> getPortlets() {
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        return ListUtil.fromCollection(portletsPool.values());
    }

    public List<Portlet> getPortlets(long companyId) throws SystemException {
        return this.getPortlets(companyId, true, true);
    }

    public List<Portlet> getPortlets(long companyId, boolean showSystem, boolean showPortal) throws SystemException {
        Map<String, Portlet> portletsPool = this._getPortletsPool(companyId);
        List portlets = ListUtil.fromCollection(portletsPool.values());
        if (!showSystem || !showPortal) {
            Iterator itr = portlets.iterator();
            while (itr.hasNext()) {
                Portlet portlet = (Portlet)itr.next();
                if (showPortal && portlet.getPortletId().equals("90")) continue;
                if (!showPortal && portlet.getPortletId().equals("90")) {
                    itr.remove();
                    continue;
                }
                if (showSystem || !portlet.isSystem()) continue;
                itr.remove();
            }
        }
        return portlets;
    }

    public PortletCategory getWARDisplay(String servletContextName, String xml) throws SystemException {
        try {
            return this._readLiferayDisplayXML(servletContextName, xml);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public boolean hasPortlet(long companyId, String portletId) throws SystemException {
        portletId = PortalUtil.getJsSafePortletId((String)portletId);
        Portlet portlet = null;
        Map<String, Portlet> companyPortletsPool = this._getPortletsPool(companyId);
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        portlet = portletId.equals(rootPortletId) ? companyPortletsPool.get(portletId) : companyPortletsPool.get(rootPortletId);
        return portlet != null;
    }

    public void initEAR(ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        _portletAppsPool.clear();
        _portletsPool.clear();
        _companyPortletsPool.removeAll();
        _portletIdsByStrutsPath.clear();
        _friendlyURLMapperPortlets.clear();
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        try {
            Set<String> servletURLPatterns = this._readWebXML(xmls[4]);
            Set<String> portletIds = this._readPortletXML(servletContext, xmls[0], portletsPool, servletURLPatterns, pluginPackage);
            portletIds.addAll(this._readPortletXML(servletContext, xmls[1], portletsPool, servletURLPatterns, pluginPackage));
            Set<String> liferayPortletIds = this._readLiferayPortletXML(xmls[2], portletsPool);
            liferayPortletIds.addAll(this._readLiferayPortletXML(xmls[3], portletsPool));
            for (String portletId : portletIds) {
                if (!_log.isWarnEnabled() || liferayPortletIds.contains(portletId)) continue;
                _log.warn((Object)("Portlet with the name " + portletId + " is described in portlet.xml but does not " + "have a matching entry in liferay-portlet.xml"));
            }
            for (String portletId : liferayPortletIds) {
                if (!_log.isWarnEnabled() || portletIds.contains(portletId)) continue;
                _log.warn((Object)("Portlet with the name " + portletId + " is described in liferay-portlet.xml but does " + "not have a matching entry in portlet.xml"));
            }
            Iterator<Map.Entry<String, Portlet>> portletPoolsItr = portletsPool.entrySet().iterator();
            while (portletPoolsItr.hasNext()) {
                Map.Entry<String, Portlet> entry = portletPoolsItr.next();
                Portlet portletModel = entry.getValue();
                if (portletModel.getPortletId().equals("9") || portletModel.getPortletId().equals("2") || portletModel.isInclude()) continue;
                portletPoolsItr.remove();
            }
            PortletApp portletApp = this._getPortletApp("");
            this._setSpriteImages(servletContext, portletApp, "/html/icons/");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public List<Portlet> initWAR(String servletContextName, ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        try {
            Set<String> servletURLPatterns = this._readWebXML(xmls[3]);
            Set<String> portletIds = this._readPortletXML(servletContextName, servletContext, xmls[0], portletsPool, servletURLPatterns, pluginPackage);
            portletIds.addAll(this._readPortletXML(servletContextName, servletContext, xmls[1], portletsPool, servletURLPatterns, pluginPackage));
            Set<String> liferayPortletIds = this._readLiferayPortletXML(servletContextName, xmls[2], portletsPool);
            for (String portletId : portletIds) {
                if (!_log.isWarnEnabled() || liferayPortletIds.contains(portletId)) continue;
                _log.warn((Object)("Portlet with the name " + portletId + " is described in portlet.xml but does not " + "have a matching entry in liferay-portlet.xml"));
            }
            for (String portletId : liferayPortletIds) {
                if (!_log.isWarnEnabled() || portletIds.contains(portletId)) continue;
                _log.warn((Object)("Portlet with the name " + portletId + " is described in liferay-portlet.xml but does " + "not have a matching entry in portlet.xml"));
            }
            for (String portletId : portletIds) {
                Portlet portlet = this._getPortletsPool().get(portletId);
                portlets.add(portlet);
                PortletInstanceFactoryUtil.clear((Portlet)portlet);
                PortletConfigFactoryUtil.destroy((Portlet)portlet);
                PortletContextFactory.destroy(portlet);
            }
            PortletApp portletApp = this._getPortletApp(servletContextName);
            this._setSpriteImages(servletContext, portletApp, "/icons/");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this.clearCache();
        return portlets;
    }

    public Portlet updatePortlet(long companyId, String portletId, String roles, boolean active) throws SystemException {
        Portlet portlet = this.portletPersistence.fetchByC_P(companyId, portletId = PortalUtil.getJsSafePortletId((String)portletId));
        if (portlet == null) {
            long id = this.counterLocalService.increment();
            portlet = this.portletPersistence.create(id);
            portlet.setCompanyId(companyId);
            portlet.setPortletId(portletId);
        }
        portlet.setRoles(roles);
        portlet.setActive(active);
        this.portletPersistence.update((BaseModel)portlet, false);
        portlet = this.getPortletById(companyId, portletId);
        portlet.setRoles(roles);
        portlet.setActive(active);
        this._updateCompanyPortletsPool(companyId);
        return portlet;
    }

    private String _encodeKey(long companyId) {
        return _keyPrefix.concat(String.valueOf(companyId));
    }

    private PortletApp _getPortletApp(String servletContextName) {
        PortletApp portletApp = _portletAppsPool.get(servletContextName);
        if (portletApp == null) {
            portletApp = new PortletAppImpl(servletContextName);
            _portletAppsPool.put(servletContextName, portletApp);
        }
        return portletApp;
    }

    private String _getPortletId(String securityPath) {
        String portletId;
        if (_portletIdsByStrutsPath.size() == 0) {
            for (Portlet portlet : this._getPortletsPool().values()) {
                _portletIdsByStrutsPath.put(portlet.getStrutsPath(), portlet.getPortletId());
            }
        }
        if (Validator.isNull((String)(portletId = _portletIdsByStrutsPath.get(securityPath)))) {
            _log.error((Object)("Struts path " + securityPath + " is not mapped to a portlet " + "in liferay-portlet.xml"));
        }
        return portletId;
    }

    private List<Portlet> _getPortletsByPortletName(String portletName, String servletContextName, Map<String, Portlet> portletsPool) {
        List<Object> portlets = null;
        int pos = portletName.indexOf(42);
        if (pos == -1) {
            Portlet portlet;
            portlets = new ArrayList();
            String portletId = portletName;
            if (Validator.isNotNull((String)servletContextName)) {
                portletId = String.valueOf(portletId) + "_WAR_" + servletContextName;
            }
            if ((portlet = portletsPool.get(portletId = PortalUtil.getJsSafePortletId((String)portletId))) != null) {
                portlets.add(portlet);
            }
            return portlets;
        }
        String portletNamePrefix = portletName.substring(0, pos);
        portlets = this._getPortletsByServletContextName(servletContextName, portletsPool);
        Iterator<Object> itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            String portletId = portlet.getPortletId();
            if (portletId.startsWith(portletNamePrefix)) continue;
            itr.remove();
        }
        return portlets;
    }

    private List<Portlet> _getPortletsByServletContextName(String servletContextName, Map<String, Portlet> portletsPool) {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        for (Map.Entry<String, Portlet> entry : portletsPool.entrySet()) {
            String portletId = entry.getKey();
            Portlet portlet = entry.getValue();
            if (Validator.isNotNull((String)servletContextName)) {
                if (!portletId.endsWith("_WAR_" + servletContextName)) continue;
                portlets.add(portlet);
                continue;
            }
            if (portletId.contains("_WAR_")) continue;
            portlets.add(portlet);
        }
        return portlets;
    }

    private Map<String, Portlet> _getPortletsPool() {
        return _portletsPool;
    }

    private Map<String, Portlet> _getPortletsPool(long companyId) throws SystemException {
        String key = this._encodeKey(companyId);
        ConcurrentHashMap<String, Portlet> portletsPool = (ConcurrentHashMap<String, Portlet>)_companyPortletsPool.get(key);
        if (portletsPool == null) {
            portletsPool = new ConcurrentHashMap<String, Portlet>();
            Map<String, Portlet> parentPortletsPool = this._getPortletsPool();
            if (parentPortletsPool == null) {
                return portletsPool;
            }
            for (Portlet portlet : parentPortletsPool.values()) {
                portlet = (Portlet)portlet.clone();
                portlet.setCompanyId(companyId);
                portletsPool.put(portlet.getPortletId(), portlet);
            }
            List portlets = this.portletPersistence.findByCompanyId(companyId);
            for (Portlet portlet : portlets) {
                Portlet portletModel = (Portlet)portletsPool.get(portlet.getPortletId());
                if (portletModel == null) continue;
                portletModel.setPluginPackage(portlet.getPluginPackage());
                portletModel.setDefaultPluginSetting(portlet.getDefaultPluginSetting());
                portletModel.setRoles(portlet.getRoles());
                portletModel.setActive(portlet.getActive());
            }
            _companyPortletsPool.put(key, portletsPool);
        }
        return portletsPool;
    }

    private void _readLiferayDisplay(String servletContextName, Element element, PortletCategory portletCategory, Set<String> portletIds) {
        for (Element categoryElement : element.elements("category")) {
            String name = categoryElement.attributeValue("name");
            PortletCategory curPortletCategory = new PortletCategory(name);
            portletCategory.addCategory(curPortletCategory);
            Set curPortletIds = curPortletCategory.getPortletIds();
            for (Element portletElement : categoryElement.elements("portlet")) {
                String portletId = portletElement.attributeValue("id");
                if (Validator.isNotNull((String)servletContextName)) {
                    portletId = String.valueOf(portletId) + "_WAR_" + servletContextName;
                }
                portletId = PortalUtil.getJsSafePortletId((String)portletId);
                portletIds.add(portletId);
                curPortletIds.add(portletId);
            }
            this._readLiferayDisplay(servletContextName, categoryElement, curPortletCategory, portletIds);
        }
    }

    private PortletCategory _readLiferayDisplayXML(String xml) throws Exception {
        return this._readLiferayDisplayXML(null, xml);
    }

    private PortletCategory _readLiferayDisplayXML(String servletContextName, String xml) throws Exception {
        PortletCategory portletCategory = new PortletCategory();
        if (xml == null) {
            xml = ContentUtil.get("com/liferay/portal/deploy/dependencies/liferay-display.xml");
        }
        Document document = SAXReaderUtil.read((String)xml, (boolean)true);
        Element rootElement = document.getRootElement();
        HashSet<String> portletIds = new HashSet<String>();
        this._readLiferayDisplay(servletContextName, rootElement, portletCategory, portletIds);
        HashSet<String> undefinedPortletIds = new HashSet<String>();
        for (Portlet portlet : this._getPortletsPool().values()) {
            String portletId = portlet.getPortletId();
            PortletApp portletApp = portlet.getPortletApp();
            if (servletContextName != null && portletApp.isWARFile() && portletId.endsWith("_WAR_" + PortalUtil.getJsSafePortletId((String)servletContextName)) && !portletIds.contains(portletId)) {
                undefinedPortletIds.add(portletId);
                continue;
            }
            if (servletContextName != null || portletApp.isWARFile() || portletId.indexOf("_WAR_") != -1 || portletIds.contains(portletId)) continue;
            undefinedPortletIds.add(portletId);
        }
        if (!undefinedPortletIds.isEmpty()) {
            PortletCategory undefinedCategory = new PortletCategory("category.undefined");
            portletCategory.addCategory(undefinedCategory);
            undefinedCategory.getPortletIds().addAll(undefinedPortletIds);
        }
        return portletCategory;
    }

    private Set<String> _readLiferayPortletXML(String xml, Map<String, Portlet> portletsPool) throws Exception {
        return this._readLiferayPortletXML("", xml, portletsPool);
    }

    private void _readLiferayPortletXML(String servletContextName, Map<String, Portlet> portletsPool, Set<String> liferayPortletIds, Map<String, String> roleMappers, Element portletElement) {
        String portletId = portletElement.elementText("portlet-name");
        if (Validator.isNotNull((String)servletContextName)) {
            portletId = portletId.concat("_WAR_").concat(servletContextName);
        }
        portletId = PortalUtil.getJsSafePortletId((String)portletId);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading portlet extension " + portletId));
        }
        liferayPortletIds.add(portletId);
        Portlet portletModel = portletsPool.get(portletId);
        if (portletModel == null) {
            return;
        }
        portletModel.setIcon(GetterUtil.getString((String)portletElement.elementText("icon"), (String)portletModel.getIcon()));
        portletModel.setVirtualPath(GetterUtil.getString((String)portletElement.elementText("virtual-path"), (String)portletModel.getVirtualPath()));
        portletModel.setStrutsPath(GetterUtil.getString((String)portletElement.elementText("struts-path"), (String)portletModel.getStrutsPath()));
        if (Validator.isNotNull((String)portletElement.elementText("configuration-path"))) {
            _log.error((Object)"The configuration-path element is no longer supported. Use configuration-action-class instead.");
        }
        portletModel.setConfigurationActionClass(GetterUtil.getString((String)portletElement.elementText("configuration-action-class"), (String)portletModel.getConfigurationActionClass()));
        portletModel.setIndexerClass(GetterUtil.getString((String)portletElement.elementText("indexer-class"), (String)portletModel.getIndexerClass()));
        portletModel.setOpenSearchClass(GetterUtil.getString((String)portletElement.elementText("open-search-class"), (String)portletModel.getOpenSearchClass()));
        for (Element schedulerEntryElement : portletElement.elements("scheduler-entry")) {
            Object propertyKeyElement;
            SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl();
            schedulerEntry.setDescription(GetterUtil.getString((String)schedulerEntryElement.elementText("scheduler-description")));
            schedulerEntry.setEventListenerClass(GetterUtil.getString((String)schedulerEntryElement.elementText("scheduler-event-listener-class"), (String)schedulerEntry.getEventListenerClass()));
            Element triggerElement = schedulerEntryElement.element("trigger");
            Element cronElement = triggerElement.element("cron");
            Element simpleElement = triggerElement.element("simple");
            if (cronElement != null) {
                schedulerEntry.setTriggerType(TriggerType.CRON);
                propertyKeyElement = cronElement.element("property-key");
                if (propertyKeyElement != null) {
                    schedulerEntry.setPropertyKey(propertyKeyElement.getTextTrim());
                } else {
                    schedulerEntry.setTriggerValue(cronElement.elementText("cron-trigger-value"));
                }
            } else if (simpleElement != null) {
                schedulerEntry.setTriggerType(TriggerType.SIMPLE);
                propertyKeyElement = simpleElement.element("property-key");
                if (propertyKeyElement != null) {
                    schedulerEntry.setPropertyKey(propertyKeyElement.getTextTrim());
                } else {
                    Element simpleTriggerValueElement = simpleElement.element("simple-trigger-value");
                    schedulerEntry.setTriggerValue(simpleTriggerValueElement.getTextTrim());
                }
                String timeUnit = GetterUtil.getString((String)simpleElement.elementText("time-unit"), (String)TimeUnit.SECOND.getValue());
                schedulerEntry.setTimeUnit(TimeUnit.parse((String)timeUnit.toLowerCase()));
            }
            portletModel.addSchedulerEntry((SchedulerEntry)schedulerEntry);
        }
        portletModel.setPortletURLClass(GetterUtil.getString((String)portletElement.elementText("portlet-url-class"), (String)portletModel.getPortletURLClass()));
        portletModel.setFriendlyURLMapperClass(GetterUtil.getString((String)portletElement.elementText("friendly-url-mapper-class"), (String)portletModel.getFriendlyURLMapperClass()));
        if (Validator.isNull((String)portletModel.getFriendlyURLMapperClass())) {
            _friendlyURLMapperPortlets.remove(portletId);
        } else {
            _friendlyURLMapperPortlets.put(portletId, portletModel);
        }
        portletModel.setFriendlyURLMapping(GetterUtil.getString((String)portletElement.elementText("friendly-url-mapping"), (String)portletModel.getFriendlyURLMapping()));
        portletModel.setFriendlyURLRoutes(GetterUtil.getString((String)portletElement.elementText("friendly-url-routes"), (String)portletModel.getFriendlyURLRoutes()));
        portletModel.setURLEncoderClass(GetterUtil.getString((String)portletElement.elementText("url-encoder-class"), (String)portletModel.getURLEncoderClass()));
        portletModel.setPortletDataHandlerClass(GetterUtil.getString((String)portletElement.elementText("portlet-data-handler-class"), (String)portletModel.getPortletDataHandlerClass()));
        portletModel.setPortletLayoutListenerClass(GetterUtil.getString((String)portletElement.elementText("portlet-layout-listener-class"), (String)portletModel.getPortletLayoutListenerClass()));
        portletModel.setPollerProcessorClass(GetterUtil.getString((String)portletElement.elementText("poller-processor-class"), (String)portletModel.getPollerProcessorClass()));
        portletModel.setPopMessageListenerClass(GetterUtil.getString((String)portletElement.elementText("pop-message-listener-class"), (String)portletModel.getPopMessageListenerClass()));
        portletModel.setSocialActivityInterpreterClass(GetterUtil.getString((String)portletElement.elementText("social-activity-interpreter-class"), (String)portletModel.getSocialActivityInterpreterClass()));
        portletModel.setSocialRequestInterpreterClass(GetterUtil.getString((String)portletElement.elementText("social-request-interpreter-class"), (String)portletModel.getSocialRequestInterpreterClass()));
        portletModel.setWebDAVStorageToken(GetterUtil.getString((String)portletElement.elementText("webdav-storage-token"), (String)portletModel.getWebDAVStorageToken()));
        portletModel.setWebDAVStorageClass(GetterUtil.getString((String)portletElement.elementText("webdav-storage-class"), (String)portletModel.getWebDAVStorageClass()));
        portletModel.setXmlRpcMethodClass(GetterUtil.getString((String)portletElement.elementText("xml-rpc-method-class"), (String)portletModel.getXmlRpcMethodClass()));
        portletModel.setControlPanelEntryCategory(GetterUtil.getString((String)portletElement.elementText("control-panel-entry-category"), (String)portletModel.getControlPanelEntryCategory()));
        portletModel.setControlPanelEntryWeight(GetterUtil.getDouble((String)portletElement.elementText("control-panel-entry-weight"), (double)portletModel.getControlPanelEntryWeight()));
        portletModel.setControlPanelEntryClass(GetterUtil.getString((String)portletElement.elementText("control-panel-entry-class"), (String)portletModel.getControlPanelEntryClass()));
        List assetRendererFactoryClasses = portletModel.getAssetRendererFactoryClasses();
        for (Element assetRendererFactoryClassElement : portletElement.elements("asset-renderer-factory")) {
            assetRendererFactoryClasses.add(assetRendererFactoryClassElement.getText());
        }
        List customAttributesDisplayClasses = portletModel.getCustomAttributesDisplayClasses();
        for (Element customAttributesDisplayClassElement : portletElement.elements("custom-attributes-display")) {
            customAttributesDisplayClasses.add(customAttributesDisplayClassElement.getText());
        }
        if (customAttributesDisplayClasses.isEmpty()) {
            _customAttributesDisplayPortlets.remove(portletId);
        } else {
            _customAttributesDisplayPortlets.put(portletId, portletModel);
        }
        List workflowHandlerClasses = portletModel.getWorkflowHandlerClasses();
        for (Element workflowHandlerClassElement : portletElement.elements("workflow-handler")) {
            workflowHandlerClasses.add(workflowHandlerClassElement.getText());
        }
        portletModel.setPreferencesCompanyWide(GetterUtil.getBoolean((String)portletElement.elementText("preferences-company-wide"), (boolean)portletModel.isPreferencesCompanyWide()));
        portletModel.setPreferencesUniquePerLayout(GetterUtil.getBoolean((String)portletElement.elementText("preferences-unique-per-layout"), (boolean)portletModel.isPreferencesUniquePerLayout()));
        portletModel.setPreferencesOwnedByGroup(GetterUtil.getBoolean((String)portletElement.elementText("preferences-owned-by-group"), (boolean)portletModel.isPreferencesOwnedByGroup()));
        portletModel.setUseDefaultTemplate(GetterUtil.getBoolean((String)portletElement.elementText("use-default-template"), (boolean)portletModel.isUseDefaultTemplate()));
        portletModel.setShowPortletAccessDenied(GetterUtil.getBoolean((String)portletElement.elementText("show-portlet-access-denied"), (boolean)portletModel.isShowPortletAccessDenied()));
        portletModel.setShowPortletInactive(GetterUtil.getBoolean((String)portletElement.elementText("show-portlet-inactive"), (boolean)portletModel.isShowPortletInactive()));
        portletModel.setActionURLRedirect(GetterUtil.getBoolean((String)portletElement.elementText("action-url-redirect"), (boolean)portletModel.isActionURLRedirect()));
        portletModel.setRestoreCurrentView(GetterUtil.getBoolean((String)portletElement.elementText("restore-current-view"), (boolean)portletModel.isRestoreCurrentView()));
        portletModel.setMaximizeEdit(GetterUtil.getBoolean((String)portletElement.elementText("maximize-edit"), (boolean)portletModel.isMaximizeEdit()));
        portletModel.setMaximizeHelp(GetterUtil.getBoolean((String)portletElement.elementText("maximize-help"), (boolean)portletModel.isMaximizeHelp()));
        portletModel.setPopUpPrint(GetterUtil.getBoolean((String)portletElement.elementText("pop-up-print"), (boolean)portletModel.isPopUpPrint()));
        portletModel.setLayoutCacheable(GetterUtil.getBoolean((String)portletElement.elementText("layout-cacheable"), (boolean)portletModel.isLayoutCacheable()));
        portletModel.setInstanceable(GetterUtil.getBoolean((String)portletElement.elementText("instanceable"), (boolean)portletModel.isInstanceable()));
        portletModel.setRemoteable(GetterUtil.getBoolean((String)portletElement.elementText("remoteable"), (boolean)portletModel.isRemoteable()));
        portletModel.setScopeable(GetterUtil.getBoolean((String)portletElement.elementText("scopeable"), (boolean)portletModel.isScopeable()));
        portletModel.setUserPrincipalStrategy(GetterUtil.getString((String)portletElement.elementText("user-principal-strategy"), (String)portletModel.getUserPrincipalStrategy()));
        portletModel.setPrivateRequestAttributes(GetterUtil.getBoolean((String)portletElement.elementText("private-request-attributes"), (boolean)portletModel.isPrivateRequestAttributes()));
        portletModel.setPrivateSessionAttributes(GetterUtil.getBoolean((String)portletElement.elementText("private-session-attributes"), (boolean)portletModel.isPrivateSessionAttributes()));
        portletModel.setRenderWeight(GetterUtil.getInteger((String)portletElement.elementText("render-weight"), (int)portletModel.getRenderWeight()));
        portletModel.setAjaxable(GetterUtil.getBoolean((String)portletElement.elementText("ajaxable"), (boolean)portletModel.isAjaxable()));
        List headerPortalCssList = portletModel.getHeaderPortalCss();
        for (Element headerPortalCssElement : portletElement.elements("header-portal-css")) {
            headerPortalCssList.add(headerPortalCssElement.getText());
        }
        List headerPortletCssList = portletModel.getHeaderPortletCss();
        for (Element headerPortletCssElement : portletElement.elements("header-portlet-css")) {
            headerPortletCssList.add(headerPortletCssElement.getText());
        }
        List headerPortalJavaScriptList = portletModel.getHeaderPortalJavaScript();
        for (Element headerPortalJavaScriptElement : portletElement.elements("header-portal-javascript")) {
            headerPortalJavaScriptList.add(headerPortalJavaScriptElement.getText());
        }
        List headerPortletJavaScriptList = portletModel.getHeaderPortletJavaScript();
        for (Element headerPortletJavaScriptElement : portletElement.elements("header-portlet-javascript")) {
            headerPortletJavaScriptList.add(headerPortletJavaScriptElement.getText());
        }
        List footerPortalCssList = portletModel.getFooterPortalCss();
        for (Element footerPortalCssElement : portletElement.elements("footer-portal-css")) {
            footerPortalCssList.add(footerPortalCssElement.getText());
        }
        List footerPortletCssList = portletModel.getFooterPortletCss();
        for (Element footerPortletCssElement : portletElement.elements("footer-portlet-css")) {
            footerPortletCssList.add(footerPortletCssElement.getText());
        }
        List footerPortalJavaScriptList = portletModel.getFooterPortalJavaScript();
        for (Element footerPortalJavaScriptElement : portletElement.elements("footer-portal-javascript")) {
            footerPortalJavaScriptList.add(footerPortalJavaScriptElement.getText());
        }
        List footerPortletJavaScriptList = portletModel.getFooterPortletJavaScript();
        for (Element footerPortletJavaScriptElement : portletElement.elements("footer-portlet-javascript")) {
            footerPortletJavaScriptList.add(footerPortletJavaScriptElement.getText());
        }
        portletModel.setCssClassWrapper(GetterUtil.getString((String)portletElement.elementText("css-class-wrapper"), (String)portletModel.getCssClassWrapper()));
        portletModel.setFacebookIntegration(GetterUtil.getString((String)portletElement.elementText("facebook-integration"), (String)portletModel.getFacebookIntegration()));
        portletModel.setAddDefaultResource(GetterUtil.getBoolean((String)portletElement.elementText("add-default-resource"), (boolean)portletModel.isAddDefaultResource()));
        portletModel.setSystem(GetterUtil.getBoolean((String)portletElement.elementText("system"), (boolean)portletModel.isSystem()));
        portletModel.setActive(GetterUtil.getBoolean((String)portletElement.elementText("active"), (boolean)portletModel.isActive()));
        portletModel.setInclude(GetterUtil.getBoolean((String)portletElement.elementText("include"), (boolean)portletModel.isInclude()));
        if (!portletModel.isAjaxable() && portletModel.getRenderWeight() < 1) {
            portletModel.setRenderWeight(1);
        }
        portletModel.getRoleMappers().putAll(roleMappers);
        portletModel.linkRoles();
    }

    private Set<String> _readLiferayPortletXML(String servletContextName, String xml, Map<String, Portlet> portletsPool) throws Exception {
        HashSet<String> liferayPortletIds = new HashSet<String>();
        if (xml == null) {
            return liferayPortletIds;
        }
        Document document = SAXReaderUtil.read((String)xml, (boolean)true);
        Element rootElement = document.getRootElement();
        PortletApp portletApp = this._getPortletApp(servletContextName);
        HashMap<String, String> roleMappers = new HashMap<String, String>();
        for (Element roleMapperElement : rootElement.elements("role-mapper")) {
            String roleName = roleMapperElement.elementText("role-name");
            String roleLink = roleMapperElement.elementText("role-link");
            roleMappers.put(roleName, roleLink);
        }
        Map customUserAttributes = portletApp.getCustomUserAttributes();
        for (Element customUserAttributeElement : rootElement.elements("custom-user-attribute")) {
            String customClass = customUserAttributeElement.elementText("custom-class");
            for (Element nameElement : customUserAttributeElement.elements("name")) {
                String name = nameElement.getText();
                customUserAttributes.put(name, customClass);
            }
        }
        for (Element portletElement : rootElement.elements("portlet")) {
            this._readLiferayPortletXML(servletContextName, portletsPool, liferayPortletIds, roleMappers, portletElement);
        }
        return liferayPortletIds;
    }

    private Set<String> _readPortletXML(ServletContext servletContext, String xml, Map<String, Portlet> portletsPool, Set<String> servletURLPatterns, PluginPackage pluginPackage) throws Exception {
        return this._readPortletXML("", servletContext, xml, portletsPool, servletURLPatterns, pluginPackage);
    }

    private void _readPortletXML(String servletContextName, Map<String, Portlet> portletsPool, PluginPackage pluginPackage, PortletApp portletApp, Set<String> portletIds, long timestamp, Element portletElement) {
        QName qName;
        Element nameElement;
        Element qNameElement;
        Portlet portletModel;
        block23: {
            String portletName;
            String portletId = portletName = portletElement.elementText("portlet-name");
            if (Validator.isNotNull((String)servletContextName)) {
                portletId = portletId.concat("_WAR_").concat(servletContextName);
            }
            portletId = PortalUtil.getJsSafePortletId((String)portletId);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Reading portlet " + portletId));
            }
            portletIds.add(portletId);
            portletModel = portletsPool.get(portletId);
            if (portletModel == null) {
                portletModel = new PortletImpl(0L, portletId);
                portletsPool.put(portletId, portletModel);
            }
            portletModel.setTimestamp(timestamp);
            portletModel.setPluginPackage(pluginPackage);
            portletModel.setPortletApp(portletApp);
            portletModel.setPortletName(portletName);
            portletModel.setDisplayName(GetterUtil.getString((String)portletElement.elementText("display-name"), (String)portletModel.getDisplayName()));
            portletModel.setPortletClass(GetterUtil.getString((String)portletElement.elementText("portlet-class")));
            Map initParams = portletModel.getInitParams();
            for (Element initParamElement : portletElement.elements("init-param")) {
                initParams.put(initParamElement.elementText("name"), initParamElement.elementText("value"));
            }
            Element expirationCacheElement = portletElement.element("expiration-cache");
            if (expirationCacheElement != null) {
                portletModel.setExpCache(Integer.valueOf(GetterUtil.getInteger((String)expirationCacheElement.getText())));
            }
            for (Element supportsElement : portletElement.elements("supports")) {
                String mimeType;
                Map portletModes = portletModel.getPortletModes();
                HashSet<String> mimeTypePortletModes = (HashSet<String>)portletModes.get(mimeType = supportsElement.elementText("mime-type"));
                if (mimeTypePortletModes == null) {
                    mimeTypePortletModes = new HashSet<String>();
                    portletModes.put(mimeType, mimeTypePortletModes);
                }
                mimeTypePortletModes.add(PortletMode.VIEW.toString().toLowerCase());
                for (Element portletModeElement : supportsElement.elements("portlet-mode")) {
                    mimeTypePortletModes.add(portletModeElement.getTextTrim().toLowerCase());
                }
                Map windowStates = portletModel.getWindowStates();
                HashSet<String> mimeTypeWindowStates = (HashSet<String>)windowStates.get(mimeType);
                if (mimeTypeWindowStates == null) {
                    mimeTypeWindowStates = new HashSet<String>();
                    windowStates.put(mimeType, mimeTypeWindowStates);
                }
                mimeTypeWindowStates.add(WindowState.NORMAL.toString().toLowerCase());
                List windowStateElements = supportsElement.elements("window-state");
                if (windowStateElements.isEmpty()) {
                    mimeTypeWindowStates.add(WindowState.MAXIMIZED.toString().toLowerCase());
                    mimeTypeWindowStates.add(WindowState.MINIMIZED.toString().toLowerCase());
                    mimeTypeWindowStates.add(LiferayWindowState.EXCLUSIVE.toString().toLowerCase());
                    mimeTypeWindowStates.add(LiferayWindowState.POP_UP.toString().toLowerCase());
                }
                for (Element windowStateElement : windowStateElements) {
                    mimeTypeWindowStates.add(windowStateElement.getTextTrim().toLowerCase());
                }
            }
            Set supportedLocales = portletModel.getSupportedLocales();
            for (Element supportedLocaleElement : portletElement.elements("supported-locale")) {
                String supportedLocale = supportedLocaleElement.getText();
                supportedLocales.add(supportedLocale);
            }
            portletModel.setResourceBundle(portletElement.elementText("resource-bundle"));
            Element portletInfoElement = portletElement.element("portlet-info");
            String portletInfoTitle = null;
            String portletInfoShortTitle = null;
            String portletInfoKeyWords = null;
            String portletInfoDescription = null;
            if (portletInfoElement != null) {
                portletInfoTitle = portletInfoElement.elementText("title");
                portletInfoShortTitle = portletInfoElement.elementText("short-title");
                portletInfoKeyWords = portletInfoElement.elementText("keywords");
            }
            PortletInfo portletInfo = new PortletInfo(portletInfoTitle, portletInfoShortTitle, portletInfoKeyWords, portletInfoDescription);
            portletModel.setPortletInfo(portletInfo);
            Element portletPreferencesElement = portletElement.element("portlet-preferences");
            String defaultPreferences = null;
            String preferencesValidator = null;
            if (portletPreferencesElement != null) {
                Element preferencesValidatorElement = portletPreferencesElement.element("preferences-validator");
                if (preferencesValidatorElement != null) {
                    preferencesValidator = preferencesValidatorElement.getText();
                    portletPreferencesElement.remove(preferencesValidatorElement);
                }
                defaultPreferences = portletPreferencesElement.asXML();
            }
            portletModel.setDefaultPreferences(defaultPreferences);
            portletModel.setPreferencesValidator(preferencesValidator);
            if (!portletApp.isWARFile() && Validator.isNotNull((String)preferencesValidator) && PropsValues.PREFERENCE_VALIDATE_ON_STARTUP) {
                try {
                    PreferencesValidator preferencesValidatorObj = PortalUtil.getPreferencesValidator((Portlet)portletModel);
                    preferencesValidatorObj.validate(PortletPreferencesSerializer.fromDefaultXML(defaultPreferences));
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block23;
                    _log.warn((Object)("Portlet with the name " + portletId + " does not have valid default preferences"));
                }
            }
        }
        Set unlikedRoles = portletModel.getUnlinkedRoles();
        for (Element roleElement : portletElement.elements("security-role-ref")) {
            unlikedRoles.add(roleElement.elementText("role-name"));
        }
        for (Element supportedProcessingEventElement : portletElement.elements("supported-processing-event")) {
            qNameElement = supportedProcessingEventElement.element("qname");
            nameElement = supportedProcessingEventElement.element("name");
            qName = PortletQNameUtil.getQName((Element)qNameElement, (Element)nameElement, (String)portletApp.getDefaultNamespace());
            portletModel.addProcessingEvent(qName);
        }
        for (Element supportedPublishingEventElement : portletElement.elements("supported-publishing-event")) {
            qNameElement = supportedPublishingEventElement.element("qname");
            nameElement = supportedPublishingEventElement.element("name");
            qName = PortletQNameUtil.getQName((Element)qNameElement, (Element)nameElement, (String)portletApp.getDefaultNamespace());
            portletModel.addPublishingEvent(qName);
        }
        for (Element supportedPublicRenderParameter : portletElement.elements("supported-public-render-parameter")) {
            String identifier = supportedPublicRenderParameter.getTextTrim();
            PublicRenderParameter publicRenderParameter = portletApp.getPublicRenderParameter(identifier);
            if (publicRenderParameter == null) {
                _log.error((Object)("Supported public render parameter references unnknown identifier " + identifier));
                continue;
            }
            portletModel.addPublicRenderParameter(publicRenderParameter);
        }
    }

    private Set<String> _readPortletXML(String servletContextName, ServletContext servletContext, String xml, Map<String, Portlet> portletsPool, Set<String> servletURLPatterns, PluginPackage pluginPackage) throws Exception {
        PortletFilter portletFilter;
        String filterName;
        Object qName;
        HashSet<String> portletIds = new HashSet<String>();
        if (xml == null) {
            return portletIds;
        }
        Document document = SAXReaderUtil.read((String)xml, (boolean)PropsValues.PORTLET_XML_VALIDATE);
        Element rootElement = document.getRootElement();
        PortletApp portletApp = this._getPortletApp(servletContextName);
        portletApp.addServletURLPatterns(servletURLPatterns);
        Set userAttributes = portletApp.getUserAttributes();
        for (Element userAttributeElement : rootElement.elements("user-attribute")) {
            String name = userAttributeElement.elementText("name");
            userAttributes.add(name);
        }
        String defaultNamespace = rootElement.elementText("default-namespace");
        if (Validator.isNotNull((String)defaultNamespace)) {
            portletApp.setDefaultNamespace(defaultNamespace);
        }
        for (Element eventDefinitionElement : rootElement.elements("event-definition")) {
            Element qNameElement = eventDefinitionElement.element("qname");
            Element nameElement = eventDefinitionElement.element("name");
            String valueType = eventDefinitionElement.elementText("value-type");
            qName = PortletQNameUtil.getQName((Element)qNameElement, (Element)nameElement, (String)portletApp.getDefaultNamespace());
            EventDefinitionImpl eventDefinition = new EventDefinitionImpl((QName)qName, valueType, portletApp);
            portletApp.addEventDefinition((EventDefinition)eventDefinition);
        }
        for (Element publicRenderParameterElement : rootElement.elements("public-render-parameter")) {
            String identifier = publicRenderParameterElement.elementText("identifier");
            Element qNameElement = publicRenderParameterElement.element("qname");
            Element nameElement = publicRenderParameterElement.element("name");
            qName = PortletQNameUtil.getQName((Element)qNameElement, (Element)nameElement, (String)portletApp.getDefaultNamespace());
            PublicRenderParameterImpl publicRenderParameter = new PublicRenderParameterImpl(identifier, (QName)qName, portletApp);
            portletApp.addPublicRenderParameter((PublicRenderParameter)publicRenderParameter);
        }
        for (Element containerRuntimeOptionElement : rootElement.elements("container-runtime-option")) {
            String name = GetterUtil.getString((String)containerRuntimeOptionElement.elementText("name"));
            ArrayList<String> values = new ArrayList<String>();
            for (Element valueElement : containerRuntimeOptionElement.elements("value")) {
                values.add(valueElement.getTextTrim());
            }
            Map containerRuntimeOptions = portletApp.getContainerRuntimeOptions();
            containerRuntimeOptions.put(name, values.toArray(new String[values.size()]));
            if (!name.equals("com.liferay.portal.portalContext") || values.isEmpty() || !GetterUtil.getBoolean((String)((String)values.get(0)))) continue;
            portletApp.setWARFile(false);
        }
        long timestamp = ServletContextUtil.getLastModified((ServletContext)servletContext);
        for (Element portletElement : rootElement.elements("portlet")) {
            this._readPortletXML(servletContextName, portletsPool, pluginPackage, portletApp, portletIds, timestamp, portletElement);
        }
        for (Element filterElement : rootElement.elements("filter")) {
            filterName = filterElement.elementText("filter-name");
            String filterClass = filterElement.elementText("filter-class");
            LinkedHashSet<String> lifecycles = new LinkedHashSet<String>();
            for (Element lifecycleElement : filterElement.elements("lifecycle")) {
                lifecycles.add(lifecycleElement.getText());
            }
            HashMap<String, String> initParams = new HashMap<String, String>();
            for (Element initParamElement : filterElement.elements("init-param")) {
                initParams.put(initParamElement.elementText("name"), initParamElement.elementText("value"));
            }
            portletFilter = new PortletFilterImpl(filterName, filterClass, lifecycles, initParams, portletApp);
            portletApp.addPortletFilter(portletFilter);
        }
        for (Element filterMappingElement : rootElement.elements("filter-mapping")) {
            filterName = filterMappingElement.elementText("filter-name");
            for (Element portletNameElement : filterMappingElement.elements("portlet-name")) {
                String portletName = portletNameElement.getTextTrim();
                portletFilter = portletApp.getPortletFilter(filterName);
                if (portletFilter == null) {
                    _log.error((Object)("Filter mapping references unnknown filter name " + filterName));
                    continue;
                }
                List<Portlet> portletModels = this._getPortletsByPortletName(portletName, servletContextName, portletsPool);
                if (portletModels.size() == 0) {
                    _log.error((Object)("Filter mapping with filter name " + filterName + " references unnknown portlet name " + portletName));
                }
                for (Portlet portletModel : portletModels) {
                    portletModel.getPortletFilters().put(filterName, portletFilter);
                }
            }
        }
        for (Element listenerElement : rootElement.elements("listener")) {
            String listenerClass = listenerElement.elementText("listener-class");
            PortletURLListenerImpl portletURLListener = new PortletURLListenerImpl(listenerClass, portletApp);
            portletApp.addPortletURLListener((PortletURLListener)portletURLListener);
        }
        return portletIds;
    }

    private Set<String> _readWebXML(String xml) throws Exception {
        LinkedHashSet<String> servletURLPatterns = new LinkedHashSet<String>();
        if (xml == null) {
            return servletURLPatterns;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        for (Element servletMappingElement : rootElement.elements("servlet-mapping")) {
            String urlPattern = servletMappingElement.elementText("url-pattern");
            servletURLPatterns.add(urlPattern);
        }
        return servletURLPatterns;
    }

    private void _setSpriteImages(ServletContext servletContext, PortletApp portletApp, String resourcePath) throws Exception {
        Set resourcePaths = servletContext.getResourcePaths(resourcePath);
        if (resourcePaths == null) {
            return;
        }
        ArrayList<File> images = new ArrayList<File>(resourcePaths.size());
        for (String curResourcePath : resourcePaths) {
            if (curResourcePath.endsWith("/")) {
                this._setSpriteImages(servletContext, portletApp, curResourcePath);
                continue;
            }
            if (!curResourcePath.endsWith(".png")) continue;
            String realPath = ServletContextUtil.getRealPath((ServletContext)servletContext, (String)curResourcePath);
            if (realPath != null) {
                images.add(new File(realPath));
                continue;
            }
            if (ServerDetector.isTomcat()) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)"Please configure Tomcat to unpack WARs to enable enable sprites for best performance");
                continue;
            }
            _log.error((Object)("Real path for " + curResourcePath + " is null"));
        }
        String spriteFileName = ".sprite.png";
        String spritePropertiesFileName = ".sprite.properties";
        String spritePropertiesRootPath = ServletContextUtil.getRealPath((ServletContext)servletContext, (String)"/");
        Properties spriteProperties = SpriteProcessorUtil.generate(images, (String)spriteFileName, (String)spritePropertiesFileName, (String)spritePropertiesRootPath, (int)16, (int)16, (int)10240);
        if (spriteProperties == null) {
            return;
        }
        spriteFileName = String.valueOf(resourcePath.substring(0, resourcePath.length())) + spriteFileName;
        portletApp.setSpriteImages(spriteFileName, spriteProperties);
    }

    private void _updateCompanyPortletsPool(long companyId) {
        String key = this._encodeKey(companyId);
        Map portletsPool = (Map)_companyPortletsPool.get(key);
        _companyPortletsPool.put(key, (Object)portletsPool);
    }
}

