/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutSetPrototypeLocalServiceBaseImpl;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutSetPrototypeLocalServiceImpl
extends LayoutSetPrototypeLocalServiceBaseImpl {
    public LayoutSetPrototype addLayoutSetPrototype(long userId, long companyId, Map<Locale, String> nameMap, String description, boolean active) throws PortalException, SystemException {
        long layoutSetPrototypeId = this.counterLocalService.increment();
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.create(layoutSetPrototypeId);
        layoutSetPrototype.setCompanyId(companyId);
        layoutSetPrototype.setNameMap(nameMap);
        layoutSetPrototype.setDescription(description);
        layoutSetPrototype.setActive(active);
        this.layoutSetPrototypePersistence.update((BaseModel)layoutSetPrototype, false);
        if (userId > 0L) {
            this.resourceLocalService.addResources(companyId, 0L, userId, LayoutSetPrototype.class.getName(), layoutSetPrototype.getLayoutSetPrototypeId(), false, false, false);
        }
        String friendlyURL = "/template-" + layoutSetPrototype.getLayoutSetPrototypeId();
        Group group = this.groupLocalService.addGroup(userId, LayoutSetPrototype.class.getName(), layoutSetPrototype.getLayoutSetPrototypeId(), layoutSetPrototype.getName(LocaleUtil.getDefault()), null, 0, friendlyURL, true, null);
        ServiceContext serviceContext = new ServiceContext();
        this.layoutLocalService.addLayout(userId, group.getGroupId(), true, 0L, "home", null, null, "portlet", false, "/home", serviceContext);
        return layoutSetPrototype;
    }

    @Override
    public void deleteLayoutSetPrototype(long layoutSetPrototypeId) throws PortalException, SystemException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.findByPrimaryKey(layoutSetPrototypeId);
        Group group = layoutSetPrototype.getGroup();
        this.groupLocalService.deleteGroup(group.getGroupId());
        this.resourceLocalService.deleteResource(layoutSetPrototype.getCompanyId(), LayoutSetPrototype.class.getName(), 4, layoutSetPrototype.getLayoutSetPrototypeId());
        this.layoutSetPrototypePersistence.remove((BaseModel)layoutSetPrototype);
        PermissionCacheUtil.clearCache();
    }

    public List<LayoutSetPrototype> search(long companyId, Boolean active, int start, int end, OrderByComparator obc) throws SystemException {
        if (active != null) {
            return this.layoutSetPrototypePersistence.findByC_A(companyId, active.booleanValue(), start, end, obc);
        }
        return this.layoutSetPrototypePersistence.findByCompanyId(companyId, start, end, obc);
    }

    public int searchCount(long companyId, Boolean active) throws SystemException {
        if (active != null) {
            return this.layoutSetPrototypePersistence.countByC_A(companyId, active.booleanValue());
        }
        return this.layoutSetPrototypePersistence.countByCompanyId(companyId);
    }

    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, Map<Locale, String> nameMap, String description, boolean active) throws PortalException, SystemException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.findByPrimaryKey(layoutSetPrototypeId);
        layoutSetPrototype.setNameMap(nameMap);
        layoutSetPrototype.setDescription(description);
        layoutSetPrototype.setActive(active);
        this.layoutSetPrototypePersistence.update((BaseModel)layoutSetPrototype, false);
        Group group = this.groupLocalService.getLayoutSetPrototypeGroup(layoutSetPrototype.getCompanyId(), layoutSetPrototypeId);
        group.setName(layoutSetPrototype.getName(LocaleUtil.getDefault()));
        this.groupPersistence.update((BaseModel)group, false);
        return layoutSetPrototype;
    }
}

