/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Address;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.AddressServiceBaseImpl;
import com.liferay.portal.service.permission.CommonPermissionUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressServiceImpl
extends AddressServiceBaseImpl {
    public Address addAddress(String className, long classPK, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, int typeId, boolean mailing, boolean primary) throws PortalException, SystemException {
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)className, (long)classPK, (String)"UPDATE");
        return this.addressLocalService.addAddress(this.getUserId(), className, classPK, street1, street2, street3, city, zip, regionId, countryId, typeId, mailing, primary);
    }

    public void deleteAddress(long addressId) throws PortalException, SystemException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)address.getClassNameId(), (long)address.getClassPK(), (String)"UPDATE");
        this.addressLocalService.deleteAddress(addressId);
    }

    public Address getAddress(long addressId) throws PortalException, SystemException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)address.getClassNameId(), (long)address.getClassPK(), (String)"VIEW");
        return address;
    }

    public List<Address> getAddresses(String className, long classPK) throws PortalException, SystemException {
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)className, (long)classPK, (String)"VIEW");
        return this.addressLocalService.getAddresses(this.getUser().getCompanyId(), className, classPK);
    }

    public Address updateAddress(long addressId, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, int typeId, boolean mailing, boolean primary) throws PortalException, SystemException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)address.getClassNameId(), (long)address.getClassPK(), (String)"UPDATE");
        return this.addressLocalService.updateAddress(addressId, street1, street2, street3, city, zip, regionId, countryId, typeId, mailing, primary);
    }
}

