/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.RoleServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(RoleServiceHttp.class);

    public static Role addRole(HttpPrincipal httpPrincipal, String name, Map<Locale, String> titleMap, String description, int type) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "addRole", new Class[]{String.class, Map.class, String.class, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{name, titleMap, description, type});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addUserRoles(HttpPrincipal httpPrincipal, long userId, long[] roleIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "addUserRoles", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, roleIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteRole(HttpPrincipal httpPrincipal, long roleId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "deleteRole", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getGroupRoles(HttpPrincipal httpPrincipal, long groupId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getGroupRoles", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Role getRole(HttpPrincipal httpPrincipal, long roleId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getRole", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Role getRole(HttpPrincipal httpPrincipal, long companyId, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getRole", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getUserGroupGroupRoles(HttpPrincipal httpPrincipal, long userId, long groupId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getUserGroupGroupRoles", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getUserGroupRoles(HttpPrincipal httpPrincipal, long userId, long groupId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getUserGroupRoles", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getUserRelatedRoles(HttpPrincipal httpPrincipal, long userId, List<Group> groups) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getUserRelatedRoles", new Class[]{Long.TYPE, List.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groups});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getUserRoles(HttpPrincipal httpPrincipal, long userId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getUserRoles", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserRole(HttpPrincipal httpPrincipal, long userId, long companyId, String name, boolean inherited) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "hasUserRole", new Class[]{Long.TYPE, Long.TYPE, String.class, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, companyId, name, inherited});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserRoles(HttpPrincipal httpPrincipal, long userId, long companyId, String[] names, boolean inherited) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "hasUserRoles", new Class[]{Long.TYPE, Long.TYPE, String[].class, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, companyId, names, inherited});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetUserRoles(HttpPrincipal httpPrincipal, long userId, long[] roleIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "unsetUserRoles", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, roleIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Role updateRole(HttpPrincipal httpPrincipal, long roleId, String name, Map<Locale, String> titleMap, String description, String subtype) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "updateRole", new Class[]{Long.TYPE, String.class, Map.class, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, name, titleMap, description, subtype});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

