/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.PortletPreferencesServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import javax.portlet.PortletPreferences;

public class PortletPreferencesServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(PortletPreferencesServiceHttp.class);

    public static void deleteArchivedPreferences(HttpPrincipal httpPrincipal, long portletItemId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PortletPreferencesServiceUtil.class.getName(), "deleteArchivedPreferences", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{portletItemId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void restoreArchivedPreferences(HttpPrincipal httpPrincipal, long groupId, String name, String portletId, PortletPreferences preferences) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PortletPreferencesServiceUtil.class.getName(), "restoreArchivedPreferences", new Class[]{Long.TYPE, String.class, String.class, PortletPreferences.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, portletId, preferences});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateArchivePreferences(HttpPrincipal httpPrincipal, long userId, long groupId, String name, String portletId, PortletPreferences preferences) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PortletPreferencesServiceUtil.class.getName(), "updateArchivePreferences", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, PortletPreferences.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId, name, portletId, preferences});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

