/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.model.Image;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageJSONSerializer {
    public static JSONObject toJSONObject(Image model) {
        JSONObject jsonObj = JSONFactoryUtil.createJSONObject();
        jsonObj.put("imageId", model.getImageId());
        Date modifiedDate = model.getModifiedDate();
        String modifiedDateJSON = "";
        if (modifiedDate != null) {
            modifiedDateJSON = String.valueOf(modifiedDate.getTime());
        }
        jsonObj.put("modifiedDate", modifiedDateJSON);
        jsonObj.put("text", model.getText());
        jsonObj.put("type", model.getType());
        jsonObj.put("height", model.getHeight());
        jsonObj.put("width", model.getWidth());
        jsonObj.put("size", model.getSize());
        return jsonObj;
    }

    public static JSONArray toJSONArray(Image[] models) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        Image[] imageArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            Image model = imageArray[n2];
            jsonArray.put(ImageJSONSerializer.toJSONObject(model));
            ++n2;
        }
        return jsonArray;
    }

    public static JSONArray toJSONArray(Image[][] models) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        Image[][] imageArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            Image[] model = imageArray[n2];
            jsonArray.put(ImageJSONSerializer.toJSONArray(model));
            ++n2;
        }
        return jsonArray;
    }

    public static JSONArray toJSONArray(List<Image> models) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Image model : models) {
            jsonArray.put(ImageJSONSerializer.toJSONObject(model));
        }
        return jsonArray;
    }
}

