/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageProcessorUtil;
import com.liferay.portal.kernel.image.SpriteProcessor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.LookupDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;
import javax.media.jai.operator.TranslateDescriptor;
import org.geotools.image.ImageWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpriteProcessorImpl
implements SpriteProcessor {
    private static final int _NUM_OF_BANDS = 4;
    private static Log _log;

    static {
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        _log = LogFactoryUtil.getLog(SpriteProcessorImpl.class);
    }

    public Properties generate(List<File> images, String spriteFileName, String spritePropertiesFileName, String spritePropertiesRootPath, int maxHeight, int maxWidth, int maxSize) throws IOException {
        if (images.size() < 1) {
            return null;
        }
        if (spritePropertiesRootPath.endsWith("/") || spritePropertiesRootPath.endsWith("\\")) {
            spritePropertiesRootPath = spritePropertiesRootPath.substring(0, spritePropertiesRootPath.length() - 1);
        }
        File dir = images.get(0).getParentFile();
        File spritePropertiesFile = new File(String.valueOf(dir.toString()) + "/" + spritePropertiesFileName);
        boolean build = false;
        long lastModified = 0L;
        if (spritePropertiesFile.exists()) {
            lastModified = spritePropertiesFile.lastModified();
            for (File image : images) {
                if (image.lastModified() <= lastModified) continue;
                build = true;
                break;
            }
        } else {
            build = true;
        }
        if (!build) {
            String spritePropertiesString = FileUtil.read((File)spritePropertiesFile);
            if (Validator.isNull((String)spritePropertiesString)) {
                return null;
            }
            return PropertiesUtil.load((String)spritePropertiesString);
        }
        ArrayList<RenderedImage> renderedImages = new ArrayList<RenderedImage>();
        SortedProperties spriteProperties = new SortedProperties();
        float x = 0.0f;
        float y = 0.0f;
        for (File file : images) {
            if (file.length() > (long)maxSize) continue;
            try {
                ImageBag imageBag = ImageProcessorUtil.read((File)file);
                RenderedImage renderedImage = imageBag.getRenderedImage();
                int height = renderedImage.getHeight();
                int width = renderedImage.getWidth();
                if (height > maxHeight || width > maxWidth) continue;
                renderedImage = this.convert(renderedImage);
                renderedImage = TranslateDescriptor.create((RenderedImage)renderedImage, (Float)Float.valueOf(x), (Float)Float.valueOf(y), null, null);
                renderedImages.add(renderedImage);
                String key = StringUtil.replace((String)file.toString(), (String)"\\", (String)"/");
                key = key.substring(spritePropertiesRootPath.toString().length());
                String value = String.valueOf((int)y) + "," + height + "," + width;
                spriteProperties.setProperty(key, value);
                y += (float)renderedImage.getHeight();
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to process " + file));
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        if (renderedImages.size() <= 1) {
            renderedImages.clear();
            spriteProperties.clear();
        } else {
            RenderedOp renderedImage = MosaicDescriptor.create((RenderedImage[])renderedImages.toArray(new RenderedImage[renderedImages.size()]), (MosaicType)MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, null, null, null);
            File spriteFile = new File(String.valueOf(dir.toString()) + "/" + spriteFileName);
            ImageIO.write((RenderedImage)renderedImage, "png", spriteFile);
            if (lastModified > 0L) {
                spriteFile.setLastModified(lastModified);
            }
            ImageWorker imageWorker = new ImageWorker((RenderedImage)renderedImage);
            imageWorker.forceIndexColorModelForGIF(true);
            renderedImage = imageWorker.getPlanarImage();
            spriteFile = new File(String.valueOf(dir.toString()) + "/" + StringUtil.replace((String)spriteFileName, (String)".png", (String)".gif"));
            FileOutputStream fos = new FileOutputStream(spriteFile);
            try {
                ImageProcessorUtil.encodeGIF((RenderedImage)renderedImage, (OutputStream)fos);
            }
            finally {
                fos.close();
            }
            if (lastModified > 0L) {
                spriteFile.setLastModified(lastModified);
            }
        }
        FileUtil.write((File)spritePropertiesFile, (String)PropertiesUtil.toString((Properties)spriteProperties));
        if (lastModified > 0L) {
            spritePropertiesFile.setLastModified(lastModified);
        }
        return spriteProperties;
    }

    protected RenderedImage convert(RenderedImage renderedImage) throws Exception {
        int height = renderedImage.getHeight();
        int width = renderedImage.getWidth();
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        Raster raster = renderedImage.getData();
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int mapSize = indexColorModel.getMapSize();
            byte[][] data = new byte[4][mapSize];
            indexColorModel.getReds(data[0]);
            indexColorModel.getGreens(data[1]);
            indexColorModel.getBlues(data[2]);
            indexColorModel.getAlphas(data[3]);
            LookupTableJAI lookupTableJAI = new LookupTableJAI(data);
            renderedImage = LookupDescriptor.create((RenderedImage)renderedImage, (LookupTableJAI)lookupTableJAI, null);
        } else if (sampleModel.getNumBands() == 2) {
            ArrayList bytesList = new ArrayList(height * width * 4);
            ArrayList<Byte> tempBytesList = new ArrayList<Byte>(4);
            int i = 0;
            while (i < dataBuffer.getSize()) {
                int mod = (i + 1) % 2;
                int elemPos = i;
                if (mod == 0) {
                    tempBytesList.add((byte)dataBuffer.getElem(elemPos - 1));
                    tempBytesList.add((byte)dataBuffer.getElem(elemPos - 1));
                }
                tempBytesList.add((byte)dataBuffer.getElem(elemPos));
                if (mod == 0) {
                    Collections.reverse(tempBytesList);
                    bytesList.addAll(tempBytesList);
                    tempBytesList.clear();
                }
                ++i;
            }
            byte[] data = ArrayUtil.toArray((Byte[])bytesList.toArray(new Byte[bytesList.size()]));
            DataBufferByte newDataBuffer = new DataBufferByte(data, data.length);
            renderedImage = this.createRenderedImage(renderedImage, height, width, newDataBuffer);
        } else if (colorModel.getTransparency() != 3) {
            ArrayList bytesList = new ArrayList(height * width * 4);
            ArrayList<Byte> tempBytesList = new ArrayList<Byte>(4);
            int i = 0;
            while (i < dataBuffer.getSize()) {
                int mod = (i + 1) % 3;
                int elemPos = i;
                tempBytesList.add((byte)dataBuffer.getElem(elemPos));
                if (mod == 0) {
                    tempBytesList.add((byte)-1);
                    Collections.reverse(tempBytesList);
                    bytesList.addAll(tempBytesList);
                    tempBytesList.clear();
                }
                ++i;
            }
            byte[] data = ArrayUtil.toArray((Byte[])bytesList.toArray(new Byte[bytesList.size()]));
            DataBufferByte newDataBuffer = new DataBufferByte(data, data.length);
            renderedImage = this.createRenderedImage(renderedImage, height, width, newDataBuffer);
        }
        return renderedImage;
    }

    protected RenderedImage createRenderedImage(RenderedImage renderedImage, int height, int width, DataBuffer dataBuffer) {
        SampleModel sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)0, (int)width, (int)height, (int)4);
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        TiledImage tiledImage = new TiledImage(0, 0, width, height, 0, 0, sampleModel, colorModel);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, (DataBuffer)dataBuffer, (Point)new Point(0, 0));
        tiledImage.setData((Raster)raster);
        return tiledImage;
    }

    protected void printImage(RenderedImage renderedImage) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int height = renderedImage.getHeight();
        int width = renderedImage.getWidth();
        int numOfBands = sampleModel.getNumBands();
        int[] pixels = new int[height * width * numOfBands];
        Raster raster = renderedImage.getData();
        raster.getPixels(0, 0, width, height, pixels);
        int offset = 0;
        int h = 0;
        while (h < height) {
            int w = 0;
            while (w < width) {
                offset = h * width * numOfBands + w * numOfBands;
                System.out.print("[" + w + ", " + h + "] = ");
                int b = 0;
                while (b < numOfBands) {
                    System.out.print(String.valueOf(pixels[offset + b]) + " ");
                    ++b;
                }
                ++w;
            }
            System.out.println();
            ++h;
        }
    }
}

