/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.CacheWrapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Properties;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;

public class CacheProviderWrapper
implements CacheProvider {
    protected CacheProvider cacheProvider;
    private static Log _log = LogFactoryUtil.getLog(CacheProviderWrapper.class);

    public CacheProviderWrapper(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public CacheProviderWrapper(String cacheProviderClassName) {
        try {
            this.cacheProvider = (CacheProvider)Class.forName(cacheProviderClassName).newInstance();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        return new CacheWrapper(this.cacheProvider.buildCache(regionName, properties));
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return this.cacheProvider.isMinimalPutsEnabledByDefault();
    }

    public long nextTimestamp() {
        return this.cacheProvider.nextTimestamp();
    }

    public void start(Properties properties) throws CacheException {
        this.cacheProvider.start(properties);
    }

    public void stop() {
        this.cacheProvider.stop();
    }
}

