/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert;

import com.liferay.mail.model.CyrusUser;
import com.liferay.mail.model.CyrusVirtual;
import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.dao.jdbc.util.DataSourceFactoryBean;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.upgrade.util.Table;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.ShutdownUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertDatabase
extends ConvertProcess {
    private static final String _JDBC_PREFIX = "jdbc.upgrade.";
    private static final Tuple[] _UNMAPPED_TABLES = new Tuple[]{new Tuple(new Object[]{CyrusUser.TABLE_NAME, CyrusUser.TABLE_COLUMNS, "create table CyrusUser (userId VARCHAR(75) not null primary key, password_ VARCHAR(75) not null)"}), new Tuple(new Object[]{CyrusVirtual.TABLE_NAME, CyrusVirtual.TABLE_COLUMNS, "create table CyrusVirtual (emailAddress VARCHAR(75) not null primary key, userId VARCHAR(75) not null)"})};
    private static Log _log = LogFactoryUtil.getLog(ConvertDatabase.class);

    @Override
    public String getDescription() {
        return "migrate-data-from-one-database-to-another";
    }

    @Override
    public String getParameterDescription() {
        return "please-enter-jdbc-information-for-new-database";
    }

    @Override
    public String[] getParameterNames() {
        return new String[]{"jdbc-driver-class-name", "jdbc-url", "jdbc-user-name", "jdbc-password"};
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doConvert() throws Exception {
        DataSource dataSource = this.getDataSource();
        Dialect dialect = DialectDetector.getDialect(dataSource);
        DB db = DBFactoryUtil.getDB((Object)dialect);
        List modelNames = ModelHintsUtil.getModels();
        ArrayList<Tuple> tableDetails = new ArrayList<Tuple>();
        Connection connection = dataSource.getConnection();
        try {
            Object implClass;
            MaintenanceUtil.appendStatus("Collecting information for database tables to migration");
            for (String modelName : modelNames) {
                Field[] fields;
                if (!modelName.contains(".model.")) continue;
                String implClassName = modelName.replaceFirst("(\\.model\\.)(\\p{Upper}.*)", "$1impl.$2Impl");
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Loading class " + implClassName));
                }
                if ((implClass = this.getImplClass(implClassName)) == null) {
                    _log.error((Object)("Unable to load class " + implClassName));
                    continue;
                }
                Field[] fieldArray = fields = ((Class)implClass).getFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    Tuple tuple = null;
                    String fieldName = field.getName();
                    if (fieldName.equals("TABLE_NAME")) {
                        tuple = this.getTableDetails((Class<?>)implClass, field, fieldName);
                    } else if (fieldName.startsWith("MAPPING_TABLE_") && fieldName.endsWith("_NAME")) {
                        tuple = this.getTableDetails((Class<?>)implClass, field, fieldName);
                    }
                    if (tuple != null) {
                        tableDetails.add(tuple);
                    }
                    ++n2;
                }
            }
            implClass = _UNMAPPED_TABLES;
            int implClassName = _UNMAPPED_TABLES.length;
            int n = 0;
            while (n < implClassName) {
                Tuple tuple = implClass[n];
                tableDetails.add(tuple);
                ++n;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Migrating database tables");
            }
            int i = 0;
            while (i < tableDetails.size()) {
                if (i > 0 && i % (tableDetails.size() / 4) == 0) {
                    MaintenanceUtil.appendStatus(String.valueOf(i * 100 / tableDetails.size()) + "%");
                }
                Tuple tuple = (Tuple)tableDetails.get(i);
                String table = (String)tuple.getObject(0);
                Object[][] columns = (Object[][])tuple.getObject(1);
                String sqlCreate = (String)tuple.getObject(2);
                this.migrateTable(db, connection, table, columns, sqlCreate);
                ++i;
            }
        }
        finally {
            DataAccess.cleanUp((Connection)connection);
        }
        MaintenanceUtil.appendStatus("Please change your JDBC settings before restarting server");
        ShutdownUtil.shutdown(0L);
    }

    protected DataSource getDataSource() throws Exception {
        String[] values = this.getParameterValues();
        String jdbcDriverClassName = values[0];
        String jdbcURL = values[1];
        String jdbcUserName = values[2];
        String jdbcPassword = values[3];
        Properties properties = new Properties();
        properties.setProperty("jdbc.upgrade.driverClassName", jdbcDriverClassName);
        properties.setProperty("jdbc.upgrade.url", jdbcURL);
        properties.setProperty("jdbc.upgrade.username", jdbcUserName);
        properties.setProperty("jdbc.upgrade.password", jdbcPassword);
        DataSourceFactoryBean dataSourceFactory = new DataSourceFactoryBean();
        dataSourceFactory.setProperties(properties);
        dataSourceFactory.setPropertyPrefix(_JDBC_PREFIX);
        return dataSourceFactory.createInstance();
    }

    /*
     * Unable to fully structure code
     */
    public Class<?> getImplClass(String implClassName) throws Exception {
        try {
            classLoader = PortalClassLoaderUtil.getClassLoader();
            return classLoader.loadClass(implClassName);
        }
        catch (Exception v0) {
            ** for (servletContextName : ServletContextPool.keySet())
        }
lbl-1000:
        // 1 sources

        {
            try {
                servletContext = ServletContextPool.get((String)servletContextName);
                classLoader = (ClassLoader)servletContext.getAttribute("PORTLET_CLASS_LOADER");
                return classLoader.loadClass(implClassName);
            }
            catch (Exception v1) {}
            continue;
        }
lbl12:
        // 1 sources

        return null;
    }

    protected Tuple getTableDetails(Class<?> implClass, Field tableField, String tableFieldVar) {
        try {
            String columnsFieldVar = StringUtil.replace((String)tableFieldVar, (String)"_NAME", (String)"_COLUMNS");
            String sqlCreateFieldVar = StringUtil.replace((String)tableFieldVar, (String)"_NAME", (String)"_SQL_CREATE");
            Field columnsField = implClass.getField(columnsFieldVar);
            Field sqlCreateField = implClass.getField(sqlCreateFieldVar);
            String table = (String)tableField.get("");
            Object[][] columns = (Object[][])columnsField.get(new Object[0][0]);
            String sqlCreate = (String)sqlCreateField.get("");
            return new Tuple(new Object[]{table, columns, sqlCreate});
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void migrateTable(DB db, Connection connection, String tableName, Object[][] columns, String sqlCreate) throws Exception {
        Table table = new Table(tableName, columns);
        String tempFileName = table.generateTempFile();
        db.runSQL(connection, sqlCreate);
        if (tempFileName != null) {
            table.populateTable(tempFileName, connection);
        }
    }
}

