/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration;

import com.germinus.easyconf.AggregatedProperties;
import com.germinus.easyconf.ComponentConfiguration;
import com.germinus.easyconf.ComponentProperties;
import com.germinus.easyconf.EasyConf;
import com.germinus.easyconf.Filter;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.MapConfiguration;

public class ConfigurationImpl
implements Configuration {
    private static final boolean _PRINT_DUPLICATE_CALLS_TO_GET = false;
    private static Log _log = LogFactoryUtil.getLog(ConfigurationImpl.class);
    private ComponentConfiguration _componentConfiguration;
    private Set<String> _keys = new HashSet<String>();
    private Set<String> _printedSources = new HashSet<String>();

    public ConfigurationImpl(ClassLoader classLoader, String name) {
        this(classLoader, name, 0L);
    }

    public ConfigurationImpl(ClassLoader classLoader, String name, long companyId) {
        try {
            URL url = classLoader.getResource(String.valueOf(name) + ".properties");
            if (url != null && url.getProtocol().equals("file")) {
                String basePath = url.getPath();
                int pos = name.lastIndexOf("/" + name + ".properties");
                if (pos != -1) {
                    basePath = basePath.substring(0, pos);
                }
                Properties properties = new Properties();
                properties.load(url.openStream());
                if (!properties.containsKey("base.path")) {
                    String fileName = StringUtil.replace((String)url.getFile(), (String)"%20", (String)" ");
                    FileWriter writer = new FileWriter(fileName, true);
                    writer.write("\n\nbase.path=".concat(basePath));
                    ((Writer)writer).close();
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        String webId = null;
        if (companyId > 0L) {
            try {
                Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
                webId = company.getWebId();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        this._componentConfiguration = webId != null ? EasyConf.getConfiguration((String)webId, (String)this.getFileName(classLoader, name)) : EasyConf.getConfiguration((String)this.getFileName(classLoader, name));
        this.printSources(companyId, webId);
    }

    public void addProperties(Properties properties) {
        try {
            ComponentProperties componentProperties = this._componentConfiguration.getProperties();
            AggregatedProperties aggregatedProperties = (AggregatedProperties)componentProperties.toConfiguration();
            Field field1 = CompositeConfiguration.class.getDeclaredField("configList");
            field1.setAccessible(true);
            List configurations = (List)field1.get(aggregatedProperties);
            MapConfiguration newConfiguration = new MapConfiguration((Map)properties);
            configurations.add(0, newConfiguration);
            Field field2 = aggregatedProperties.getClass().getDeclaredField("baseConf");
            field2.setAccessible(true);
            CompositeConfiguration compositeConfiguration = (CompositeConfiguration)field2.get(aggregatedProperties);
            configurations = (List)field1.get(compositeConfiguration);
            configurations.add(0, newConfiguration);
        }
        catch (Exception e) {
            _log.error((Object)"The properties could not be added", (Throwable)e);
        }
    }

    public boolean contains(String key) {
        return this.getComponentProperties().containsKey(key);
    }

    public String get(String key) {
        return this.getComponentProperties().getString(key);
    }

    public String get(String key, com.liferay.portal.kernel.configuration.Filter filter) {
        return this.getComponentProperties().getString(key, this.getEasyConfFilter(filter));
    }

    public String[] getArray(String key) {
        String[] array = this.getComponentProperties().getStringArray(key);
        if (array == null) {
            return new String[0];
        }
        if (array.length > 0 && Validator.isNull((String)array[array.length - 1])) {
            String[] subArray = new String[array.length - 1];
            System.arraycopy(array, 0, subArray, 0, subArray.length);
            array = subArray;
        }
        return array;
    }

    public String[] getArray(String key, com.liferay.portal.kernel.configuration.Filter filter) {
        return this.getComponentProperties().getStringArray(key, this.getEasyConfFilter(filter));
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        ComponentProperties componentProperties = this.getComponentProperties();
        for (Map.Entry<Object, Object> entry : componentProperties.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            properties.setProperty(key, value);
        }
        return properties;
    }

    public Properties getProperties(String prefix, boolean removePrefix) {
        Properties allProperties = this.getProperties();
        return PropertiesUtil.getProperties((Properties)allProperties, (String)prefix, (boolean)removePrefix);
    }

    public void removeProperties(Properties properties) {
        try {
            ComponentProperties componentProperties = this._componentConfiguration.getProperties();
            AggregatedProperties aggregatedProperties = (AggregatedProperties)componentProperties.toConfiguration();
            Field field1 = aggregatedProperties.getClass().getDeclaredField("baseConf");
            field1.setAccessible(true);
            CompositeConfiguration compositeConfiguration = (CompositeConfiguration)field1.get(aggregatedProperties);
            Field field2 = CompositeConfiguration.class.getDeclaredField("configList");
            field2.setAccessible(true);
            List configurations = (List)field2.get(compositeConfiguration);
            Iterator itr = configurations.iterator();
            while (itr.hasNext()) {
                org.apache.commons.configuration.Configuration configuration = (org.apache.commons.configuration.Configuration)itr.next();
                if (!(configuration instanceof MapConfiguration)) {
                    return;
                }
                MapConfiguration mapConfiguration = (MapConfiguration)configuration;
                if (mapConfiguration.getMap() != properties) continue;
                itr.remove();
                aggregatedProperties.removeConfiguration(configuration);
            }
        }
        catch (Exception e) {
            _log.error((Object)"The properties could not be removed", (Throwable)e);
        }
    }

    public void set(String key, String value) {
        this.getComponentProperties().setProperty(key, (Object)value);
    }

    protected ComponentProperties getComponentProperties() {
        return this._componentConfiguration.getProperties();
    }

    protected Filter getEasyConfFilter(com.liferay.portal.kernel.configuration.Filter filter) {
        Filter easyConfFilter = Filter.by((String[])filter.getSelectors());
        if (filter.getVariables() != null) {
            easyConfFilter.setVariables(filter.getVariables());
        }
        return easyConfFilter;
    }

    protected String getFileName(ClassLoader classLoader, String name) {
        URL url = classLoader.getResource(String.valueOf(name) + ".properties");
        String protocol = url.getProtocol();
        if (protocol.equals("code-source") || protocol.equals("jar") || protocol.equals("vfsfile") || protocol.equals("vfszip") || protocol.equals("wsjar") || protocol.equals("zip")) {
            name = url.toExternalForm();
        } else {
            try {
                name = new URI(url.getPath()).getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                name = url.getFile();
            }
        }
        int pos = name.lastIndexOf(".properties");
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        return name;
    }

    protected void printSources(long companyId, String webId) {
        List sources = this.getComponentProperties().getLoadedSources();
        int i = sources.size() - 1;
        while (i >= 0) {
            String source = (String)sources.get(i);
            if (!this._printedSources.contains(source)) {
                this._printedSources.add(source);
                String info = "Loading " + source;
                if (companyId > 0L) {
                    info = String.valueOf(info) + " for {companyId=" + companyId + ", webId=" + webId + "}";
                }
                System.out.println(info);
            }
            --i;
        }
    }
}

