/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.AddressImpl;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.IPDetector;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.SocketUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClusterBase {
    private static Log _log = LogFactoryUtil.getLog(ClusterBase.class);
    private static boolean _initialized;
    protected InetAddress bindInetAddress;

    public void afterPropertiesSet() {
        if (!this.isEnabled()) {
            return;
        }
        if (!_initialized) {
            block8: {
                if (OSDetector.isUnix() && IPDetector.isSupportsV6() && !IPDetector.isPrefersV4() && _log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler(4);
                    sb.append("You are on an Unix server with IPv6 enabled. JGroups ");
                    sb.append("may not work with IPv6. If you see a multicast ");
                    sb.append("error, try adding java.net.preferIPv4Stack=true ");
                    sb.append("as a JVM startup parameter.");
                    _log.warn((Object)sb.toString());
                }
                this.initSystemProperties();
                try {
                    this.initBindAddress();
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)"Failed to initialize outgoing IP address", (Throwable)ioe);
                }
            }
            _initialized = true;
        }
        try {
            this.initChannels();
        }
        catch (Exception e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)"Unable to initialize channels", (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
    }

    public abstract void destroy();

    public boolean isEnabled() {
        return PropsValues.CLUSTER_LINK_ENABLED;
    }

    protected JChannel createJChannel(String properties, Receiver receiver, String clusterName) throws ChannelException {
        JChannel jChannel = new JChannel(properties);
        jChannel.setReceiver(receiver);
        jChannel.connect(clusterName);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Create a new channel with properties " + jChannel.getProperties()));
        }
        return jChannel;
    }

    protected List<Address> getAddresses(JChannel channel) {
        View view = channel.getView();
        Vector jGroupsAddresses = view.getMembers();
        if (jGroupsAddresses == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Address> addresses = new ArrayList<Address>(jGroupsAddresses.size());
        for (org.jgroups.Address jgroupsAddress : jGroupsAddresses) {
            addresses.add(new AddressImpl(jgroupsAddress));
        }
        return addresses;
    }

    protected void initBindAddress() throws IOException {
        String autodetectAddress = PropsValues.CLUSTER_LINK_AUTODETECT_ADDRESS;
        if (Validator.isNull((String)autodetectAddress)) {
            return;
        }
        String host = autodetectAddress;
        int port = 80;
        int index = autodetectAddress.indexOf(58);
        if (index != -1) {
            host = autodetectAddress.substring(0, index);
            port = GetterUtil.getInteger((String)autodetectAddress.substring(index + 1), (int)port);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Autodetecting JGroups outgoing IP address and interface for " + host + ":" + port));
        }
        SocketUtil.BindInfo bindInfo = SocketUtil.getBindInfo((String)host, (int)port);
        this.bindInetAddress = bindInfo.getInetAddress();
        NetworkInterface networkInterface = bindInfo.getNetworkInterface();
        System.setProperty("jgroups.bind_addr", this.bindInetAddress.getHostAddress());
        System.setProperty("jgroups.bind_interface", networkInterface.getName());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Setting JGroups outgoing IP address to " + this.bindInetAddress.getHostAddress() + " and interface to " + networkInterface.getName()));
        }
    }

    protected abstract void initChannels() throws ChannelException;

    protected void initSystemProperties() {
        String[] stringArray = PropsValues.CLUSTER_LINK_CHANNEL_SYSTEM_PROPERTIES;
        int n = PropsValues.CLUSTER_LINK_CHANNEL_SYSTEM_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String systemProperty = stringArray[n2];
            int index = systemProperty.indexOf(58);
            if (index != -1) {
                String key = systemProperty.substring(0, index);
                String value = systemProperty.substring(index + 1);
                System.setProperty(key, value);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Setting system property {key=" + key + ", value=" + value + "}"));
                }
            }
            ++n2;
        }
    }
}

