/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.uri;

import java.net.URI;
import java.util.List;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.uri.HttpMint;
import org.gcube.common.uri.Mint;

public class ScopedMint
implements Mint {
    private static final String SCOPE_PARAM_PREFIX = "scope=";
    private final Mint mint;

    public ScopedMint() {
        this(new HttpMint());
    }

    public ScopedMint(Mint mint) {
        this.mint = mint;
    }

    @Override
    public URI mint(List<String> elements) {
        URI uri = this.mint.mint(elements);
        String scope = ScopeProvider.instance.get();
        if (scope == null || scope.isEmpty()) {
            throw new IllegalStateException("cannot mint a URI outside a scope");
        }
        String query = uri.getQuery();
        String param = SCOPE_PARAM_PREFIX + scope;
        query = query == null ? param : query + "&" + param;
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
        }
        catch (Exception e) {
            throw new RuntimeException("resource path is invalid", e);
        }
    }
}

