/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.compass.core.Compass;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.spi.InternalCompass;
import org.compass.core.transaction.TransactionFactory;
import org.compass.core.util.FieldInvoker;
import org.hibernate.CallbackException;
import org.hibernate.EntityMode;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.type.Type;

public class CompassTransactionInterceptor
implements Interceptor {
    private Interceptor interceptor;
    private InternalCompass compass;
    private TransactionFactory transactionFactory;
    private boolean commitBeforeTransactionCompletion = true;
    private ConcurrentHashMap activeTransactions = new ConcurrentHashMap();

    public static void injectInterceptor(SessionFactory sessionFactory, CompassTransactionInterceptor interceptor) throws Exception {
        FieldInvoker interceptorField = new FieldInvoker(sessionFactory.getClass(), "interceptor").prepare();
        Interceptor origInterceptor = (Interceptor)interceptorField.get(sessionFactory);
        interceptor.setInterceptor(origInterceptor);
        interceptorField.set(sessionFactory, interceptor);
    }

    public CompassTransactionInterceptor(Compass compass) {
        this(compass, true, null);
    }

    public CompassTransactionInterceptor(Compass compass, boolean commitBeforeTransactionCompletion, Interceptor interceptor) {
        this.commitBeforeTransactionCompletion = commitBeforeTransactionCompletion;
        this.compass = (InternalCompass)compass;
        this.interceptor = interceptor;
        this.transactionFactory = this.compass.getTransactionFactory();
    }

    void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void afterTransactionBegin(Transaction transaction) {
        CompassSession session;
        if (this.interceptor != null) {
            this.interceptor.afterTransactionBegin(transaction);
        }
        if ((session = this.transactionFactory.getTransactionBoundSession()) != null) {
            return;
        }
        if (this.activeTransactions.get(transaction) != null) {
            return;
        }
        session = this.compass.openSession();
        CompassTransaction tr = session.beginTransaction();
        this.activeTransactions.put(transaction, tr);
    }

    public void beforeTransactionCompletion(Transaction transaction) {
        if (this.interceptor != null) {
            this.interceptor.beforeTransactionCompletion(transaction);
        }
        if (!this.commitBeforeTransactionCompletion) {
            return;
        }
        CompassTransaction tr = (CompassTransaction)this.activeTransactions.remove(transaction);
        if (tr == null) {
            return;
        }
        CompassSession session = this.transactionFactory.getTransactionBoundSession();
        tr.commit();
        session.close();
    }

    public void afterTransactionCompletion(Transaction transaction) {
        if (this.interceptor != null) {
            this.interceptor.afterTransactionCompletion(transaction);
        }
        if (this.commitBeforeTransactionCompletion) {
            return;
        }
        CompassTransaction tr = (CompassTransaction)this.activeTransactions.remove(transaction);
        if (tr == null) {
            return;
        }
        CompassSession session = this.transactionFactory.getTransactionBoundSession();
        tr.commit();
        session.close();
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (this.interceptor != null) {
            this.interceptor.onDelete(entity, id, state, propertyNames, types);
        }
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        if (this.interceptor != null) {
            return this.interceptor.onFlushDirty(entity, id, currentState, previousState, propertyNames, types);
        }
        return false;
    }

    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (this.interceptor != null) {
            return this.interceptor.onLoad(entity, id, state, propertyNames, types);
        }
        return false;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (this.interceptor != null) {
            return this.interceptor.onSave(entity, id, state, propertyNames, types);
        }
        return false;
    }

    public void postFlush(Iterator entities) {
        if (this.interceptor != null) {
            this.interceptor.postFlush(entities);
        }
    }

    public void preFlush(Iterator entities) {
        if (this.interceptor != null) {
            this.interceptor.preFlush(entities);
        }
    }

    public Boolean isTransient(Object entity) {
        if (this.interceptor != null) {
            return this.interceptor.isTransient(entity);
        }
        return null;
    }

    public Object instantiate(String entityName, EntityMode entityMode, Serializable id) {
        if (this.interceptor != null) {
            return this.interceptor.instantiate(entityName, entityMode, id);
        }
        return null;
    }

    public int[] findDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        if (this.interceptor != null) {
            return this.interceptor.findDirty(entity, id, currentState, previousState, propertyNames, types);
        }
        return null;
    }

    public String getEntityName(Object object) {
        if (this.interceptor != null) {
            return this.interceptor.getEntityName(object);
        }
        return null;
    }

    public Object getEntity(String entityName, Serializable id) {
        if (this.interceptor != null) {
            return this.interceptor.getEntity(entityName, id);
        }
        return null;
    }

    public String onPrepareStatement(String sql) {
        if (this.interceptor != null) {
            return this.interceptor.onPrepareStatement(sql);
        }
        return sql;
    }

    public void onCollectionRemove(Object collection, Serializable key) throws CallbackException {
        if (this.interceptor != null) {
            this.interceptor.onCollectionRemove(collection, key);
        }
    }

    public void onCollectionRecreate(Object collection, Serializable key) throws CallbackException {
        if (this.interceptor != null) {
            this.interceptor.onCollectionRecreate(collection, key);
        }
    }

    public void onCollectionUpdate(Object collection, Serializable key) throws CallbackException {
        if (this.interceptor != null) {
            this.interceptor.onCollectionUpdate(collection, key);
        }
    }
}

