/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.support.job;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionJobs
implements Serializable {
    private List<TransactionJob> jobs = new ArrayList<TransactionJob>();
    private Set<String> subIndexes = new HashSet<String>();

    public void add(TransactionJob job) {
        this.jobs.add(job);
        this.subIndexes.add(job.getSubIndex());
    }

    public List<TransactionJob> getJobs() {
        return this.jobs;
    }

    public Set<String> getSubIndexes() {
        return this.subIndexes;
    }

    public Map<String, TransactionJobs> buildJobsPerSubIndex() {
        HashMap<String, TransactionJobs> jobsPerSubIndex = new HashMap<String, TransactionJobs>();
        for (TransactionJob job : this.jobs) {
            TransactionJobs jobs = (TransactionJobs)jobsPerSubIndex.get(job.getSubIndex());
            if (jobs == null) {
                jobs = new TransactionJobs();
                jobsPerSubIndex.put(job.getSubIndex(), jobs);
            }
            jobs.add(job);
        }
        return jobsPerSubIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TransactionJob job : this.jobs) {
            sb.append(job).append(", ");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionJobs that = (TransactionJobs)o;
        if (this.subIndexes != null ? !((Object)this.subIndexes).equals(that.subIndexes) : that.subIndexes != null) {
            return false;
        }
        return !(this.jobs != null ? !((Object)this.jobs).equals(that.jobs) : that.jobs != null);
    }

    public int hashCode() {
        int result = this.jobs != null ? ((Object)this.jobs).hashCode() : 0;
        result = 31 * result + (this.subIndexes != null ? ((Object)this.subIndexes).hashCode() : 0);
        return result;
    }
}

