/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.lucene.store.jdbc.datasource.AbstractDataSource;
import org.compass.core.CompassException;
import org.compass.core.config.CompassSettings;
import org.compass.core.lucene.engine.store.jdbc.AbstractDataSourceProvider;

public class ExternalDataSourceProvider
extends AbstractDataSourceProvider {
    private static ThreadLocal dataSourceHolder = new ThreadLocal();
    private static String dataSourceKey = ExternalDataSourceProvider.class.getName();
    private CompassSettings settings;

    public static void setDataSource(DataSource dataSource) {
        dataSourceHolder.set(dataSource);
    }

    protected DataSource doCreateDataSource(String url, CompassSettings settings) throws CompassException {
        this.settings = settings;
        DataSource dataSource = (DataSource)dataSourceHolder.get();
        if (dataSource == null) {
            dataSource = (DataSource)settings.getRegistry(dataSourceKey);
        }
        if (dataSource == null) {
            throw new CompassException("Failed to find data source, have you set the static set data source?");
        }
        settings.setRegistry(dataSourceKey, dataSource);
        dataSourceHolder.set(null);
        return new UsernamePasswordDataSourceWrapper(dataSource, this.username, this.password, this.autoCommit, this.externalAutoCommit);
    }

    public void closeDataSource() {
        dataSourceHolder.set(null);
        this.settings.removeRegistry(dataSourceKey);
    }

    private static class UsernamePasswordDataSourceWrapper
    extends AbstractDataSource {
        private DataSource dataSource;
        private String username;
        private String password;
        private boolean autoCommit;
        private boolean externalAutoCommit;

        public UsernamePasswordDataSourceWrapper(DataSource dataSource, String username, String password, boolean autoCommit, boolean externalAutoCommit) {
            this.dataSource = dataSource;
            this.username = username;
            this.password = password;
            this.autoCommit = autoCommit;
            this.externalAutoCommit = externalAutoCommit;
        }

        public Connection getConnection() throws SQLException {
            return this.getConnection(this.username, this.password);
        }

        public Connection getConnection(String username, String password) throws SQLException {
            Connection conn = username == null ? this.dataSource.getConnection() : this.dataSource.getConnection(username, password);
            if (!this.externalAutoCommit && conn.getAutoCommit() != this.autoCommit) {
                conn.setAutoCommit(this.autoCommit);
            }
            return conn;
        }
    }
}

