/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.dynamic;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.dynamic.AbstractDynamicConverter;
import org.compass.core.converter.dynamic.ExpressionEvaluator;
import org.compass.core.converter.dynamic.ExpressionEvaluatorFactory;
import org.compass.core.converter.dynamic.ThreadSafeExpressionEvaluator;
import org.compass.core.mapping.ResourcePropertyMapping;

public class GroovyDynamicConverter
extends AbstractDynamicConverter {
    private String expression;
    private ThreadSafeExpressionEvaluator expressionEvaluator;

    public void setExpression(String expression) throws ConversionException {
        this.expression = expression;
        this.expressionEvaluator = new ThreadSafeExpressionEvaluator(10, 20, new ExpressionEvaluatorFactory(){

            public ExpressionEvaluator create() throws ConversionException {
                return new GroovyExpressionEvaluator();
            }
        });
    }

    protected Object evaluate(Object o, ResourcePropertyMapping resourcePropertyMapping) throws ConversionException {
        return this.expressionEvaluator.evaluate(o, resourcePropertyMapping);
    }

    public class GroovyExpressionEvaluator
    implements ExpressionEvaluator {
        private Script script;

        public GroovyExpressionEvaluator() {
            this.script = new GroovyShell().parse(GroovyDynamicConverter.this.expression);
        }

        public Object evaluate(Object o, ResourcePropertyMapping resourcePropertyMapping) throws ConversionException {
            Binding binding = new Binding();
            binding.setVariable("data", o);
            this.script.setBinding(binding);
            try {
                return this.script.run();
            }
            catch (Exception e) {
                throw new ConversionException("Failed to evaluate [" + o + "] with expression [" + GroovyDynamicConverter.this.expression + "]", e);
            }
        }
    }
}

