/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.portlet;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import org.portletbridge.portlet.BridgeAuthenticator;
import org.portletbridge.portlet.BridgeRequest;
import org.portletbridge.portlet.DefaultBridgeRequest;
import org.portletbridge.portlet.DefaultPerPortletMemento;
import org.portletbridge.portlet.PerPortletMemento;
import org.portletbridge.portlet.PortletBridgeMemento;

public class DefaultPortletBridgeMemento
implements PortletBridgeMemento,
Serializable {
    private static final long serialVersionUID = -5751042731400361166L;
    private Map idToRequests = new HashMap();
    private Map dataToRequests = new HashMap();
    private Map mementos = new HashMap();
    private final String idParamKey;
    private final BridgeAuthenticator bridgeAuthenticator;

    public DefaultPortletBridgeMemento(String idParamKey, BridgeAuthenticator bridgeAuthenticator) {
        this.idParamKey = idParamKey;
        this.bridgeAuthenticator = bridgeAuthenticator;
    }

    public BridgeRequest getBridgeRequest(String id) {
        return (BridgeRequest)this.idToRequests.get(id);
    }

    public PerPortletMemento getPerPortletMemento(String portletId) {
        PerPortletMemento memento = (PerPortletMemento)this.mementos.get(portletId);
        if (memento == null) {
            memento = new DefaultPerPortletMemento(this.bridgeAuthenticator);
            this.mementos.put(portletId, memento);
        }
        return memento;
    }

    public BridgeRequest createBridgeRequest(RenderResponse response, String id, URI url) {
        PortletURL pageUrl = response.createRenderURL();
        String namespace = response.getNamespace();
        String key = namespace + pageUrl.toString() + url.toString();
        BridgeRequest request = (BridgeRequest)this.dataToRequests.get(key);
        if (request != null) {
            return request;
        }
        pageUrl.setParameter(this.idParamKey, id);
        DefaultBridgeRequest bridgeRequest = new DefaultBridgeRequest(id, namespace, pageUrl.toString(), url);
        this.idToRequests.put(id, bridgeRequest);
        this.dataToRequests.put(key, bridgeRequest);
        return bridgeRequest;
    }
}

