/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.spring;

import java.lang.reflect.Constructor;
import java.util.Collection;
import javax.security.auth.Subject;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.Filter;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.impl.DefaultProvider;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderFactoryBean
implements FactoryBean {
    private Class<? extends DefaultProvider> providerClass = DefaultProvider.class;
    private String base;
    private Collection<WorkspaceInfo> workspaces;
    private Resolver<Target> targetResolver;
    private Resolver<Subject> subjectResolver;
    private Filter[] filters;

    public Object getObject() throws Exception {
        DefaultProvider p = null;
        if (this.base != null) {
            Constructor<? extends DefaultProvider> constructor = this.providerClass.getConstructor(String.class);
            p = constructor.newInstance(this.base);
        } else {
            p = this.providerClass.newInstance();
        }
        if (this.workspaces != null && this.workspaces.size() > 0) {
            p.addWorkspaces(this.workspaces);
        }
        if (this.targetResolver != null) {
            p.setTargetResolver(this.targetResolver);
        }
        if (this.subjectResolver != null) {
            p.setSubjectResolver(this.subjectResolver);
        }
        if (this.filters != null && this.filters.length > 0) {
            p.addFilter(this.filters);
        }
        return p;
    }

    public Class getObjectType() {
        return this.providerClass;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class getProviderClass() {
        return this.providerClass;
    }

    public void setProviderClass(Class providerClass) {
        this.providerClass = providerClass;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public Collection<WorkspaceInfo> getWorkspaces() {
        return this.workspaces;
    }

    public void setWorkspaces(Collection<WorkspaceInfo> workspaces) {
        this.workspaces = workspaces;
    }

    public Resolver<Target> getTargetResolver() {
        return this.targetResolver;
    }

    public void setTargetResolver(Resolver<Target> targetResolver) {
        this.targetResolver = targetResolver;
    }

    public Resolver<Subject> getSubjectResolver() {
        return this.subjectResolver;
    }

    public void setSubjectResolver(Resolver<Subject> subjectResolver) {
        this.subjectResolver = subjectResolver;
    }

    public Filter[] getFilters() {
        return this.filters;
    }

    public void setFilters(Filter[] filters) {
        this.filters = filters;
    }
}

