/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ReadConnectionPool
extends ConnectionPool {
    public ReadConnectionPool() {
    }

    public ReadConnectionPool(String name, Login login, ServerSession owner) {
        super(name, login, owner);
    }

    public ReadConnectionPool(String name, Login login, int minNumberOfConnections, int maxNumberOfConnections, ServerSession owner) {
        super(name, login, minNumberOfConnections, maxNumberOfConnections, owner);
    }

    public ReadConnectionPool(String name, Login login, int initialNumberOfConnections, int minNumberOfConnections, int maxNumberOfConnections, ServerSession owner) {
        super(name, login, initialNumberOfConnections, minNumberOfConnections, maxNumberOfConnections, owner);
    }

    public synchronized Accessor acquireConnection() throws ConcurrencyException {
        Accessor leastBusyConnection = null;
        int size = this.connectionsAvailable.size();
        for (int index = 0; index < size; ++index) {
            Accessor connection = (Accessor)this.connectionsAvailable.get(index);
            if (this.checkConnections) {
                if (this.getOwner().getLogin().isConnectionHealthValidatedOnError() && this.getOwner().getServerPlatform().wasFailureCommunicationBased(null, connection, this.getOwner())) {
                    this.connectionsAvailable.remove(index);
                    --index;
                    --size;
                    continue;
                }
                this.checkConnections = false;
            }
            if (connection.getCallCount() == 0) {
                connection.incrementCallCount(this.getOwner());
                return connection;
            }
            if (leastBusyConnection != null && leastBusyConnection.getCallCount() <= connection.getCallCount()) continue;
            leastBusyConnection = connection;
        }
        if (this.connectionsAvailable.size() + this.connectionsUsed.size() < this.maxNumberOfConnections) {
            Accessor connection = this.buildConnection();
            this.connectionsAvailable.add(connection);
            connection.incrementCallCount(this.getOwner());
            return connection;
        }
        leastBusyConnection.incrementCallCount(this.getOwner());
        return leastBusyConnection;
    }

    public boolean hasConnectionAvailable() {
        return true;
    }

    public synchronized void releaseConnection(Accessor connection) throws DatabaseException {
        connection.decrementCallCount();
        if (!connection.isValid()) {
            this.getOwner().setCheckConnections();
            this.connectionsAvailable.remove(connection);
            try {
                connection.disconnect(this.getOwner());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

