/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;

public class IdentityMapKeyEnumeration
implements Enumeration {
    protected FullIdentityMap map;
    protected Iterator cacheKeysIterator;
    protected CacheKey nextKey;
    protected boolean shouldCheckReadLocks;

    public IdentityMapKeyEnumeration(FullIdentityMap map) {
        this(map, true);
    }

    public IdentityMapKeyEnumeration(FullIdentityMap map, boolean shouldCheckReadLocks) {
        this.map = map;
        this.shouldCheckReadLocks = shouldCheckReadLocks;
        this.cacheKeysIterator = map.getCacheKeys().values().iterator();
    }

    public boolean hasMoreElements() {
        this.nextKey = this.getNextCacheKey();
        return this.nextKey != null;
    }

    public Object nextElement() {
        if (this.nextKey == null) {
            throw new NoSuchElementException("IdentityMapKeyEnumeration nextElement");
        }
        if (this.shouldCheckReadLocks) {
            this.nextKey.checkReadLock();
        }
        return this.nextKey;
    }

    protected CacheKey getNextCacheKey() {
        CacheKey key = null;
        while (this.cacheKeysIterator.hasNext() && key == null) {
            key = (CacheKey)this.cacheKeysIterator.next();
        }
        return key;
    }

    public boolean getShouldCheckReadLocks() {
        return this.shouldCheckReadLocks;
    }

    public void setShouldCheckReadLocks(boolean shouldCheckReadLocks) {
        this.shouldCheckReadLocks = shouldCheckReadLocks;
    }
}

